Object.defineProperty(exports, "__esModule", { value: true });
























var _react = require("react");var _react2 = _interopRequireDefault(_react);
var _propTypes = require("prop-types");var _propTypes2 = _interopRequireDefault(_propTypes);
var _classnames = require("classnames");var _classnames2 = _interopRequireDefault(_classnames);
var _textArea = require("../form/textArea");var _textArea2 = _interopRequireDefault(_textArea);
var _select = require("../form/select");var _select2 = _interopRequireDefault(_select);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };}function _defineProperty(obj, key, value) {if (key in obj) {Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });} else {obj[key] = value;}return obj;}

class EditableContent extends _react2.default.PureComponent {
  get hasValue() {
    const { input, value } = this.props;
    return !!(value || input && input.props.value);
  }

  get isSelect() {
    const { input, inputComponent } = this.props;
    return inputComponent === _select2.default || input && input.type == _select2.default;
  }

  get isTextarea() {
    const { input, inputComponent } = this.props;
    return inputComponent === _textArea2.default || input && input.type === _textArea2.default;
  }

  get displayValue() {
    const { options, display, input } = this.props;
    const value = this.props.value || input && input.props.value;
    const placeholder = this.props.placeholder || input && input.props.placeholder;

    if (!this.hasValue) {return placeholder;}
    if (display) {return display;}

    if (this.isSelect && options) {
      const displayValue = options.find((e) => e.value == value);
      return displayValue ? displayValue.label : value;
    }

    return value;
  }

  render() {
    const className = {
      'editable-content': true,
      'placeholder': !this.hasValue };


    return /*#__PURE__*/_react2.default.createElement("div", { className: (0, _classnames2.default)(this.props.className, className) }, this.displayValue);
  }}_defineProperty(EditableContent, "defaultProps",

{
  value: '',
  placeholder: '' });_defineProperty(EditableContent, "propTypes",


{
  display: _propTypes2.default.string,
  input: _propTypes2.default.element,
  inputComponent: _propTypes2.default.elementType,
  options: _propTypes2.default.array,
  placeholder: _propTypes2.default.string,
  value: _propTypes2.default.oneOfType([
  _propTypes2.default.string,
  _propTypes2.default.number]) });exports.default =




EditableContent;