function ownKeys(object, enumerableOnly) {var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {var symbols = Object.getOwnPropertySymbols(object);enumerableOnly && (symbols = symbols.filter(function (sym) {return Object.getOwnPropertyDescriptor(object, sym).enumerable;})), keys.push.apply(keys, symbols);}return keys;}function _objectSpread(target) {for (var i = 1; i < arguments.length; i++) {var source = null != arguments[i] ? arguments[i] : {};i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {_defineProperty(target, key, source[key]);}) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));});}return target;}function _defineProperty(obj, key, value) {if (key in obj) {Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });} else {obj[key] = value;}return obj;} // eslint-disable-next-line no-unused-vars
var mendeleyAPIUtils = function () {
  const ZOTERO_OAUTH_URL = 'https://www.zotero.org/utils/mendeley/oauth';
  const OAUTH_URL = 'https://api.mendeley.com/oauth/token';
  const MENDELEY_API_URL = 'https://api.mendeley.com';
  const CLIENT_ID = '6';
  const CLIENT_NOT_VERY_SECRET = 'JtSAMzFdwC6RAED3RMZU';
  const USER_AGENT = 'Mendeley Desktop/1.18';

  const getTokens = async (url, bodyProps, headers = {}, options = {}) => {
    const body = Object.entries(bodyProps).
    map(([k, v]) => `${encodeURIComponent(k)}=${encodeURIComponent(v)}`).
    join('&');

    headers = _objectSpread(_objectSpread({}, headers), {}, { 'Content-Type': 'application/x-www-form-urlencoded' });

    if (!Zotero.Prefs.get('import.mendeleyUseOAuth')) {
      headers['User-Agent'] = USER_AGENT;
    }

    options = _objectSpread(_objectSpread({}, options), {}, { body, headers, timeout: 30000 });
    const response = await Zotero.HTTP.request('POST', url, options);
    return JSON.parse(response.responseText);
  };

  const directAuth = async (username, password, headers = {}, options = {}) => {
    const bodyProps = {
      client_id: CLIENT_ID, // eslint-disable-line camelcase
      client_secret: CLIENT_NOT_VERY_SECRET, // eslint-disable-line camelcase
      grant_type: 'password', // eslint-disable-line camelcase
      password,
      scope: 'all',
      username };


    return getTokens(OAUTH_URL, bodyProps, headers, options);
  };

  const codeAuth = async (code, headers = {}, options = {}) => {
    const bodyProps = {
      grant_type: 'authorization_code', // eslint-disable-line camelcase
      code };


    return getTokens(ZOTERO_OAUTH_URL, bodyProps, headers, options);
  };

  const refreshAuth = async (refreshToken, headers = {}, options = {}) => {
    const bodyProps = {
      grant_type: 'refresh_token', // eslint-disable-line camelcase
      refresh_token: refreshToken // eslint-disable-line camelcase
    };

    if (!Zotero.Prefs.get('import.mendeleyUseOAuth')) {
      bodyProps.client_id = CLIENT_ID; // eslint-disable-line camelcase
      bodyProps.client_secret = CLIENT_NOT_VERY_SECRET; // eslint-disable-line camelcase
    }

    return getTokens(
    Zotero.Prefs.get('import.mendeleyUseOAuth') ? ZOTERO_OAUTH_URL : OAUTH_URL,
    bodyProps, headers, options);

  };

  const getNextLinkFromResponse = (response) => {
    let next = null;
    let links = response.getResponseHeader('link');
    if (links) {
      const matches = links.match(/<(.*?)>;\s+rel="next"/i);

      if (matches && matches.length > 1) {
        next = matches[1];
      }
    }
    return next;
  };


  const apiFetchUrl = async (tokens, url, headers = {}, options = {}) => {
    headers = _objectSpread(_objectSpread({}, headers), {}, { Authorization: `Bearer ${tokens.access_token}` });
    options = _objectSpread(_objectSpread({}, options), {}, { headers, timeout: 60000 });
    const method = 'GET';

    // Run the request. If we see 401 or 403, try to refresh tokens and run the request again
    try {
      return await Zotero.HTTP.request(method, url, options);
    }
    catch (e) {
      if (e.status === 401 || e.status === 403) {
        const newTokens = await refreshAuth(tokens.refresh_token);
        // update tokens in the tokens object and in the header for next request
        tokens.access_token = newTokens.access_token; // eslint-disable-line camelcase
        tokens.refresh_token = newTokens.refresh_token; // eslint-disable-line camelcase
        headers.Authorization = `Bearer ${tokens.access_token}`;
      }
    }

    return Zotero.HTTP.request(method, url, options);
  };

  const apiFetch = async (tokens, endPoint, params = {}, headers = {}, options = {}) => {
    const stringParams = Object.entries(params).map((p) => p.join('=')).join('&');
    const url = MENDELEY_API_URL + '/' + endPoint + '?' + stringParams;
    return apiFetchUrl(tokens, url, headers, options);
  };

  const get = async (tokens, endPoint, params = {}, headers = {}, options = {}) => {
    const response = await apiFetch(tokens, endPoint, params, headers, options);
    return JSON.parse(response.responseText);
  };

  const getAll = async (tokens, endPoint, params = {}, headers = {}, options = {}, interruptChecker = () => {}) => {
    const PER_PAGE = endPoint === 'annotations' ? 200 : 500;
    const response = await apiFetch(tokens, endPoint, _objectSpread(_objectSpread({}, params), {}, { limit: PER_PAGE }), headers, options);
    var next = getNextLinkFromResponse(response);
    var data = JSON.parse(response.responseText);
    interruptChecker();

    while (next) {
      const response = await apiFetchUrl(tokens, next, headers, options); //eslint-disable-line no-await-in-loop
      data = [...data, ...JSON.parse(response.responseText)];
      next = getNextLinkFromResponse(response);
      interruptChecker();
    }

    return data;
  };

  return { codeAuth, directAuth, getNextLinkFromResponse, apiFetch, apiFetchUrl, get, getAll };
}();