#!/bin/bash

set_prompt()
{
   local last_cmd=$?
   local txtreset='$(tput sgr0)'
   local txtbold='$(tput bold)'
   local txtblack='$(tput setaf 0)'
   local txtred='$(tput setaf 1)'
   local txtgreen='$(tput setaf 2)'
   local txtyellow='$(tput setaf 3)'
   local txtblue='$(tput setaf 4)'
   local txtpurple='$(tput setaf 5)'
   local txtcyan='$(tput setaf 6)'
   local txtwhite='$(tput setaf 7)'

   local sad=':('
   local happy=':)'
   [ "$USER" == "" ] && USER="unknown"
   PS1="\[$txtbold\["
   if [[ $UID == 0 ]]; then
       PS1+="\[$txtred\]$USER"
   else
       PS1+="\[$txtyellow\]$USER"
   fi

   PS1+="\[$txtreset\]@\[$txtbold\]\[$txtblue\]$(hostname):"
   PS1+="\[$txtcyan\]$(pwd | xargs basename) "
   
   if [[ $last_cmd == 0 ]]; then
      PS1+="\[$txtgreen\]$happy \[$txtwhite\]"
   else
      PS1+="\[$txtred\]$sad \[$txtwhite\]($last_cmd) "
   fi

   if [ "$(which git 2>/dev/null)" != "" ] ; then
      local branch="$(git branch 2>/dev/null | grep '^*' | awk '{print $2}')"
      [ "$branch" == "" ] || PS1+="\[$txtpurple\][$branch]"
   fi

   if [ $UID -eq 0 ] && [ "$(stat -c %d:%i /)" != "$(stat -c %d:%i /proc/1/root/.)" ] &>/dev/null ; then
      PS1+="\[$txtgreen\] (chroot)"
   elif grep docker /proc/1/cgroup -qa &>/dev/null; then
      PS1+="\[$txtgreen\] (docker)"
   fi


   PS1+="\[$txtyellow\[\[\033[5m\] >\[$txtreset\[ "
}

[ "$NOPS1" == "1" ] || PROMPT_COMMAND='set_prompt;history -a; history -r'

