#!/bin/bash
# https://serverfault.com/questions/3743/what-useful-things-can-one-add-to-ones-bashrc#3842
extract () {
   if [ -f $1 ] ; then
       case $1 in
           *.tar.bz2)   tar xvjf $1    ;;
           *.tar.gz)    tar xvzf $1    ;;
           *.bz2)       bunzip2 $1     ;;
           *.rar)       unrar x $1       ;;
           *.gz)        gunzip $1      ;;
           *.tar)       tar xvf $1     ;;
           *.tbz2)      tar xvjf $1    ;;
           *.tgz)       tar xvzf $1    ;;
           *.zip)       unzip $1       ;;
           *.Z)         uncompress $1  ;;
           *.7z)        7z x $1        ;;
           *.ar)        ar x $1        ;;
           *)           echo "don't know how to extract '$1'..." ;;
       esac
   else
       echo "'$1' is not a valid file!"
   fi
}

up(){
  local d=""
  limit=$1
  for ((i=1 ; i <= limit ; i++))
    do
      d=$d/..
    done
  d=$(echo $d | sed 's/^\///')
  if [ -z "$d" ]; then
    d=..
  fi
  cd $d
}

fawk() {
    first="awk '{print "
    last="}'"
    cmd="${first}\$${1}${last}"
    eval $cmd
}
copyfile() {
    cat "$1" | xclip -selection clipboard
}
grh() {
    grep -rn ./ -e "$1"
}
genpwd() { strings /dev/urandom | grep -o '[[:alnum:]]' | head -n "$1" | tr -d '\n'; echo; }

chmount(){
for i in /dev /sys /proc /run
do
	mkdir -p $1/$i 2>/dev/null || true
	umount -R -lf $1/$i &>/dev/null || true
	mount --bind $i $1/$i
done
chroot $*
}
swap(){ 
    local TMPFILE=tmp.$$

    [ $# -ne 2 ] && echo "swap: 2 arguments needed" && return 1
    [ ! -e $1 ] && echo "swap: $1 does not exist" && return 1
    [ ! -e $2 ] && echo "swap: $2 does not exist" && return 1

    mv "$1" $TMPFILE
    mv "$2" "$1"
    mv $TMPFILE "$2"
}
no(){
while true
do
    echo "n"
done
}
organize(){
    if [ ! -d "$1" ] ; then
        echo "$1 is not a directory."
        exit 1
    fi
    find "$1" -type f | while read line ; do
        ftype=$(file "$line" -i | cut -f 2 -d " " | sed "s/;//g")
        [ -d $ftype ] || mkdir -p $ftype &>/dev/null
        mv "$line" "$ftype/$line"
    done
}
