
#ifndef KIOWIDGETS_EXPORT_H
#define KIOWIDGETS_EXPORT_H

#ifdef KIOWIDGETS_STATIC_DEFINE
#  define KIOWIDGETS_EXPORT
#  define KIOWIDGETS_NO_EXPORT
#else
#  ifndef KIOWIDGETS_EXPORT
#    ifdef KF5KIOWidgets_EXPORTS
        /* We are building this library */
#      define KIOWIDGETS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KIOWIDGETS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KIOWIDGETS_NO_EXPORT
#    define KIOWIDGETS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KIOWIDGETS_DECL_DEPRECATED
#  define KIOWIDGETS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KIOWIDGETS_DECL_DEPRECATED_EXPORT
#  define KIOWIDGETS_DECL_DEPRECATED_EXPORT KIOWIDGETS_EXPORT KIOWIDGETS_DECL_DEPRECATED
#endif

#ifndef KIOWIDGETS_DECL_DEPRECATED_NO_EXPORT
#  define KIOWIDGETS_DECL_DEPRECATED_NO_EXPORT KIOWIDGETS_NO_EXPORT KIOWIDGETS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KIOWIDGETS_NO_DEPRECATED
#    define KIOWIDGETS_NO_DEPRECATED
#  endif
#endif

#define KIOWIDGETS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KIOWIDGETS_NO_DEPRECATED) && !defined(KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KIOWIDGETS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KIOWIDGETS_NO_DEPRECATED_WARNINGS) && !defined(KIOWIDGETS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KIOWIDGETS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KIOWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KIOWIDGETS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KIOWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KIOWIDGETS_NO_DEPRECATED)
#  undef KIOWIDGETS_DEPRECATED
#  define KIOWIDGETS_DEPRECATED_EXPORT KIOWIDGETS_EXPORT
#  define KIOWIDGETS_DEPRECATED_NO_EXPORT KIOWIDGETS_NO_EXPORT
#elif defined(KIOWIDGETS_NO_DEPRECATED_WARNINGS)
#  define KIOWIDGETS_DEPRECATED
#  define KIOWIDGETS_DEPRECATED_EXPORT KIOWIDGETS_EXPORT
#  define KIOWIDGETS_DEPRECATED_NO_EXPORT KIOWIDGETS_NO_EXPORT
#else
#  define KIOWIDGETS_DEPRECATED KIOWIDGETS_DECL_DEPRECATED
#  define KIOWIDGETS_DEPRECATED_EXPORT KIOWIDGETS_DECL_DEPRECATED_EXPORT
#  define KIOWIDGETS_DEPRECATED_NO_EXPORT KIOWIDGETS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIOWIDGETS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIOWIDGETS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIOWIDGETS_NO_DEPRECATED
#  define KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 344064
#endif
#ifdef KIOWIDGETS_NO_DEPRECATED_WARNINGS
#  define KIOWIDGETS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIOWIDGETS_DEPRECATED_WARNINGS_SINCE
#  ifdef KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIOWIDGETS_DEPRECATED_WARNINGS_SINCE KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIOWIDGETS_DEPRECATED_WARNINGS_SINCE 344064
#  endif
#endif

#ifndef KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KIOWIDGETS_DEPRECATED
#  define KIOWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KIOWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIOWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 262144
#  define KIOWIDGETS_DEPRECATED_VERSION_4_0(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_4_0(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 262400
#  define KIOWIDGETS_DEPRECATED_VERSION_4_1(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_4_1(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 262912
#  define KIOWIDGETS_DEPRECATED_VERSION_4_3(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_4_3(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 263168
#  define KIOWIDGETS_DEPRECATED_VERSION_4_4(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_4_4(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 263424
#  define KIOWIDGETS_DEPRECATED_VERSION_4_5(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_4_5(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 263680
#  define KIOWIDGETS_DEPRECATED_VERSION_4_6(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_4_6(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 263936
#  define KIOWIDGETS_DEPRECATED_VERSION_4_7(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_4_7(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 327680
#  define KIOWIDGETS_DEPRECATED_VERSION_5_0(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_5_0(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 328704
#  define KIOWIDGETS_DEPRECATED_VERSION_5_4(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_5_4(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 329216
#  define KIOWIDGETS_DEPRECATED_VERSION_5_6(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_5_6(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 334080
#  define KIOWIDGETS_DEPRECATED_VERSION_5_25(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_5_25(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 335616
#  define KIOWIDGETS_DEPRECATED_VERSION_5_31(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_5_31(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 335872
#  define KIOWIDGETS_DEPRECATED_VERSION_5_32(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_5_32(text)
#endif

#if KIOWIDGETS_DEPRECATED_WARNINGS_SINCE >= 344064
#  define KIOWIDGETS_DEPRECATED_VERSION_5_64(text) KIOWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOWIDGETS_DEPRECATED_VERSION_5_64(text)
#endif
#define KIOWIDGETS_DEPRECATED_VERSION_4(minor, text)      KIOWIDGETS_DEPRECATED_VERSION_4_##minor(text)
#define KIOWIDGETS_DEPRECATED_VERSION_5(minor, text)      KIOWIDGETS_DEPRECATED_VERSION_5_##minor(text)
#define KIOWIDGETS_DEPRECATED_VERSION(major, minor, text) KIOWIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)

#endif /* KIOWIDGETS_EXPORT_H */
