/* du.c -- does the same as the UNIX command -- written in C */

/* james minyard */

#include        <sys/types.h>
#include        <dirent.h>
#include        <sys/stat.h>
#include        <string.h>
#include	<stdio.h>
#include	<process.h>
#include 	<dir.h>
#include 	<malloc.h>
#include 	<alloc.h>

#define		PATHLEN           59

char		*orig_dir;

long            du1(const char *);

long		dirsum(const char *);

int 		S_ISDIR(short);

int
main(int argc, char *argv[])
{
	char           *dir;
	long		total;

	if (argc > 2) {
		printf("usage: du (start path)");
		exit(0);
	}
	/* for correct usage */

	orig_dir= (char *) malloc(PATHLEN);
	strcpy(orig_dir,getcwd(orig_dir,PATHLEN));

	if (argc==1)
		dir=".";
		else
		dir = argv[1];
	chdir(dir);
	if ((dir = (char *) malloc(PATHLEN)) == NULL) {
		printf("MEMORY ERROR: exit(1)\n");
		chdir(orig_dir);
		exit(1);
	}
	strcpy(dir, (char *) getcwd(dir , PATHLEN));
	/* to get absolute path of original path parameter */

	total=du1(dir)+dirsum(dir);
	printf("Total from %s is %ld\n",dir,total);
	/* call recursive tree traverser */

	free(dir);
	chdir(orig_dir);
	free(orig_dir);
	return(0);
}

long
du1(const char *ch)
{
	DIR            *dp;     /* stuff for opening a directory */
	struct dirent  *dirp;

	char           *fname;  /* stuff for stat (2) */
	struct stat     st;

	long total = 0;

	if ((dp = opendir((char *) ch)) == NULL) {
		printf("can't open %s\n", ch);
		return (0);
	}

	while ((dirp = readdir(dp)) != NULL) {

		if (!strcmp(dirp->d_name, "."))
			continue;       /* eliminates  . */
		if (!strcmp(dirp->d_name, ".."))
			continue;       /* eliminates .. */

		if ((fname = (char *) malloc(PATHLEN)) == NULL) {
			printf("MEMORY ERROR in du1: exit(1)\n");
			chdir(orig_dir);
			exit(1);
		}
		strcpy(fname, ch);
		if (fname[strlen(fname)-1]!='\\')
			strcat(fname, "\\");
		strcat(fname, dirp->d_name);
		/* attach absolut path & filename for stat */

		if (stat(fname, &st) < 0) {
			printf("stat error - %s\n", fname);
			free(fname); }
		else if (S_ISDIR(st.st_mode))
			{
			total+=du1(fname)+dirsum(fname);
/*			printf("%10ld %s\n",total,fname);
*/               	free(fname);
			}
		/* recurse on directories */
	}

/*	free(fname); */
	if (closedir(dp)) {
		printf("closedir() error: exit(1)\n");
		exit(1);
	}
	return (total);
}

long
dirsum(const char *ch)
{
	DIR            *dp;     /* stuff for opening a directory */
	struct dirent  *dirp;

	char           *fname;  /* stuff for stat (2) */
	struct stat     st;

	long total = 0;

	if ((dp = opendir((char *) ch)) == NULL) {
		printf("can't open %s\n", ch);
		return (1);
	}

	/* get total size of files in directory */
	while ((dirp = readdir(dp)) != NULL) {

		if (!strcmp(dirp->d_name, "."))
			continue;       /* eliminates  . */
		if (!strcmp(dirp->d_name, ".."))
			continue;       /* eliminates .. */

		if ((fname = (char *) malloc(PATHLEN)) == NULL) {
			printf("MEMORY ERROR in dirsum: exit(1)\n");
			chdir(orig_dir);
			exit(1);
		}
		strcpy(fname, ch);
		if ((fname[strlen(fname)-1])!='\\')
			strcat(fname, "\\");
		strcat(fname, dirp->d_name);
		/* attach absolut path & filename for stat */

		if (stat(fname, &st) < 0)
			printf("stat error - %s\n", fname);
		else
			total+=st.st_size;
		free(fname);
	}

	printf("%10ld %s\n",total,ch);
/*	free(fname); */
	if (closedir(dp)) {
		printf("closedir() error: exit(1)\n");
		exit(1);
	}
	return (total);
}


int S_ISDIR(short t)
{
return(S_IFDIR & t);
}
