-- blowfish.e - Blowfish encryption algorithm module
-- Created for use with the Block Cipher Library, version 1.0
-- Copyright (C) 2000  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- You can get the latest version of this program from my Euphoria page:
-- http://www16.brinkster.com/davitf/


include machine.e

-- Allocate memory for the input/output of the routines
constant x_address=allocate(8)

-- Allocate memory for the subkeys
constant data_address=allocate(72+1024+1024+1024+1024),
	 p_address=data_address,
	 s1_address=p_address+72,
	 s2_address=s1_address+1024,
	 s3_address=s2_address+1024,
	 s4_address=s3_address+1024

-- Allocate memory for the machine code routines
constant bf_key = allocate(138),bf_enc = allocate(196),bf_dec = allocate(196)


-- Write the machine code routines into the memory

-- These are Assembly routines compiled with Pete Eberlein's ASM to
-- Euphoria converter and transformed into strings to save space.
-- If you want to see their source, read the .asm files in the Blowfish
-- package.

-- bf_key is used in the subkey generation stage
poke(bf_key, and_bits(#FF,
"eM7ɬ߭5nm--n75nm--n5nm-"+84&
"LTLL#&NL=lNTn%$&#"+53))

-- bf_enc is the Blowfish encryption routine
poke(bf_enc, and_bits(#FF,
"e744mm44744mm44߭5nm--n7"+84&
"TLLTLLTLL#&NL"+53&
"=lNSSیSSTSSیSST%$&#"+53))

-- bf_enc is the Blowfish decryption routine
poke(bf_dec, and_bits(#FF,
"e744mm44744mm44/߭/5m-"+84&
"q{yʱqqyʱqq#yʱqqK!H#"+16&
"karrrrsrrȫrrsDCEB"+22))

-- Write the necessary values to memory
poke4(bf_key + 5, p_address)
poke4(bf_key + 10, x_address)
poke4(bf_key + 16, x_address+4)
poke4(bf_key + 37, s1_address)
poke4(bf_key + 56, s2_address)
poke4(bf_key + 75, s3_address)
poke4(bf_key + 94, s4_address)
poke4(bf_key + 109, p_address+64)
poke4(bf_key + 124, x_address)
poke4(bf_key + 129, x_address+4)

poke4(bf_enc + 5, p_address)
poke4(bf_enc + 11, x_address)
poke4(bf_enc + 31, x_address+4)
poke4(bf_enc + 66, s1_address)
poke4(bf_enc + 85, s2_address)
poke4(bf_enc + 104, s3_address)
poke4(bf_enc + 123, s4_address)
poke4(bf_enc + 138, p_address+64)
poke4(bf_enc + 167, x_address)
poke4(bf_enc + 187, x_address+4)

poke4(bf_dec + 5, p_address+68)
poke4(bf_dec + 11, x_address)
poke4(bf_dec + 31, x_address+4)
poke4(bf_dec + 74, s1_address)
poke4(bf_dec + 93, s2_address)
poke4(bf_dec + 112, s3_address)
poke4(bf_dec + 131, s4_address)
poke4(bf_dec + 145, p_address)
poke4(bf_dec + 167, x_address)
poke4(bf_dec + 187, x_address+4)


-- The digits of Pi as used in Blowfish (subkey arrays),
-- also converted into strings.

constant pbox_init = and_bits(#FF,
"Ś.ctn^}d+UcǩGA|n+*"-91&
"ߍ-\nUJq`8*h7<"-33&"y")

global constant sbox_init = and_bits(#FF,
"]clO)nчfoM5!G3qP6PXۮ#HjͳE< "+73&
"0ְo&? |GOֆ狌k"-50&"= m70m5%NEŽ醛"-13&
"$.Pv$T4׍+=aGEŎvrvk\t;kkx^mV*yOk&@JrW\'Ŝj"-22&
";/)u@\n(_Sg{(8M"+52&
"xWMm`p@\rFM.F ѡmW"-37&
"`c%]vP_9 \nGgჭhx"-116&
"Kj_ Ci\"mb\rhԬӡRki0U)"-1&
"OsK/${S0{j;]1Ay~\nNY.߯"-64&
"ģ}Z?ाc9_ŉum%^U"-31&
"a~e:3um36Mr>#T,նj~;7ZAKY}aF"-99&
"ELo&IOE8PS.Q->DzAȢ{ʮ$*"+113&
"I:,M`;zǰ[0ȫ%H=E¶܈OXxP6:=҇ݗC}"-125&
"/˅W~%xTQBQ{48oΕnĺV!w"-89&"I>vgAu#Dг"-68&
"BSWn M;w>$"-120&"Y}(6%*p̮m޽e\n݅P9"+51&
"J[-ySeEIҐK3~ˤA"&
"6 K\nrR!iledEbtg?b"+44&
"vۼB)=֫rY9Yc7Tc\n֯8"-71&
"kfq5|3_I͊^2-sjWG\rfruѻ?:fk$`"+66&
"=Us^QqUCdؓU 2"+34&"L^|O8*-]ܽԯ\rb j"+81&
"<qP~>8#\n7}os]ےmtu:"-26&
"+,OB:jswVps={)zD>R|h8\r͉T)"-41&
"L:\"6a0.Ą/!P({"+53&
"ތMLʳ.nsN hk^\t$32Զ1D\\߮&"-69&
"V9ʭ\tԧ4άx.,1jx#jӋ-0f5|zU"+108&
"ES.Q4jq1W\"|\tJ"-104&
"L~NcN%39]~!TS7Kfc7FGIa<Sl"-71&
"uIa4+L9z.m_R"+72&
"\rU|st!PEyۺMg,_7"+84&
"HCMDJ6Rld_"-64&
")!+ǤGX8+n=G3i杸1`q0!ճեd"-25&
"RUUcDϬr;,-XqB~F#+\n{-ΓkiFM|"-105&
"&gֹ^4\t#y޽O+_àđ-un"+120&
"19:0kݭ{T]\"()IMi}[&^9E|"-63&
"z>$2S:{gaC%#*ۍhQ"-21&
"7/hEY2-xfXqJatTTC^MN29&Z%Ѐ"-59&
"KCnGyTɷm\"4M -`s0m"+56&"x$8sxqj^Pr&5Y^y"-73&
"f0WΝiD*\rO<\n88oxDeV fAEE6"+102&
"v&l!q+Xbm:bpH2D9)!"-8&
"bNԔߎO΄:Dhimߌe-v="-87&
"|qt3S_2>Mڞ^vq!厨/"+37&
"bW\r:mpih}Dk|lWa5fێ^4`lh)(!YNIxrE39m"-126&
"a})z4#ƣ@ݙN+X"-92&
"XIƨ?{Ɗ4=|MH4BW^v"-52&
"<G^FouBąC>(-t0β@"-82&
"v1_#huqA\nF&RZKͻq"+15&
"ۥ啦$f6^*o4<<.q;ȡDƕ%&9Y`RHv"-97&
"x03D(6DisCvDmbD!O{A\tM!qU!Am"-77&
"mً*zX cHpoNyK>jG&wٻ"-42&"*Z vy?Qw\'f9?mP"+70&
"mάa!Q2ׯ{a\r=pc^+Gu"+121&
";OP:[5:cd(*|X\rGQ&|"+82&"k@5 ٫9N"&
"mRU$xsȦ\r>EUɕ8RBV{%PeV"-91&
"جV@E\'H::SU kKмgUX"&
"j~!06NzqIц~W=MRń|Yj"-85&
"r7߼xL$}x=~ֻ[0%?"+73&
"}cR-g!SNǣ\n\r.5zqTF0scA"+110&
"BV,S#zcsFZ{M3c"+63&
"+^z{HcJ۲U/:.cm\rラ"+26&
"rG^SÎQLH0fL1?5oa/d"-84&
"*0(ǫfÏUxΰ,b>)_@ΒTcf!؜K~p"+61&
"WMuw7r*53uU\rȓ\"|)-*>d7\'fHq"+4&
"{Zᠫ{P O$\nodyԃcV3zA&2,JK|{sUuBS"-105&
"Ngd_ڈ鿾dW{x`M`"&
"{ؾuI(n|&DtO#h(x6"-120&
"w$轙BFUa.XXN8t½fStUuFa&z"&
"iWHbs=ol7L$N5o3j*৿问`&@|RS]纇"+34&
"hnm=Z#+D`ԅK9XXxU"-59&
"xyZu=<W\r+ou&S#2$W{t`n"+44&
"ЉP\rPra:*?\nJ&z!0[4m\'"-74&
"...Z7\'J\"(\rhW:uPqm跩vޥO%\t -h$\n?Y!"-108&
"g(ï8I;\tLp\'<WҲZ9A"+21&
"&$;5pXl>^,-SX1 \ty#"-94&
"مk`xiPƷ:>8EV)DnJڗݗ_Xqr"-41&
"nx^\rƝUFP[;:)h"-128&"d{Ӳ-pi 9[2UiX"+49&
"$}Bd.K|1p<Eڃ"+31&"&(::KbU/Rio"&
"4Nl\nu{|30Oތ)ά!F /ʋrr3"+11&
"0/RNk`%g\r;\r$_ܓX̓_cNF@w\n"+77&
"%Hx~cQȥ=^Gܮ#3$Ue\nDuS\r@Ue;"-80&
"\rچ6dqtQ巉e?khE?c=&pr#}?G~M"-74&
"QP \r美oXbA(Cb~$r3\')X&"+106&
"z{>d!Q2Ow~㶨F=)iSH"&
"?<4Pޙ\t)YM356r\tq\nLH\t#lG-"-44&
"ϠWjV1E&0!*^pPRy3[(OЇI"+20&
"ƍ4 hɅYj!z=>T&ܸD!sv\"S\n"-114&
"6xОkoPe{MJ1(WWE"-48&
"@&hj5M&{dvvgM+uɍ~tip|tWN4=Gjx}凷p"+83&
"g6|1O+Y:C"&
"᝺d\r_Į9Y\\c)[³d~!,pp&ω~2ͫ-"+56&
"\ra+U{]U\t!5R\\O]ۯ.F1I`"+67&
"d9KܦNGH`$6\n(me7{爗W1/"-25&
"ǏYNc!@pr]̗ ,Kv?$a"+54&
"~4:F8!|.%/.Nr|n8I"-104&
"nOƗ\'~|6ʦ\t=E؆PpJ"+44&
"ŘZjǝD2w4ά#AU~L(6ՅR"+121&
"kspߐ`d2B.rpPѼO޺vB"+26&"E=!W JyfsoR"-24)



-- 'General-purpose' routines

function uxor(atom data1,atom data2)
    -- Unsigned xor
    atom result
    result=xor_bits(data1,data2)
    if result<0 then return result+#100000000 else return result end if
end function


function rev_bytes_to_int(sequence s)
    -- bytes_to_int, with the elements of the sequence in reverse order
    -- adapted from bytes_to_int, in machine.e
    return s[4] +
	   s[3] * #100 +
	   s[2] * #10000 +
	   s[1] * #1000000
end function

function invert_word_end(sequence data)
    -- Inverts the order of the atoms inside each 4-atom block
    -- {1,2,3,4,5,6,7,8} becomes {4,3,2,1,8,7,6,5}

    atom a
    for temp=1 to length(data) by 4 do
	a=data[temp]
	data[temp]=data[temp+3]
	data[temp+3]=a
	a=data[temp+1]
	data[temp+1]=data[temp+2]
	data[temp+2]=a
    end for
    return data
end function


-- End of 'general-purpose' routines

-- Actual algorithm implementation starts here
global procedure bf_init(sequence bfkey)
    -- Initialize the subkeys, based on the secret key given.

    --  Key must be at least 72-char long.
    if length(bfkey)=0 then  bfkey={0}  end if -- possible case

    -- Expand key
    while length(bfkey)<72 do
	bfkey=bfkey&bfkey
    end while
    bfkey=invert_word_end(bfkey[1..72])


    -- Initialize boxes
    poke(p_address,xor_bits(pbox_init,bfkey))
    poke(s1_address,sbox_init)

    -- Encrypt all boxes with the all zero string
    poke4(x_address,{0,0})

    for n=0 to (18+4*256)-1 by 2 do
	call(bf_key)
	mem_copy(data_address+n*4,x_address,8)
    end for

end procedure


global function bf_enc_block(sequence data)
    -- Encrypts a 8-byte sequence (subkeys must be initialized first)

    poke(x_address,data)
    call(bf_enc)
    return peek({x_address,8})
end function


global function bf_dec_block(sequence data)
    -- Decrypts a 8-byte sequence (subkeys must be initialized first)

    poke(x_address,data)
    call(bf_dec)
    return peek({x_address,8})
end function

global function bf_get_status ()
    return peek ({data_address, 72+1024+1024+1024+1024})
end function

global procedure bf_set_status (sequence data)
    poke (data_address, data)
end procedure

global procedure bf_clean_status ()
    mem_set (data_address, 0, 72+1024+1024+1024+1024)
end procedure

global constant ALG_BLOWFISH = register_enc_alg ("Blowfish", "bf", 0, 8)

