-- enc_algs.e - Wrapper for the encryption algorithm modules
-- Created for use with the Block Cipher Library, version 1.0
-- Modified for use with HIP 2.0
-- Copyright (C) 2001  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- You can get the latest version of this program from my Euphoria page:
-- http://www16.brinkster.com/davitf/

global atom enc_alg, block_size
global sequence enc_algs
enc_algs = {}
enc_alg = 0
block_size = 0

global
constant ALG_NAME = 1, ALG_ID = 2, ALG_KEYSIZE = 3, ALG_BLOCKSIZE = 4, ALG_ROUTINES = 5,
	 ROUTINE_INIT = 1, ROUTINE_ENC = 2, ROUTINE_DEC = 3,
	 ROUTINE_GET = 4, ROUTINE_SET = 5, ROUTINE_CLEAN = 6

constant routine_extensions = {"_init","_enc_block","_dec_block",
		"_get_status", "_set_status", "_clean_status"}

global function register_enc_alg (sequence name, sequence id, atom key_size, atom block_size)

    enc_algs = append (enc_algs, {name, id, key_size, block_size, {}})
    return length(enc_algs)
end function

-- Insert algorithms here
include blowfish.e
include rijndael.e

procedure get_routine_ids()
    sequence ids, id
    ids = repeat(0, length(routine_extensions))

    for alg = 1 to length(enc_algs) do
	id = enc_algs [alg][ALG_ID]
	for n = 1 to length(routine_extensions) do
	    ids [n] = routine_id (id & routine_extensions[n])
	    if ids[n] = -1 then puts(1,"Could not find "&id & routine_extensions[n]) abort(1) end if
	end for
	enc_algs [alg][ALG_ROUTINES] = ids
    end for

end procedure

get_routine_ids()



global procedure clean_enc_status()

    if enc_alg = ALG_BLOWFISH then
	bf_clean_status ()
    elsif enc_alg = ALG_RIJNDAEL then
	rijndael_clean_status ()
    else
	call_proc (enc_algs [enc_alg][ALG_ROUTINES][ROUTINE_CLEAN], {})
    end if

end procedure

global function get_enc_status ()

    if enc_alg = ALG_BLOWFISH then
	return {enc_alg, bf_get_status()}
    elsif enc_alg = ALG_RIJNDAEL then
	return {enc_alg, rijndael_get_status()}
    else
	return {enc_alg, call_func (enc_algs [enc_alg][ALG_ROUTINES][ROUTINE_GET], {})}
    end if

end function

global procedure set_enc_status (object st)
    clean_enc_status ()

    enc_alg = st [1]


    if enc_alg = ALG_BLOWFISH then
	bf_set_status(st[2])
    elsif enc_alg = ALG_RIJNDAEL then
	rijndael_set_status(st[2])
    else
	call_proc (enc_algs [enc_alg][ALG_ROUTINES][ROUTINE_SET], {st[2]})
    end if

end procedure


function adjust_key_size (sequence key, atom size)
    if length(key) = 0 then key = {0} end if

    while length(key) < size do
	key = key & key
    end while

    return key [1..size]
end function


global procedure init_encrypt (atom enc_algorithm, sequence key)
    if enc_alg != 0 then
	clean_enc_status()
    end if

    enc_alg = enc_algorithm

    if enc_algs [enc_alg][ALG_KEYSIZE] then
	key = adjust_key_size (key, enc_algs [enc_alg][ALG_KEYSIZE])
    elsif length(key) = 0 then
	key = {0}
    end if


    if enc_alg = ALG_BLOWFISH then
	bf_init (key)
    elsif enc_alg = ALG_RIJNDAEL then
	rijndael_init (key)
    else
	call_proc (enc_algs [enc_alg][ALG_ROUTINES][ROUTINE_INIT], {key})
    end if

    block_size = enc_algs [enc_alg][ALG_BLOCKSIZE]
end procedure

global function enc_block (sequence data)

    if enc_alg = ALG_BLOWFISH then
	return bf_enc_block (data)
    elsif enc_alg = ALG_RIJNDAEL then
	return rijndael_enc_block (data)
    else
	return call_func (enc_algs [enc_alg][ALG_ROUTINES][ROUTINE_ENC], {data})
    end if

end function

global function dec_block (sequence data)

    if enc_alg = ALG_BLOWFISH then
	return bf_dec_block (data)
    elsif enc_alg = ALG_RIJNDAEL then
	return rijndael_dec_block (data)
    else
	return call_func (enc_algs [enc_alg][ALG_ROUTINES][ROUTINE_DEC], {data})
    end if

end function


