; Arcfour key initialization routine in Assembly
; Copyright (C) 2002 Davi T. Figueiredo
;
; Used in arcfour.e (version 1.12), available from http://www16.brinkster.com/davitf/
;
; Export or use of this program may be restricted in some countries.
; Please read arcfour.txt for more information and for its license terms
; and disclaimer.

push eax
push ebx
push ecx
push edx
push edi
push esi

xor eax, eax            ; EAX = 0
xor edx, edx            ; EDX = 0
mov ecx, state_address  ; ECX = &state[0]
mov ebx, ecx            ; EBX = &state[0]

; Initialize state array
InitState:
mov [ebx], al           ; state[N] = N
inc ebx
inc al
cmp al, 0
jne InitState

xor ebx, ebx            ; EBX = 0


mov esi, key_address    ; ESI = key address
xor edi, edi            ; EDI = current key char

Char:
mov dl, [ecx + eax]     ; DL = state[N]

add bl, [esi + edi]     ; B = B + current key char
add bl, dl              ; B = B + state[N]

; Swap state[N] and state[B]

mov dh, [ecx + ebx]     ; DH = state[B]
mov [ecx + ebx], dl     ; state[B] = state[N]
mov [ecx + eax], dh     ; state[N] = state[B] (the old one)

inc edi                     ; Move to next key char
cmp edi, key_length         ; End of key reached?

jb NotRestartKey            ; Not yet, skip key restart

xor edi, edi                ; Restart key

NotRestartKey:

inc eax                      ; Loop
cmp eax, 256
jb Char

; Now AL = 0

mov [a_address], al         ; Set A = 0
mov [b_address], al         ; Set B = 0

pop esi
pop edi
pop edx
pop ecx
pop ebx
pop eax
ret

