#ifdef __PACIFIC__

#include <stdio.h>
#include <assert.h>
#include <sys.h>
#include <string.h>
#include <stdlib.h>
#include <unixio.h>
#include <dos.h>
#include <stat.h>
#include "wat2pac.h"
#undef getcwd

int access(const char *name, int mode)
{
	struct stat buf;
	if (stat((char *)name, &buf) == -1) return -1;
	if(mode == F_OK) return 0;
	if(mode == R_OK && (buf.st_mode & S_IRUSR)) return 0;
	if(mode == W_OK && (buf.st_mode & S_IWUSR)) return 0;
	if(mode == X_OK && (buf.st_mode & S_IXUSR)) return 0;
	return -1;
}

void setdta(char far *dta)
{	union REGS rx;
	struct SREGS rs;

	assert(dta);
	rs.ds = FP_SEG(dta);
	rx.x.dx = FP_OFF(dta);
	rx.h.ah = 0x1A;
	intdosx(&rx, &rx, &rs);
}

char far *getdta(void)
{	union REGS rx;
	struct SREGS rs;

	rx.h.ah = 0x2F;
	intdosx(&rx, &rx, &rs);

	return MK_FP(rs.es, rx.x.bx);
}

char *strrev(char *str)
{
      char *p1, *p2;

      if (! str || ! *str)
            return str;
      for (p1 = str, p2 = str + strlen(str) - 1; p2 > p1; ++p1, --p2)
      {
            *p1 ^= *p2;
            *p2 ^= *p1;
            *p1 ^= *p2;
      }
      return str;
}

int fnsplit(const char *path, char *drive, char *dir, char *name, char *ext)
{
	int ret = 0;
	char *tdrv = NULL, *tdir = NULL, *tname = NULL, *text = NULL;
	if(path[1] == ':')
	{
		strcpy(tdrv, path);
		tdrv[2] = '\0';
	}
	if(strchr(path, '\\') != NULL)
	{
		strcpy(tdir, (path[1] == ':') ? &path[2] : path);
		*&strrchr(tdir, '\\')[1] = '\0';
	}
	strcpy(tname, (strchr(path, '\\') != NULL) ? &strchr(path,'\\')[1] : (path[1] == ':') ? &path[2] : path);
	*strrchr(tname, '.') = '\0';
	text = strrchr(path, '.');
	if(text != NULL) ret += EXTENSION;
	if(tname != NULL) ret += FILENAME;
	if(tdir != NULL) ret += DIRECTORY;
	if(tdrv != NULL) ret += DRIVE;
	drive = tdrv;
	dir = tdir;
	name = tname;
	ext = text;
	return ret;
}

static int findfile(struct find_t *ff, int mode, char *name, int attr)
{
	union REGS rx;
	struct SREGS rs;
	char far *curDTA = getdta();
	assert(curDTA);
	setdta((char far*)ff);
	if((rx.h.ah = mode) == 0x4E)
	{
		rs.ds = FP_SEG(name);
		rx.x.dx = FP_OFF(name);
		rx.x.cx = attr;
	}
	intdosx(&rx, &rx, &rs);
	setdta(curDTA);
	return (rx.x.cflag & 1)? (errno = rx.x.ax): 0;
}

int _dos_findfirst(char *name, int attr, struct find_t *ff)
{	return findfile(ff, 0x4E, name, attr);
}

int _dos_findnext(struct find_t *ff)
{	return findfile(ff, 0x4F, '\0', '\0');
}

int _getdrive(void)
{
	union REGS rx;
	rx.h.ah = 0x19;
	intdos(&rx, &rx);
	return rx.h.al + 1;
}

char *_getdcwd(int drive, char *dest, int len)
{
	sprintf(dest, "%c:", drive + 'A');
	strcat(dest, getcwd((char *)drive + 'A'));
	return dest;
}

char *getcurrentworkingdirectory(char *dest, int len)
{
	sprintf(dest, "%c:", _getdrive()-1+'A');
	strcat(dest, getcwd(NULL));
	return dest;
}

void _dos_getdrive(unsigned *drive)
{
	union REGS rx;
	rx.h.ah = 0x19;
	intdos(&rx, &rx);
	drive = (unsigned *)&rx.h.al + 1;
}

void _dos_setdrive(unsigned a, unsigned *total)
{
	union REGS rx;
	rx.h.ah = 0x0E;
	rx.h.dl = a - 1;
	intdos(&rx, &rx);
	total = (unsigned *)rx.h.al;
}

#endif
