/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include <bios.h>
#include <unistd.h>
#include <string.h>
#include <pc.h>

#include "Vga256.h"
#include "Sprite.h"
#include "Font.h"
#include "Intro.h"
//---------------------------------------------------------------------------
int CntX=0,CntY=0;
unsigned char pal[768],palFX[768];

Sprite *ptrLogo;
FontBMP *ptrCalisto;

bool flip=true;

const char *pres1="Nibbles v0.1, Copyright (C) 2000 ANDREA FAZZI";
const char *pres2="Nibbles comes with ABSOLUTELY NO WARRANTY";
const char *pres3="For detail read gpl.txt";

const char *presStrings[3]={pres1,pres2,pres3};

//---------------------------------------------------------------------------
bool PalMorph(int i1,int i2,unsigned char *pal_src,unsigned char *pal_dest) {

 int i;
 char cnt=0;

 for(i=0;i<3;i++) {

  if(pal_src[i1+i]==pal_dest[i2+i]) cnt++;

   else {

     if(pal_src[i+i1]>pal_dest[i+i2]) pal_dest[i+i2]++;
      else pal_dest[i+i2]--;

   }

 }

 if(cnt<3) return false;
  else return true;

}
//---------------------------------------------------------------------------
int Logo(DblBuf *DBuffer) {

unsigned char flipRed,flipGreen,flipBlue;
bool flip=false,morph_1=false,morph_2=true;

int flipCol_1=48;
int flipCol_2=48;
int delta_t=60000;
int c=0;

  LoadPalette(NULL,&palFX[0]);
  SetPalette(&palFX[0]);

  /*ptrCalisto->GotoXY(100,165);
  ptrCalisto->Print("press ENTER key...",ptrLogo->PtrSprite); */

  DBuffer->ClearBufPat(ptrLogo->PtrSprite);
  DBuffer->Flip();

  while(c!=7181) {


    if(kbhit())
     c=bioskey(0);

    if(c==283) return EXIT_FROM_LOGO;

    if(!flip)
     flip=FadingFX(&pal[0],&palFX[0],FADING_INTRO);

    if(flip) {

     delta_t=0;

      if(morph_2) {

         if(PalMorph(84,flipCol_1,&pal[0],&palFX[0])) {
          morph_1=true;
          morph_2=false;

          if(flipCol_2==84) flipCol_2=48;
           else flipCol_2=84;

         }
      }

      if(morph_1) {
        if(PalMorph(48,flipCol_2,&pal[0],&palFX[0])) {
         morph_2=true;
         morph_1=false;

         if(flipCol_1==48) flipCol_1=84;
          else flipCol_1=48;

        }
      }
     }

     SetPalette(&palFX[0]);

     usleep(delta_t);
     WaitForRetrace();

  }

  return 0;

}
//---------------------------------------------------------------------------
int Intro(DblBuf *DBuffer,unsigned char *scr) {

 unsigned char strCnt=0;

 LoadPalette("art/system.pal",&pal[0]);

 LoadPalette(NULL,&palFX[0]);
 SetPalette(&palFX[0]);

 ptrLogo= new Sprite;
 ptrCalisto=new FontBMP;

 ptrCalisto->Init(256);

  DBuffer->Init(scr);
  DBuffer->ClearBuf(0);

  ptrLogo->LoadFrom_RAW_File("art/logo.raw");
  ptrCalisto->LoadFromFile("font/calisto.fnt");

  // presentation strings

  DBuffer->ClearBuf(0);

  ptrCalisto->GotoXY(160-((strlen(presStrings[0])/2)*6),85);
  ptrCalisto->Print(presStrings[0],DBuffer->FrameBuf);

  ptrCalisto->GotoXY(160-((strlen(presStrings[1])/2)*6),100);
  ptrCalisto->Print(presStrings[1],DBuffer->FrameBuf);

  ptrCalisto->GotoXY(160-((strlen(presStrings[2])/2)*6),115);
  ptrCalisto->Print(presStrings[2],DBuffer->FrameBuf);

  DBuffer->Flip();

  while((!FadingFX(&pal[0],&palFX[0],FADING_INTRO))&&(!kbhit())) {

    WaitForRetrace();
    SetPalette(&palFX[0]);
    usleep(60000);

  };

  sleep(2);

  while((!FadingFX(&pal[0],&palFX[0],FADING_THE_END))&&(!kbhit())) {

    WaitForRetrace();
    SetPalette(&palFX[0]);
    usleep(60000);

  };

  sleep(1);

 // nibbles logo

  return(Logo(DBuffer));


}
//---------------------------------------------------------------------------

