/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include <math.h>
#include <stdio.h>

#include "Level.h"
#include "Vga256.h"
#include "MathFun.h"
//---------------------------------------------------------------------------
BoundRect::BoundRect() {}
//---------------------------------------------------------------------------
BoundRect::~BoundRect() {}
//---------------------------------------------------------------------------
LevelHeader::LevelHeader() : NumFood(0),NumBlock(0) {}
//---------------------------------------------------------------------------
LevelHeader::~LevelHeader() {}
//---------------------------------------------------------------------------
void LevelHeader::LoadFrom_SCP_File(char *filename) {

 FILE *scpfile;
 LevelName=new char[30];
 char *str=new char[30];
 int id,x,y,w,h,i;

  LevelProgr=0;
  NumLives=4;
  WormDeath=false;

  Arts=new Sprite;
  Arts->LoadFrom_SPR_File("art/x.spr");

  scpfile=fopen(filename,"rt");
  fscanf(scpfile,"%s %s",NULL,LevelName);

   for(i=0;i<strlen(LevelName);i++)
    if(LevelName[i]=='_') LevelName[i]=' ';

  fscanf(scpfile,"%s %d",NULL,&NumBlock);
  fscanf(scpfile,"%s %d",NULL,&NumFood);
  fscanf(scpfile,"%s %d %d %d",NULL,&StartX,&StartY,&StartSize);

   CurrSize=StartSize;
   Block=new BoundRect[NumBlock];
   Food=new FoodRect[NumFood];

   for(i=0;i<NumBlock;i++) {

    fscanf(scpfile,"%s %d",str,&id);

     if(strcmp(str,"Block")==0) {

      fscanf(scpfile,"%s %d",str,&w);
      fscanf(scpfile,"%s %d",str,&h);
      fscanf(scpfile,"%s %d",str,&x);
      fscanf(scpfile,"%s %d",str,&y);

      Block[id].Init(x,y,w,h);

     }
   }

   for(i=0;i<NumFood;i++) {

    fscanf(scpfile,"%s %d",str,&id);

     if(strcmp(str,"Food")==0) {

      fscanf(scpfile,"%s %s",NULL,str);
      fscanf(scpfile,"%s %d",NULL,&w);
      fscanf(scpfile,"%s %d",NULL,&h);
      fscanf(scpfile,"%s %d",NULL,&x);
      fscanf(scpfile,"%s %d",NULL,&y);

      Food[id].InitGraph(str);
      Food[id].Init(x,y,w,h);

     }
   }

  fclose(scpfile);

}
//---------------------------------------------------------------------------
void LevelHeader::Animations(DblBuf *buf) {

 int i;

  for(i=0;i<NumFood;i++)
   if(!Food[i].checked) Food[i].Display(buf);

}
//---------------------------------------------------------------------------
void BoundRect::Init(int posx,int posy,int w,int h) {

 x=posx;y=posy;
 W=w;H=h;
 checked=false;

}
//---------------------------------------------------------------------------
void BoundRect::DrawBound(unsigned char *buf) {

  int i;

   for(i=0;i<=W;i++) {
    PutPixel(buf,x+i,y,15);
    PutPixel(buf,x+i,y+H,15);
   }

   for(i=0;i<H;i++) {
    PutPixel(buf,x,y+i,15);
    PutPixel(buf,x+W,y+i,15);
   }

}
//---------------------------------------------------------------------------
bool BoundRect::Check(int headX,int headY,int headW,int headH,char dir) {

 int r,diff1,diff2;

 if(dir==1) {

    if((Range(headX,x,x+W)||Range(headX+headW,x,x+W))&&
       (Range(headY,y,y+H))) {

     checked=true;
     return true;

    }

    else return false;

 }

 else {

    if((Range(headY,y,y+H)||Range(headY+headH,y,y+H))&&
       (Range(headX,x,x+W))) {

     checked=true;
     return true;

     }

    else return false;

 }

}
//---------------------------------------------------------------------------
void FoodRect::InitGraph(char *filename) {

 GraphData=new Sprite;
 GraphData->LoadFrom_SPR_File(filename);

}
//---------------------------------------------------------------------------
void FoodRect::Display(DblBuf *buf) {

 GraphData->DrawSprite(x,y,buf->FrameBuf);

}
//---------------------------------------------------------------------------

