unit VGA;
interface
uses Crt, GrpTools, Yd, Dos, mouse, vga2;
var
 stars: array[0..120] of longint;
 starsi: array[0..120] of byte;
 VGAColor : Byte;
 Gx, Gy : Integer;
 MaxScrX : Integer;
 MinScrX : Integer;
 MaxScrY : Integer;
 MinScrY : Integer;
type

 YPCHeader = Record
                    Buff : Array[1..90,1..90] of Byte;
                 End;

 type
   FPointer = ^TFont;

Procedure VideoMode(I : Integer);
procedure SetColor(col,r,g,b:byte);
procedure ResetVga;
procedure SetVga;
Procedure ScreenLow;
Procedure ScreenHigh;
Procedure ClsVGA;
Procedure LPicVGA(X,Y,X1,Y1 : Integer;C0: Boolean;File_Name:String);
Procedure VGABar(X, Y, X1, Y1 : Integer);
Procedure VGAPixel(X,Y,Color : Integer);
Procedure VGADraw(A : Array of Byte; X, Y, MaxX : Integer; ALen : Longint);
Procedure VGAErase(A : Array of Byte; X, Y, MaxX : Integer; ALen : Longint);
Procedure DrawChar(Num, X,Y : Integer);
Procedure LoadFontMem(P : FPointer);
Procedure LoadFont(FntName : String);
Procedure OutFont(Str : String);
Procedure OutFontLn(Str : String);
Procedure LoadYpc(FileN : String; var P : YPcHeader);
Procedure DrawYpc(X,Y,X1,Y1 : Integer;C0: Boolean; P:YPCHeader);
Procedure Location(x,y : Integer);
Procedure WriteFade(Str : String; x,y,Del:Integer;Fade : Boolean);
Procedure ShowBarak(x,y,count : integer);
Procedure DrawCloud(x,y : Integer);
Procedure DrawSton(x,y : Integer);
Procedure DrawShemesh(x,y : Integer);
Procedure Demo;
Function VGAGPixel(X,Y : Integer) : Byte;
Procedure SDemo;
Procedure Mac2Font;
function gmenu(x,y,mcolor,lcolor,tcolor : Integer; pitems : string) : byte;

Const
  Smile: array [0..63] of byte =

  (

  00,00,44,44,44,44,00,00,
  00,44,44,44,44,44,44,00,
  44,44,00,44,44,00,44,44,
  44,44,00,44,44,00,44,44,
  44,44,44,44,44,44,44,44,
  44,00,44,44,44,44,00,44,
  00,44,00,00,00,00,44,00,
  00,00,44,44,44,44,00,00

  );

Video320x200 = $13;
Video640x480 = $12;
Text80x25 = $3;

implementation

Procedure Location(x,y : Integer);
Begin
   Gy := y;
   Gx := x;
End;

Procedure SetColor(col,r,g,b:byte);
begin
  Port[$3c8]:=Col;
  Port[$3c9]:=R;
  Port[$3c9]:=G;
  Port[$3c9]:=B;
end;

Procedure ResetVga;
var
 R : Registers;
Begin
   R.AX := $03;
   Intr($10,R);
End;

Procedure SetVga;
var
 R : Registers;
begin
  R.AX := $13;
  Intr($10,R);
end;

Procedure ScreenLow;
var
 Counter : Integer;
Begin
  TextColor(7);
  for counter:=63 downto 0 do
  begin
    setcolor(7,Counter,0,0);
    Delay(150);
  End;
  SetVga;
End;

Procedure ScreenHigh;
var
 Counter : Integer;
Begin
  TextColor(7);
  for counter:=0 to 63 do
  Begin
    setcolor(7,Counter,0,0);
    Delay(150);
  End;
  SetVga;
End;

Procedure ClsVGA;
var
 I : Longint;
Begin
   for I := 0 to 63999 do
    mem[$a000:I] := 0;
End;

Procedure LPicVGA(X,Y,X1,Y1 : Integer;C0: Boolean;File_Name:String);
var
  P:Pic;
  F:File of Pic;
  I,J:integer;
Begin
   if X1 > 79 then X1 := 79;
   if Y1 > 49 then Y1 := 49;
   Assign(F,File_Name);
   Reset(F);
   Read(F,P);
   if IOResult <> 0 then Exit;
   Close(F);
   for I := 1 to Y1 do for J := 1 to X1 do
   Begin
      if not C0 then
        if P.BkColor[I,J] <> 0 then VGAPixel(J+X,I+Y,P.BkColor[I,J]);
      if C0 then
        if P.BkColor[I,J] <> 0 then VGAPixel(J+X,I+Y,0);
   End;
End;

Procedure LoadYpc(FileN : String; var P : YPcHeader);
var
 F : file;
Begin
   Assign(F,FileN);
   Reset(F,1);
   BlockRead(F,P,SizeOf(P));
   if IOResult <> 0 then Exit;
   Close(F);
End;

Procedure DrawYpc(X,Y,X1,Y1 : Integer;C0: Boolean; P:YPCHeader);
var
  I,J:integer;
Begin
   if X1 > 90 then X1 := 90;
   if Y1 > 90 then Y1 := 90;
   for I := 1 to Y1 do for J := 1 to X1 do
   Begin
      if (not C0) and ((X+J) < MaxScrX) and ((X+J) > MinScrX) and
       ((Y+I) < MaxScrY) and ((Y+I) > MinScrY) then
        if P.Buff[I,J] <> 0 then VGAPixel(J+X,I+Y,P.Buff[I,J]);
      if C0 then
        if P.Buff[I,J] <> 0 then VGAPixel(J+X,I+Y,0);
   End;
End;

Procedure VGABar(X, Y, X1, Y1 : Integer);
var
 P, I, I2 : Longint;
 Count, YY : Integer;
 MaxX      : Integer;
 ALen      : Integer;
Begin
   P := X+((Y-1)*320);
   Count := 0;
   YY := 0;
   MaxX := X1-X;
   ALen := (X1-X)*(Y1-Y)-1;
   for I := 0 to ALen do
   Begin
      mem[$a000:P+Count+(YY*320)] := VGAColor;
      Count := Count + 1;
      if Count = MaxX then
      Begin
         YY := YY + 1;
         Count := 0;
      End;
   End;
End;

Procedure VGAPixel(X,Y,Color : Integer);
var
 I : Longint;
Begin
   if X > 319 then X := 319;
   if Y > 200 then Y := 200;
   if X < 0 then X := 0;
   if Y < 1 then Y := 1;
   I := X+((Y-1)*320);
   mem[$a000:I] := Color;
End;

Function VGAGPixel(X,Y : Integer) : Byte;
var
 I : Longint;
Begin
   if X > 319 then X := 319;
   if Y > 200 then Y := 200;
   if X < 0 then X := 0;
   if Y < 1 then Y := 1;
   I := X+((Y-1)*320);
   VGAGPixel := mem[$a000:I];
End;

Procedure VGADraw(A : Array of Byte; X, Y, MaxX : Integer; ALen : Longint);
var
 P, I, I2 : Longint;
 Count, YY : Integer;
Begin
   P := X+((Y-1)*320);
   Count := 0;
   YY := 0;
   for I := 0 to ALen do
   Begin
      if (A[I] <> 0) and (A[I] <> 16) then mem[$a000:P+Count+(YY*320)] := A[I];
      Count := Count + 1;
      if Count = MaxX then
      Begin
         YY := YY + 1;
         Count := 0;
      End;
   End;
End;

Procedure VGAErase(A : Array of Byte; X, Y, MaxX : Integer; ALen : Longint);
var
 P, I, I2 : Longint;
 Count, YY : Integer;
Begin
   P := X+((Y-1)*320);
   Count := 0;
   YY := 0;
   for I := 0 to ALen do
   Begin
      if (mem[$a000:P+Count+(YY*320)] <> 0) and (mem[$a000:P+Count+(YY*320)]<> 16)then
         mem[$a000:P+Count+(YY*320)] := VGAColor;
      Count := Count + 1;
      if Count = MaxX then
      Begin
         YY := YY + 1;
         Count := 0;
      End;
   End;
End;

Procedure DrawChar(Num, X,Y : Integer);
var
 S : SingleChar;
 I, J : Integer;
Begin
   S := Font[Num];
   for J := 1 to 10 do
     for I := 1 to 10 do
       if S[J,I] then
         VGAPixel(I+X,J+y,VGAColor);
End;

Procedure LoadFont(FntName : String);
var
 F : FontFile;
Begin
   if Exist(FntName) then
   Begin
      Assign(F, FntName);
      Reset(F);
      Read(F, Font);
      Close(F);
   End;
End;

Procedure OutFont(Str : String);
var
 Ch : Char;
 I  : Integer;
 Sx, Sy : Integer;
Begin
   Sx := Gx;
   Sy := Gy;
   for I := 1 to Length(Str) do
   Begin
      Ch := Str[I];
      if Ch <> ' ' then
      Begin
         DrawChar(Ord(Ch)-32,Gx, Gy);
         Gx := Gx + 11;
      End
     else
      Gx := Gx + 10;
      Location(Gx,Gy);
   End;
End;

Procedure OutFontLn(Str : String);
var
 Ch : Char;
 I  : Integer;
 Sx, Sy : Integer;
Begin
   Sx := Gx;
   Sy := Gy;
   for I := 1 to Length(Str) do
   Begin
      Ch := Str[I];
      if Ch <> ' ' then
      Begin
         DrawChar(Ord(Ch)-32,Gx, Gy);
         Location(Gx+11, Gy);
      End
     else
      Location(Gx+10, Gy);
   End;
   Location(Sx, Sy+11);
End;

Procedure LoadFontMem(P : FPointer);
Begin
   Font := P^;
End;


Procedure WriteFade(Str : String; x,y,Del:Integer;Fade : Boolean);
var
 I : Integer;
 C : Integer;

Begin
   For I := 16 to 30 do
   Begin
      VGAColor := I;
      Location(x,y);
      OutFont(Str);
      Delay(400);
   End;
   Delay(Del);
   if Fade then
   For I := 30 downto 16 do
   Begin
      VGAColor := I;
      Location(x,y);
      OutFont(Str);
      Delay(200);
   End;

End;

Procedure ShowBarak(x,y,count : integer);
var
 P : YPCHeader;
 I : Integer;
Begin
   for I := 1 to count do
   Begin
      LoadYPC('barak1.ypc',P);
      DrawYPC(x,y,90,90,False,P);
      DrawYPC(x,y+80,90,90,False,P);
      Sound(Random(100)+10);
      Delay(100);
      NoSound;
      DrawYPC(x,y,90,90,True,P);
      DrawYPC(x,y+80,90,90,True,P);

      LoadYPC('barak2.ypc',P);
      DrawYPC(x,y,90,90,False,P);
      DrawYPC(x,y+80,90,90,False,P);
      Sound(Random(100)+10);
      Delay(100);
      NoSound;
      DrawYPC(x,y,90,90,True,P);
      DrawYPC(x,y+80,90,90,True,P);

      LoadYPC('barak3.ypc',P);
      DrawYPC(x,y,90,90,False,P);
      DrawYPC(x,y+80,90,90,False,P);
      Sound(Random(100)+10);
      Delay(100);
      NoSound;
      DrawYPC(x,y,90,90,True,P);
      DrawYPC(x,y+80,90,90,True,P);

   End;

End;

Procedure DrawSton(x,y : Integer);
var
 P : YPCHeader;
Begin
   LoadYPC('ston.ypc',P);
   DrawYPC(x,y,90,90,False,P);
End;

Procedure DrawCloud(x,y : Integer);
var
 P : YPCHeader;
Begin
   LoadYPC('cloud.ypc',P);
   DrawYPC(x,y,90,90,False,P);
End;

Procedure DrawShemesh(x,y : Integer);
var
 P : YPCHeader;
Begin
   LoadYPC('Shemesh.ypc',P);
   DrawYPC(x,y,90,90,False,P);
End;

Procedure SDemo;
var
 I : Integer;
Begin
   LoadFont('.\yfonts\engyad.yfn');
   MaxScrX := 300;
   MaxScrY := 200;
   DrawShemesh(90,1);
   DrawCloud(1,1);
   DrawCloud(70,1);
   DrawCloud(120,1);
   DrawCloud(200,1);
   DrawCloud(250,10);

   DrawSton(1,100);
   DrawSton(70,100);
   DrawSton(140,100);
   DrawSton(210,100);
   DrawSton(210,80);
   DrawSton(260,100);

End;

Procedure Demo;
var
 I : Integer;
Begin
   LoadFont('.\yfonts\engyad.yfn');
   MaxScrX := 300;
   MaxScrY := 200;
   DrawShemesh(90,1);
   DrawCloud(1,1);
   DrawCloud(70,1);
   DrawCloud(120,1);
   DrawCloud(200,1);
   DrawCloud(250,10);

   DrawSton(1,100);
   DrawSton(70,100);
   DrawSton(140,100);
   DrawSton(210,100);
   DrawSton(210,80);
   DrawSton(260,100);

   ShowBarak(20,20,10);
   WriteFade('Y.M.S international',40,80,1000,True);
   ShowBarak(200,20,10);
   ShowBarak(20,20,10);
   WriteFade('Copyright(c)1997/98 by-',40,80,1000,True);
   For I := 1 to 5 do
   Begin
      ShowBarak(200,20,1);
      ShowBarak(20,20,1);
   End;
   WriteFade('Yotam Madem',80,80,1000,False);
   ShowBarak(80,1,10);

End;

Procedure VideoMode(I : Integer); assembler;
asm
  mov ax, I;
  int 10h;
End;

Procedure Mac2Font; external;
{$L mac2.obj}


function gmenu(x,y,mcolor,lcolor,tcolor : Integer; pitems : string) : byte;
var
  items : array[1..20] of string[100];
  i      : integer;
  counti : byte;
  maxlen : byte;
  px, py : integer;
  lx, ly : integer;
  item   : integer;
  done   : boolean;
  ch     : char;
  p      : pointer;
  BDone  : boolean;
  Pressed: Boolean;

procedure drawscr(hilight : integer);
var
 i : integer;
begin
   hidemouse;
   box(px,py,x+(maxlen*11)+4,y+(counti*11)+2,15,vvga);
   bar(px+1,py+1,x+(maxlen*11)+3,y+(counti*11)+1,mcolor,vvga);
   for i := 1 to counti do
   begin
      location(x+1,y+1+((i-1)*11));
      vgacolor := tcolor;
      if i = hilight then
       bar(x-1,y+1+((i-1)*11),x+(maxlen*11)+3,y+1+((i-1)*11)+10,lcolor,vvga);
      outfont(items[i]);
   end;
   showmouse;
end;

begin
   ch := ' ';
   counti := 1;
   done := false;
   bdone:= false;
   pressed := false;
   for i := 1 to 20 do
    items[i] := '';

   px := x-2;
   py := y-2;

   for i := 1 to length(pitems) do
   begin
      if pitems[i] <> '|' then
        items[counti] := items[counti] + pitems[i]
       else
        inc(counti);
   end;

   maxlen := 0;

   for i := 1 to counti do
    if length(items[i]) > maxlen then
     maxlen := length(items[i]);

   hidemouse;
   makesprite(p,(maxlen*11)+7,(counti*11)+5);
   getsprite(p,px,py,(maxlen*11)+7,(counti*11)+5,vvga);
   showmouse;

   loadfontmem(@mac2font);
   drawscr(1);
   lx := 0;
   ly := 0;
   item := 1;
   repeat
      if (lx <> getmousex) or (ly <> getmousey) then
      begin
         lx := getmousex;
         ly := getmousey;
         if (lx > px) and (lx < x+(maxlen*11)+3) and
            (ly > py) and (ly < y+(counti*11)+1) then
         begin
            if item <> ((ly-py+9) div 11) then
            begin
             item := ((ly-py+9) div 11);
             drawscr(item);
            end;
         end;
      end;

      if keypressed then ch := readkey;
       if ch = #0 then
       begin
          ch := readkey;
          if ch = down_key then
          begin
             if (item > counti) or (item < 1) then
             begin
                if item > counti then
                 item := counti;
                if item < 1 then
                 item := 1;
                drawscr(item);
             end
            else
             begin
                if item = counti then
                 item := 1
                else
                 inc(item);
                 drawscr(item);
             end;
          end;

          if ch = Up_key then
          begin
             if (item > counti) or (item < 1) then
             begin
                if item > counti then
                 item := counti;
                if item < 1 then
                 item := 1;
                drawscr(item);
             end
            else
             begin
                if item = 1 then
                 item := counti
                else
                 dec(item);
                 drawscr(item);
             end;
          end;
       end
      else
       if (ch = enter_key) or (ch = esc_key) then done := true;
      if ButtonDown then Pressed := true;
      if (ButtonUp) and (Pressed) then bdone := true;
   until (done) or bdone;

   if keypressed then
     readkey;

   if (item > 0) and (item <= counti) then
     gmenu := item
    else
     gmenu := 0;

   lx := getmousex;
   ly := getmousey;
   if not ((lx > px) and (lx < x+(maxlen*11)+3) and
          (ly > py) and (ly < y+(counti*11)+1))and(not done) then
      gmenu := 0;


   if ch = esc_key then gmenu := 0;
   hidemouse;
   putsprite(p,px,py,(maxlen*11)+7,(counti*11)+5,vvga);
   delsprite(p,(maxlen*11)+7,(counti*11)+5);
   showmouse;
end;


Begin
   VGAColor := 15;
   Gx := 1;
   Gy := 1;
   MaxScrX := 320;
   MaxScrY := 200;
   LoadFontMem(@DefaultYFont);
End.
