/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.jsf.ActionSourceRule;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentRule;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.tag.jsf.EditableValueHolderRule;
import com.sun.facelets.tag.jsf.ValueHolderRule;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class ComponentHandler
extends MetaTagHandler {
    private static final Logger log = Logger.getLogger("facelets.tag.component");
    private final TagAttribute binding;
    private final String componentType;
    private final TagAttribute id;
    private final String rendererType;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$faces$component$ActionSource;
    static /* synthetic */ Class class$javax$faces$component$ValueHolder;
    static /* synthetic */ Class class$javax$faces$component$EditableValueHolder;

    public ComponentHandler(ComponentConfig config) {
        super(config);
        this.componentType = config.getComponentType();
        this.rendererType = config.getRendererType();
        this.id = this.getAttribute("id");
        this.binding = this.getAttribute("binding");
    }

    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        String id = ctx.generateUniqueId(this.tagId);
        UIComponent c = ComponentSupport.findChildByTagId(parent, id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Found, marking children for cleanup");
            }
            ComponentSupport.markForDeletion(c);
        } else {
            c = this.createComponent(ctx);
            if (c == null) {
                throw new NullPointerException();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            this.setAttributes(ctx, c);
            c.getAttributes().put("com.sun.facelets.MARK_ID", id);
            if (this.id != null) {
                c.setId(this.id.getValue(ctx));
            } else {
                UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
                if (root != null) {
                    String uid = root.createUniqueId();
                    c.setId(uid);
                }
            }
            if (this.rendererType != null) {
                // empty if block
            }
            this.onComponentCreated(ctx, c, parent);
        }
        this.applyNextHandler(ctx, c);
        if (componentFound) {
            ComponentSupport.finalizeForDeletion(c);
            parent.getChildren().remove(c);
        }
        this.onComponentPopulated(ctx, c, parent);
        parent.getChildren().add(c);
    }

    protected UIComponent createComponent(FaceletContext ctx) {
        UIComponent c = null;
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, class$java$lang$Object == null ? (class$java$lang$Object = ComponentHandler.class$("java.lang.Object")) : class$java$lang$Object);
            log.info("(226) ve = " + ve);
            LegacyValueBinding vb = new LegacyValueBinding(ve);
            c = app.createComponent((ValueBinding)vb, faces, this.componentType);
            if (c != null) {
                c.setValueBinding("binding", (ValueBinding)vb);
            }
        } else {
            c = app.createComponent(this.componentType);
        }
        return c;
    }

    protected String getId(FaceletContext ctx) {
        if (this.id != null) {
            return this.id.getValue(ctx);
        }
        return ctx.generateUniqueId(this.tagId);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.ignore("binding").ignore("id");
        m.addRule(ComponentRule.Instance);
        if ((class$javax$faces$component$ActionSource == null ? (class$javax$faces$component$ActionSource = ComponentHandler.class$("javax.faces.component.ActionSource")) : class$javax$faces$component$ActionSource).isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.Instance);
        }
        if ((class$javax$faces$component$ValueHolder == null ? (class$javax$faces$component$ValueHolder = ComponentHandler.class$("javax.faces.component.ValueHolder")) : class$javax$faces$component$ValueHolder).isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.Instance);
            if ((class$javax$faces$component$EditableValueHolder == null ? (class$javax$faces$component$EditableValueHolder = ComponentHandler.class$("javax.faces.component.EditableValueHolder")) : class$javax$faces$component$EditableValueHolder).isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.Instance);
            }
        }
        return m;
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.nextHandler.apply(ctx, c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

