/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.html_basic.MenuRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class SelectManyCheckboxListRenderer
extends MenuRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        String alignStr = null;
        Object borderObj = null;
        boolean alignVertical = false;
        int border = 0;
        alignStr = (String)component.getAttributes().get("layout");
        if (null != alignStr) {
            alignVertical = alignStr.equalsIgnoreCase("pageDirection");
        }
        Object v = component.getAttributes().get("border");
        borderObj = v;
        if (null != v) {
            if (borderObj instanceof Integer) {
                border = (Integer)borderObj;
            } else {
                try {
                    border = Integer.valueOf(borderObj.toString());
                }
                catch (Throwable e) {
                    border = 0;
                }
            }
        }
        this.renderBeginText(component, border, alignVertical, context, true);
        Iterator items = Util.getSelectItems(context, component);
        SelectItem curItem = null;
        while (items.hasNext()) {
            curItem = (SelectItem)items.next();
            if (curItem instanceof SelectItemGroup) {
                if (curItem.getLabel() != null) {
                    if (alignVertical) {
                        writer.startElement("tr", component);
                    }
                    writer.startElement("td", component);
                    writer.writeText((Object)curItem.getLabel(), "label");
                    writer.endElement("td");
                    if (alignVertical) {
                        writer.endElement("tr");
                    }
                }
                if (alignVertical) {
                    writer.startElement("tr", component);
                }
                writer.startElement("td", component);
                writer.writeText((Object)"\n", null);
                this.renderBeginText(component, 0, alignVertical, context, false);
                SelectItem[] itemsArray = ((SelectItemGroup)curItem).getSelectItems();
                for (int i = 0; i < itemsArray.length; ++i) {
                    this.renderOption(context, component, itemsArray[i], alignVertical);
                }
                this.renderEndText(component, alignVertical, context, false);
                writer.endElement("td");
                if (!alignVertical) continue;
                writer.endElement("tr");
                writer.writeText((Object)"\n", null);
                continue;
            }
            this.renderOption(context, component, curItem, alignVertical);
        }
        this.renderEndText(component, alignVertical, context, true);
    }

    protected void renderOption(FacesContext context, UIComponent component, SelectItem curItem, boolean alignVertical) throws IOException {
        boolean isSelected;
        ResponseWriter writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        String labelClass = null;
        boolean componentDisabled = false;
        if (component.getAttributes().get("disabled") != null && component.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            componentDisabled = true;
        }
        labelClass = componentDisabled || curItem.isDisabled() ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        if (alignVertical) {
            writer.writeText((Object)"\t", null);
            writer.startElement("tr", component);
            writer.writeText((Object)"\n", null);
        }
        writer.startElement("td", component);
        writer.writeText((Object)"\n", null);
        writer.startElement("label", component);
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        writer.startElement("input", component);
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        String valueString = this.getFormattedValue(context, component, curItem.getValue());
        writer.writeAttribute("value", (Object)valueString, "value");
        writer.writeAttribute("type", (Object)"checkbox", null);
        Object[] submittedValues = this.getSubmittedSelectedValues(context, component);
        if (submittedValues != null) {
            isSelected = this.isSelected((Object)valueString, submittedValues);
        } else {
            Object selectedValues = this.getCurrentSelectedValues(context, component);
            isSelected = this.isSelected(curItem.getValue(), selectedValues);
        }
        if (isSelected) {
            writer.writeAttribute(this.getSelectedTextString(), (Object)Boolean.TRUE, null);
        }
        if (curItem.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        Util.renderPassThruAttributes(writer, component, new String[]{"style", "border"});
        Util.renderBooleanPassThruAttributes(writer, component);
        String itemLabel = curItem.getLabel();
        if (itemLabel != null) {
            writer.writeText((Object)" ", null);
            writer.writeText((Object)itemLabel, "label");
        }
        writer.endElement("input");
        writer.endElement("label");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        if (alignVertical) {
            writer.writeText((Object)"\t", null);
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
        }
    }

    String getSelectedTextString() {
        return " checked";
    }

    protected void renderBeginText(UIComponent component, int border, boolean alignVertical, FacesContext context, boolean outerTable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        writer.startElement("table", component);
        if (border != Integer.MIN_VALUE) {
            writer.writeAttribute("border", (Object)new Integer(border), "border");
        }
        if (outerTable) {
            if (this.shouldWriteIdAttribute(component)) {
                this.writeIdAttributeIfNecessary(context, writer, component);
            }
            String styleClass = (String)component.getAttributes().get("styleClass");
            String style = (String)component.getAttributes().get("style");
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "class");
            }
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
        }
        writer.writeText((Object)"\n", null);
        if (!alignVertical) {
            writer.writeText((Object)"\t", null);
            writer.startElement("tr", component);
            writer.writeText((Object)"\n", null);
        }
    }

    protected void renderEndText(UIComponent component, boolean alignVertical, FacesContext context, boolean outerTable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        if (!alignVertical) {
            writer.writeText((Object)"\t", null);
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
        }
        writer.endElement("table");
    }
}

