/*
 * Decompiled with CFR 0.152.
 */
package dwarf.jsf.support;

import dwarf.jsf.support.BaseContextMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionMap
extends BaseContextMap {
    private HttpServletRequest request = null;

    public SessionMap(HttpServletRequest request) {
        this.request = request;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getSession().getAttribute(key.toString());
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String keyString = key.toString();
        HttpSession session = this.getSession();
        Object result = session.getAttribute(keyString);
        session.setAttribute(keyString, value);
        return result;
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        HttpSession session = this.getSession();
        Object result = session.getAttribute(keyString);
        session.removeAttribute(keyString);
        return result;
    }

    public Set entrySet() {
        HashSet<BaseContextMap.Entry> entries = new HashSet<BaseContextMap.Entry>();
        HttpSession session = this.getSession();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            entries.add(new BaseContextMap.Entry(key, session.getAttribute(key)));
        }
        return entries;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SessionMap)) {
            return false;
        }
        return super.equals(obj);
    }

    private HttpSession getSession() {
        return this.request.getSession(true);
    }
}

