/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import org.apache.el.lang.ELArithmetic;
import org.apache.el.util.MessageFactory;

public class ELSupport {
    private static final ELSupport REF = new ELSupport();
    private static final Long ZERO = new Long(0L);
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static final void throwUnhandled(Object base, Object property) throws ELException {
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", property));
        }
        throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", base.getClass(), property));
    }

    public static final int compare(Object obj0, Object obj1) throws ELException {
        if (obj0 == obj1 || ELSupport.equals(obj0, obj1)) {
            return 0;
        }
        if (ELSupport.isBigDecimalOp(obj0, obj1)) {
            BigDecimal bd0 = (BigDecimal)ELSupport.coerceToNumber(obj0, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ELSupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            BigDecimal bd1 = (BigDecimal)ELSupport.coerceToNumber(obj1, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ELSupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            return bd0.compareTo(bd1);
        }
        if (ELSupport.isDoubleOp(obj0, obj1)) {
            Double d0 = (Double)ELSupport.coerceToNumber(obj0, class$java$lang$Double == null ? (class$java$lang$Double = ELSupport.class$("java.lang.Double")) : class$java$lang$Double);
            Double d1 = (Double)ELSupport.coerceToNumber(obj1, class$java$lang$Double == null ? (class$java$lang$Double = ELSupport.class$("java.lang.Double")) : class$java$lang$Double);
            return d0.compareTo(d1);
        }
        if (ELSupport.isBigIntegerOp(obj0, obj1)) {
            BigInteger bi0 = (BigInteger)ELSupport.coerceToNumber(obj0, class$java$math$BigInteger == null ? (class$java$math$BigInteger = ELSupport.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            BigInteger bi1 = (BigInteger)ELSupport.coerceToNumber(obj1, class$java$math$BigInteger == null ? (class$java$math$BigInteger = ELSupport.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            return bi0.compareTo(bi1);
        }
        if (ELSupport.isLongOp(obj0, obj1)) {
            Long l0 = (Long)ELSupport.coerceToNumber(obj0, class$java$lang$Long == null ? (class$java$lang$Long = ELSupport.class$("java.lang.Long")) : class$java$lang$Long);
            Long l1 = (Long)ELSupport.coerceToNumber(obj1, class$java$lang$Long == null ? (class$java$lang$Long = ELSupport.class$("java.lang.Long")) : class$java$lang$Long);
            return l0.compareTo(l1);
        }
        if (obj0 instanceof String || obj1 instanceof String) {
            return ELSupport.coerceToString(obj0).compareTo(ELSupport.coerceToString(obj1));
        }
        if (obj0 instanceof Comparable) {
            return obj1 != null ? ((Comparable)obj0).compareTo(obj1) : 1;
        }
        if (obj1 instanceof Comparable) {
            return obj0 != null ? -((Comparable)obj1).compareTo(obj0) : -1;
        }
        throw new ELException(MessageFactory.get("error.compare", obj0, obj1));
    }

    public static final boolean equals(Object obj0, Object obj1) throws ELException {
        if (obj0 == obj1) {
            return true;
        }
        if (obj0 == null || obj1 == null) {
            return false;
        }
        if (obj0 instanceof Boolean || obj1 instanceof Boolean) {
            return ELSupport.coerceToBoolean(obj0).equals(ELSupport.coerceToBoolean(obj1));
        }
        if (obj0 instanceof String || obj1 instanceof String) {
            int lexCompare = ELSupport.coerceToString(obj0).compareTo(ELSupport.coerceToString(obj1));
            return lexCompare == 0;
        }
        if (ELSupport.isBigDecimalOp(obj0, obj1)) {
            BigDecimal bd0 = (BigDecimal)ELSupport.coerceToNumber(obj0, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ELSupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            BigDecimal bd1 = (BigDecimal)ELSupport.coerceToNumber(obj1, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ELSupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            return bd0.equals(bd1);
        }
        if (ELSupport.isDoubleOp(obj0, obj1)) {
            Double d0 = (Double)ELSupport.coerceToNumber(obj0, class$java$lang$Double == null ? (class$java$lang$Double = ELSupport.class$("java.lang.Double")) : class$java$lang$Double);
            Double d1 = (Double)ELSupport.coerceToNumber(obj1, class$java$lang$Double == null ? (class$java$lang$Double = ELSupport.class$("java.lang.Double")) : class$java$lang$Double);
            return d0.equals(d1);
        }
        if (ELSupport.isBigIntegerOp(obj0, obj1)) {
            BigInteger bi0 = (BigInteger)ELSupport.coerceToNumber(obj0, class$java$math$BigInteger == null ? (class$java$math$BigInteger = ELSupport.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            BigInteger bi1 = (BigInteger)ELSupport.coerceToNumber(obj1, class$java$math$BigInteger == null ? (class$java$math$BigInteger = ELSupport.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            return bi0.equals(bi1);
        }
        if (ELSupport.isLongOp(obj0, obj1)) {
            Long l0 = (Long)ELSupport.coerceToNumber(obj0, class$java$lang$Long == null ? (class$java$lang$Long = ELSupport.class$("java.lang.Long")) : class$java$lang$Long);
            Long l1 = (Long)ELSupport.coerceToNumber(obj1, class$java$lang$Long == null ? (class$java$lang$Long = ELSupport.class$("java.lang.Long")) : class$java$lang$Long);
            return l0.equals(l1);
        }
        return obj0.equals(obj1);
    }

    public static final Boolean coerceToBoolean(Object obj) throws IllegalArgumentException {
        if (obj == null || "".equals(obj)) {
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean || obj.getClass() == Boolean.TYPE) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", obj, obj.getClass(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = ELSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean));
    }

    public static final Character coerceToCharacter(Object obj) throws IllegalArgumentException {
        if (obj == null || "".equals(obj)) {
            return new Character('\u0000');
        }
        if (obj instanceof String) {
            return new Character(((String)obj).charAt(0));
        }
        if (ELArithmetic.isNumber(obj)) {
            return new Character((char)((Number)obj).shortValue());
        }
        Class<?> objType = obj.getClass();
        if (obj instanceof Character || objType == Character.TYPE) {
            return (Character)obj;
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", obj, objType, class$java$lang$Character == null ? (class$java$lang$Character = ELSupport.class$("java.lang.Character")) : class$java$lang$Character));
    }

    public static final Number coerceToNumber(Object obj) {
        if (obj == null) {
            return ZERO;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        String str = ELSupport.coerceToString(obj);
        if (ELSupport.isStringFloat(str)) {
            return ELSupport.toFloat(str);
        }
        return ELSupport.toNumber(str);
    }

    protected static final Number coerceToNumber(Number number, Class type) throws IllegalArgumentException {
        if (Long.TYPE == type || (class$java$lang$Long == null ? (class$java$lang$Long = ELSupport.class$("java.lang.Long")) : class$java$lang$Long).equals(type)) {
            return new Long(number.longValue());
        }
        if (Double.TYPE == type || (class$java$lang$Double == null ? (class$java$lang$Double = ELSupport.class$("java.lang.Double")) : class$java$lang$Double).equals(type)) {
            return new Double(number.doubleValue());
        }
        if (Integer.TYPE == type || (class$java$lang$Integer == null ? (class$java$lang$Integer = ELSupport.class$("java.lang.Integer")) : class$java$lang$Integer).equals(type)) {
            return new Integer(number.intValue());
        }
        if ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = ELSupport.class$("java.math.BigInteger")) : class$java$math$BigInteger).equals(type)) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ELSupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(type)) {
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        if (Byte.TYPE == type || (class$java$lang$Byte == null ? (class$java$lang$Byte = ELSupport.class$("java.lang.Byte")) : class$java$lang$Byte).equals(type)) {
            return new Byte(number.byteValue());
        }
        if (Short.TYPE == type || (class$java$lang$Short == null ? (class$java$lang$Short = ELSupport.class$("java.lang.Short")) : class$java$lang$Short).equals(type)) {
            return new Short(number.shortValue());
        }
        if (Float.TYPE == type || (class$java$lang$Float == null ? (class$java$lang$Float = ELSupport.class$("java.lang.Float")) : class$java$lang$Float).equals(type)) {
            return new Float(number.floatValue());
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", number, number.getClass(), type));
    }

    public static final Number coerceToNumber(Object obj, Class type) throws IllegalArgumentException {
        Class<?> objType;
        if (obj == null || "".equals(obj)) {
            return ELSupport.coerceToNumber(ZERO, type);
        }
        if (obj instanceof String) {
            return ELSupport.coerceToNumber((String)obj, type);
        }
        if (ELArithmetic.isNumber(obj)) {
            return ELSupport.coerceToNumber((Number)obj, type);
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = ELSupport.class$("java.lang.Character")) : class$java$lang$Character).equals(objType = obj.getClass()) || Character.TYPE == objType) {
            return ELSupport.coerceToNumber(new Short((short)((Character)obj).charValue()), type);
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", obj, objType, type));
    }

    protected static final Number coerceToNumber(String val, Class type) throws IllegalArgumentException {
        if (Long.TYPE == type || (class$java$lang$Long == null ? (class$java$lang$Long = ELSupport.class$("java.lang.Long")) : class$java$lang$Long).equals(type)) {
            return Long.valueOf(val);
        }
        if (Integer.TYPE == type || (class$java$lang$Integer == null ? (class$java$lang$Integer = ELSupport.class$("java.lang.Integer")) : class$java$lang$Integer).equals(type)) {
            return Integer.valueOf(val);
        }
        if (Double.TYPE == type || (class$java$lang$Double == null ? (class$java$lang$Double = ELSupport.class$("java.lang.Double")) : class$java$lang$Double).equals(type)) {
            return Double.valueOf(val);
        }
        if ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = ELSupport.class$("java.math.BigInteger")) : class$java$math$BigInteger).equals(type)) {
            return new BigInteger(val);
        }
        if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ELSupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(type)) {
            return new BigDecimal(val);
        }
        if (Byte.TYPE == type || (class$java$lang$Byte == null ? (class$java$lang$Byte = ELSupport.class$("java.lang.Byte")) : class$java$lang$Byte).equals(type)) {
            return Byte.valueOf(val);
        }
        if (Short.TYPE == type || (class$java$lang$Short == null ? (class$java$lang$Short = ELSupport.class$("java.lang.Short")) : class$java$lang$Short).equals(type)) {
            return Short.valueOf(val);
        }
        if (Float.TYPE == type || (class$java$lang$Float == null ? (class$java$lang$Float = ELSupport.class$("java.lang.Float")) : class$java$lang$Float).equals(type)) {
            return Float.valueOf(val);
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", val, class$java$lang$String == null ? (class$java$lang$String = ELSupport.class$("java.lang.String")) : class$java$lang$String, type));
    }

    public static final String coerceToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public static final void checkType(Object obj, Class type) throws IllegalArgumentException {
        if ((class$java$lang$String == null ? (class$java$lang$String = ELSupport.class$("java.lang.String")) : class$java$lang$String).equals(type)) {
            ELSupport.coerceToString(obj);
        }
        if (ELArithmetic.isNumberType(type)) {
            ELSupport.coerceToNumber(obj, type);
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = ELSupport.class$("java.lang.Character")) : class$java$lang$Character).equals(type) || Character.TYPE == type) {
            ELSupport.coerceToCharacter(obj);
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ELSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(type) || Boolean.TYPE == type) {
            ELSupport.coerceToBoolean(obj);
        }
    }

    public static final Object coerceToType(Object obj, Class type) throws IllegalArgumentException {
        if (type == null || (class$java$lang$Object == null ? (class$java$lang$Object = ELSupport.class$("java.lang.Object")) : class$java$lang$Object).equals(type)) {
            return obj;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = ELSupport.class$("java.lang.String")) : class$java$lang$String).equals(type)) {
            return ELSupport.coerceToString(obj);
        }
        if (ELArithmetic.isNumberType(type)) {
            return ELSupport.coerceToNumber(obj, type);
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = ELSupport.class$("java.lang.Character")) : class$java$lang$Character).equals(type) || Character.TYPE == type) {
            return ELSupport.coerceToCharacter(obj);
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ELSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(type) || Boolean.TYPE == type) {
            return ELSupport.coerceToBoolean(obj);
        }
        if (obj != null && type.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            if ("".equals(obj)) {
                return null;
            }
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor != null) {
                editor.setAsText((String)obj);
                return editor.getValue();
            }
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
    }

    public static final boolean containsNulls(Object[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (obj[0] != null) continue;
            return true;
        }
        return false;
    }

    public static final boolean isBigDecimalOp(Object obj0, Object obj1) {
        return obj0 instanceof BigDecimal || obj1 instanceof BigDecimal;
    }

    public static final boolean isBigIntegerOp(Object obj0, Object obj1) {
        return obj0 instanceof BigInteger || obj1 instanceof BigInteger;
    }

    public static final boolean isDoubleOp(Object obj0, Object obj1) {
        return obj0 instanceof Double || obj1 instanceof Double || obj0 instanceof Float || obj1 instanceof Float || obj0 != null && (Double.TYPE == obj0.getClass() || Float.TYPE == obj0.getClass()) || obj1 != null && (Double.TYPE == obj1.getClass() || Float.TYPE == obj1.getClass());
    }

    public static final boolean isDoubleStringOp(Object obj0, Object obj1) {
        return ELSupport.isDoubleOp(obj0, obj1) || obj0 instanceof String && ELSupport.isStringFloat((String)obj0) || obj1 instanceof String && ELSupport.isStringFloat((String)obj1);
    }

    public static final boolean isLongOp(Object obj0, Object obj1) {
        return obj0 instanceof Long || obj1 instanceof Long || obj0 instanceof Integer || obj1 instanceof Integer || obj0 instanceof Character || obj1 instanceof Character || obj0 instanceof Short || obj1 instanceof Short || obj0 instanceof Byte || obj1 instanceof Byte || obj0 != null && (Long.TYPE == obj0.getClass() || Integer.TYPE == obj0.getClass() || Character.TYPE == obj0.getClass() || Short.TYPE == obj0.getClass() || Byte.TYPE == obj0.getClass()) || obj0 != null && (Long.TYPE == obj0.getClass() || Integer.TYPE == obj0.getClass() || Character.TYPE == obj0.getClass() || Short.TYPE == obj0.getClass() || Byte.TYPE == obj0.getClass());
    }

    public static final boolean isStringFloat(String str) {
        int len = str.length();
        if (len > 1) {
            char c = '\u0000';
            for (int i = 0; i < len; ++i) {
                c = str.charAt(i);
                switch (c) {
                    case 'E': {
                        return true;
                    }
                    case 'e': {
                        return true;
                    }
                    case '.': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static final Number toFloat(String value) {
        try {
            if (Double.parseDouble(value) > Double.MAX_VALUE) {
                return new BigDecimal(value);
            }
            return new Double(value);
        }
        catch (NumberFormatException e0) {
            return new BigDecimal(value);
        }
    }

    public static final Number toNumber(String value) {
        try {
            return new Integer(Integer.parseInt(value));
        }
        catch (NumberFormatException e0) {
            try {
                return new Long(Long.parseLong(value));
            }
            catch (NumberFormatException e1) {
                return new BigInteger(value);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

