/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.FunctionMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.el.util.ReflectionUtil;

public class FunctionMapperImpl
extends FunctionMapper
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$el$lang$FunctionMapperImpl == null ? (class$org$apache$el$lang$FunctionMapperImpl = FunctionMapperImpl.class$("org.apache.el.lang.FunctionMapperImpl")) : class$org$apache$el$lang$FunctionMapperImpl));
    protected Map functions = null;
    static /* synthetic */ Class class$org$apache$el$lang$FunctionMapperImpl;
    static /* synthetic */ Class class$org$apache$el$lang$JspUtil;
    static /* synthetic */ Class class$java$lang$String;

    public Method resolveFunction(String prefix, String localName) {
        log.info((Object)("resolveFunction prefix = '" + prefix + "', localName = '" + localName + "'"));
        if ("fn".equals(prefix) && "escapeXml".equals(localName)) {
            Class clazz = class$org$apache$el$lang$JspUtil == null ? (class$org$apache$el$lang$JspUtil = FunctionMapperImpl.class$("org.apache.el.lang.JspUtil")) : class$org$apache$el$lang$JspUtil;
            Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FunctionMapperImpl.class$("java.lang.String")) : class$java$lang$String};
            Method method = null;
            try {
                method = clazz.getMethod("escapeXml", parameterTypes);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return method;
        }
        if (this.functions != null) {
            Function f = (Function)this.functions.get(prefix + ":" + localName);
            return f.getMethod();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(String prefix, String localName, Method m) {
        if (this.functions == null) {
            this.functions = new HashMap();
        }
        Function f = new Function(prefix, localName, m);
        FunctionMapperImpl functionMapperImpl = this;
        synchronized (functionMapperImpl) {
            this.functions.put(prefix + ":" + localName, f);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.functions);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.functions = (Map)in.readObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Function
    implements Externalizable {
        protected transient Method m;
        protected String owner;
        protected String name;
        protected String[] types;
        protected String prefix;
        protected String localName;

        public Function(String prefix, String localName, Method m) {
            if (localName == null) {
                throw new NullPointerException("LocalName cannot be null");
            }
            if (m == null) {
                throw new NullPointerException("Method cannot be null");
            }
            this.prefix = prefix;
            this.localName = localName;
            this.m = m;
        }

        public Function() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.prefix != null ? this.prefix : "");
            out.writeUTF(this.localName);
            out.writeUTF(this.m.getDeclaringClass().getName());
            out.writeUTF(this.m.getName());
            out.writeObject(ReflectionUtil.toTypeNameArray(this.m.getParameterTypes()));
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.prefix = in.readUTF();
            if ("".equals(this.prefix)) {
                this.prefix = null;
            }
            this.localName = in.readUTF();
            this.owner = in.readUTF();
            this.name = in.readUTF();
            this.types = (String[])in.readObject();
        }

        public Method getMethod() {
            if (this.m == null) {
                try {
                    Class<?> t = Class.forName(this.owner);
                    Class[] p = ReflectionUtil.toTypeArray(this.types);
                    this.m = t.getMethod(this.name, p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.m;
        }

        public boolean matches(String prefix, String localName) {
            if (this.prefix != null) {
                if (prefix == null) {
                    return false;
                }
                if (!this.prefix.equals(prefix)) {
                    return false;
                }
            }
            return this.localName.equals(localName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Function) {
                return this.hashCode() == obj.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return (this.prefix + this.localName).hashCode();
        }
    }
}

