package app1;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.servlet.*;
import javax.servlet.http.*;
import strawberry.configure.ManagedBeanFactorySC;
import strawberry.configure.ManagedBeanXml;

/**
 *  ManagedBeanFactory쐬AAvP[VReLXgɓo^T[ubg
 *  @since 2006.11.05
 */
public class InitializeServlet extends HttpServlet {

  static final long serialVersionUID = 8884406202783137848L;
  /**
   *  
   */
  public void init(ServletConfig config) throws ServletException {
    super.init(config);
    ServletContext appli = getServletContext();

    String path = getServletContext().getRealPath("/");
    
    appli.setAttribute(ManagedBeanFactorySC.KEY, new DummyClass(path));
    
    String appDir = getContextName(path);

//    String propFile = getInitParameter("propertiesfile");

    System.out.println("******** InitializeServlet::START '" + appDir + "'" );

    
    // -------------- init JSF ---------------
    String xmlPath = path   + "WEB-INF/faces-config.xml";
    System.out.println("******** InitializeServlet::path '" + path +  "'");
    ServletContext sc = getServletContext();

    try {
      //  ServletContextɊi[ꂽIuWFNgŃNX[_肷
      ManagedBeanXml.processXml(xmlPath, sc, "strawberry.configure.ManagedBeanFactorySC");

      
    } catch (Exception ex) {
      ex.printStackTrace();
    }

    System.out.println("******** InitializeServlet::END '" + appDir + "'");
  }


  public static String getContextName(String path) {
    //  :  path = /usr/local/jakarta-tomcat-3.2.4/webapps/dwarf/
    int n = path.lastIndexOf(File.separator);
    String wk = path.substring(0, n);
    int k = wk.lastIndexOf(File.separator);
    path = wk.substring(k + 1);
    // :   path = dwarf
    return path;
  }
  

  /**
   * doGet() \bh
   */
  protected final void doGet(HttpServletRequest request, HttpServletResponse res) throws ServletException, IOException {
  }
  protected final void doPost(HttpServletRequest request, HttpServletResponse res) throws ServletException, IOException {
  }

}
