/*
 * $Id: ProcessValidationsPhase.java,v 1.21.32.1 2006/04/12 19:32:20 ofung Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.faces.lifecycle;

import com.sun.faces.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.faces.FacesException;
import javax.faces.component.*;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import java.util.List;

/**
 * ProcessValidationsPhase executes <code>processValidators</code> on each
 * component in the tree.
 */
public class ProcessValidationsPhase extends Phase {

//
// Protected Constants
//
    
// Log instance for this class
    protected static Log log = LogFactory.getLog(ProcessValidationsPhase.class);

//
// Class Variables
//

//
// Instance Variables
//

// Attribute Instance Variables

// Relationship Instance Variables

//
// Constructors and Genericializers    
//

    public ProcessValidationsPhase() {
    }

//
// Class methods
//

//
// General Methods
//

//
// Methods from Phase
//

    public PhaseId getId() {
        return PhaseId.PROCESS_VALIDATIONS;
    }


    public void execute(FacesContext facesContext) throws FacesException {
        if (log.isDebugEnabled()) {
            log.debug("Entering ProcessValidationsPhase");
        }
        UIComponent component = facesContext.getViewRoot();
        Util.doAssert(null != component);

        try {
           // component.processValidators(facesContext);
          recursiveValidate(facesContext, component);
        } catch (RuntimeException re) {
            String exceptionMessage = re.getMessage();
            if (null != exceptionMessage) {
                if (log.isErrorEnabled()) {
                    log.error(exceptionMessage, re);
                }
            }
	    throw new FacesException(exceptionMessage, re);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exiting ProcessValidationsPhase");
        }
    }

  public void recursiveValidate(FacesContext facesContext, UIComponent component) throws FacesException {

   // log.info("recursiveValidate:" + component.getClass().getName() + ", !isRendered = " + (!component.isRendered()) );

    List childs = component.getChildren();
    for (int i = 0; i < childs.size(); i++) {
      UIComponent kid = (UIComponent) childs.get(i);
      recursiveValidate(facesContext, kid);
    }
    if (component instanceof UIInput)  component.processValidators(facesContext);
  }

// The testcase for this class is TestProcessValidationsPhase.java


} // end of class ProcessValidationsPhase
