/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [2006] [Masahito Henmi]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package dwarf.jsf.support;

import java.util.*;
import java.util.Map;
/**
 *   OReLXgŎgl̃x[XNX
 *
 *    com.sun.faces.context.ExternalContextImpl ̓NX𕪗
 *
 *  ServletRequest,ServletResponse ȂǂۑNX
 */
public abstract class BaseContextMap extends AbstractMap {

  public void clear() {
    throw new UnsupportedOperationException();
  }

  public void putAll(Map t) {
    throw new UnsupportedOperationException();
  }

  public Object remove(Object key) {
    throw new UnsupportedOperationException();
  }

  static class Entry implements Map.Entry {

    private final Object key;
    private final Object value;


    Entry(Object key, Object value) {
      this.key = key;
      this.value = value;
    }


    public Object getKey() {
      return key;
    }


    public Object getValue() {
      return value;
    }


    public Object setValue(Object value) {
      throw new UnsupportedOperationException();
    }


    public int hashCode() {
      return ((key == null ? 0 : key.hashCode()) ^
              (value == null ? 0 : value.hashCode()));
    }


    public boolean equals(Object obj) {
      if (obj == null || !(obj instanceof Map.Entry))
        return false;

      Map.Entry input = (Map.Entry) obj;
      Object inputKey = input.getKey();
      Object inputValue = input.getValue();

      if (inputKey == key ||
          (inputKey != null && inputKey.equals(key))) {
        if (inputValue == value ||
            (inputValue != null && inputValue.equals(value))) {
          return true;
        }
      }
      return false;
    }
  }
}
