/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [2006] [Masahito Henmi]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package dwarf.jsf.support;

import java.util.*;
import javax.servlet.ServletRequest;
/**
 *   OReLXgŎgl̃x[XNX
 *
 *    com.sun.faces.context.ExternalContextImpl ̓NX𕪗
 *
 *  ServletRequest,ServletResponse ȂǂۑNX
 */
public class ExternalRMap extends BaseContextMap {

  private ServletRequest request = null;

  public ExternalRMap(ServletRequest request) {
    this.request = request;
  }

  public Object get(Object key) {
    if (key == null) {
      throw new NullPointerException();
    }
    return request.getAttribute(key.toString());
  }

  public Object put(Object key, Object value) {
    if (key == null) {
      throw new NullPointerException();
    }
    Object old = request.getAttribute(key.toString());
    request.setAttribute(key.toString(), value);
    return old;
  }

  public Object remove(Object key) {
    if (key == null) {
      return null;
    }
    String keyString = key.toString();
    Object result = request.getAttribute(keyString);
    request.removeAttribute(keyString);
    return (result);
  }


  public Set entrySet() {
    Set entries = new HashSet();
    for (Enumeration e = request.getParameterNames();
         e.hasMoreElements();) {
      String paramName = (String) e.nextElement();
      entries.add(new Entry(paramName, request.getParameter(paramName)));
    }
    return entries;
  }
  /*
  public boolean equals(Object obj) {
    if (obj == null || !(obj instanceof ExternalRPMap))
      return false;
    return super.equals(obj);
  }
   */
}
