/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [2006] [Masahito Henmi]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package dwarf.jsf.support;

import java.util.*;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.*;
/**
 *   OReLXgŎgl̃x[XNX
 *
 *    com.sun.faces.context.ExternalContextImpl ̓NX𕪗
 *
 *  ServletRequest,ۑNX
 */
public class ExternalRPMap extends BaseContextMap {

  private static final Log log = LogFactory.getLog(ExternalRPMap.class);

  
  private ServletRequest request = null;

  public ExternalRPMap(ServletRequest request) {
    this.request = request;
  }

  /** #{param.XXX} ƂƂ putɂ */ 
  public Object put(Object key, Object value) {
    log.debug("#put (" + key + ", " + value + ")   ܂ ");
    return null;
  }  

  public Object get(Object key) {
    if (key == null) {
      throw new NullPointerException();
    }
    String wk = request.getParameter(key.toString());

    String userIn = null;
    if (wk != null) {
      try {
        userIn = new String(wk.getBytes("8859_1"), "MS932");
      } catch (Exception ex) {
      }
    }
    log.debug("#get (" + key + ")   --> " + userIn);

    return userIn;
  }

  public Set entrySet() {
    Set entries = new HashSet();
    for (Enumeration e = request.getParameterNames();
         e.hasMoreElements();) {
      String paramName = (String) e.nextElement();
      entries.add(new Entry(paramName, request.getParameter(paramName)));
    }
    return entries;
  }

  public boolean equals(Object obj) {
    if (obj == null || !(obj instanceof ExternalRPMap))
      return false;
    return super.equals(obj);
  }

}
