/*
 * Copyright 2006 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javax.el;

/**
 *
 */
public class MethodInfo {

    private final String name;
    
    private final Class[] paramTypes;
    
    private final Class returnType;
    
    /**
     * 
     */
    public MethodInfo(String name, Class returnType, Class[] paramTypes) {
        this.name = name;
        this.returnType = returnType;
        this.paramTypes = paramTypes;
    }
    
    public String getName() {
        return this.name;
    }
    
    public Class[] getParamTypes() {
        return this.paramTypes;
    }
    
    public Class getReturnType() {
        return this.returnType;
    }

}
