package strawberry;

import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;

import javax.faces.render.RenderKitFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

import java.util.Map;
import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletRequest;

import com.sun.faces.RIConstants;
import com.sun.faces.util.Util;
//import dwarf.jsf.context.ExternalContextGx;

import com.sun.faces.context.FacesContextImpl;
import com.sun.facelets.impl.ResourceResolver;


import org.apache.commons.logging.*;
import strawberry.configure.ApplicationInitializerEx;
import strawberry.configure.RenderKitFactoryInitializerEx;
/**
 * Created on 2007/01/14,
 * @author  masa
 */
public class FaceletsBridgeImpl implements FaceletsBridge {

  private static final Log log = LogFactory.getLog(FaceletsBridgeImpl.class);

  public FaceletsBridgeImpl() {
    log.info("RXgN^ ---");
  }
  
  

  RenderKitFactory   rkFactory   = null;
  Application        application = null;
  
  public void doLifecycle(final ExternalContext ec, ResourceResolver rr) throws FacesException {


    if (facesContextFactory == null && lifecycle == null) init();

    if (application == null) {
      ApplicationInitializerEx cla = new ApplicationInitializerEx();
      try {

        cla.setResourceResolver(rr);
        
        application = cla.createApplication((ServletContext) ec.getContext());
      } catch (Exception ex) {
        throw new RuntimeException(ex);
      }
    }
    
    if (rkFactory == null) {
      RenderKitFactoryInitializerEx clr = new RenderKitFactoryInitializerEx();
      rkFactory = clr.configureRenderKits();
    }
    
    FacesContext context = new FacesContextImpl(ec, lifecycle, rkFactory, application);
    log.info("(118) =======service ");

    //log.info("=======FacesContext " + context);
//    Application application = context.getApplication();
    /*
    log.info("=======getApplication        " + application);
    log.info("=======getActionListener     " + application.getActionListener());
    log.info("=======getDefaultLocale      " + application.getDefaultLocale());
    log.info("=======getDefaultRenderKitId " + application.getDefaultRenderKitId());
    log.info("=======getMessageBundle      " + application.getMessageBundle());
    log.info("=======getNavigationHandler  " + application.getNavigationHandler());
    log.info("=======getPropertyResolver   " + application.getPropertyResolver());
    log.info("=======getVariableResolver   " + application.getVariableResolver());
    log.info("=======getViewHandler        " + application.getViewHandler());
    log.info("=======getStateManager       " + application.getStateManager());
*/

    // Execute the request processing lifecycle for this request
    try {
      lifecycle.execute(context);
      lifecycle.render(context);

    } finally {
      // Release the FacesContext instance for this request
      context.release();
    }
  }


  private FacesContextFactory facesContextFactory = null;

  private Lifecycle lifecycle = null;

  public void init() {

    facesContextFactory = new com.sun.faces.context.FacesContextFactoryImpl();

    LifecycleFactory lifecycleFactory = new com.sun.faces.lifecycle.LifecycleFactoryImpl();
    String  lifecycleId = LifecycleFactory.DEFAULT_LIFECYCLE;
    lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
  }

}
