package strawberry.configure;

import com.sun.facelets.FaceletViewHandler;

import com.sun.facelets.impl.ResourceResolver;
import com.sun.faces.application.*;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.*;
import javax.servlet.ServletContext;
import strawberry.configure.SetupUtilEx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * AvP[V
 */
public class ApplicationInitializerEx {

  static final Log log = LogFactory.getLog(ApplicationInitializerEx.class);

  public Application createApplication(ServletContext servletContext) throws Exception {

    Application application = configureFactory();
    log.debug("(51) application 쐬I =  " + application);

    if (servletContext == null) throw new NullPointerException();

    configureApplication(application);
    configureComponents(application);
    configureConverters(application);
    configureLocale(application);
    configureValidators( application );
    return application;
  }



  String[] validators = {
    "javax.faces.DoubleRange",             "javax.faces.validator.DoubleRangeValidator",
    "javax.faces.Length",                  "javax.faces.validator.LengthValidator",
    "javax.faces.LongRange",               "javax.faces.validator.LongRangeValidator",
  };

  public void configureValidators( Application application ) {

    for (int i = 0; i < validators.length; i += 2) {
      String validatorId    = validators[i + 0];
      String validatorClass = validators[i + 1];

      log.trace("addValidator(" + validatorId + ',' +   validatorClass + ")    @@@");

      application.addValidator(validatorId, validatorClass);
    }
  }

  private static final Class PRIM_CLASSES_TO_CONVERT[] = {
    java.lang.Boolean.TYPE,
    java.lang.Byte.TYPE,
    java.lang.Character.TYPE,
    java.lang.Double.TYPE,
    java.lang.Float.TYPE,
    java.lang.Integer.TYPE,
    java.lang.Long.TYPE,
    java.lang.Short.TYPE
    };

  /**
   * <p>Array of known converters for primitive types.</p>
   */
  private static final String CONVERTERS_FOR_PRIMS[] = {
    "javax.faces.convert.BooleanConverter",
    "javax.faces.convert.ByteConverter",
    "javax.faces.convert.CharacterConverter",
    "javax.faces.convert.DoubleConverter",
    "javax.faces.convert.FloatConverter",
    "javax.faces.convert.IntegerConverter",
    "javax.faces.convert.LongConverter",
    "javax.faces.convert.ShortConverter"
    };



  String[]  converId = {
    "javax.faces.BigDecimal",    "javax.faces.convert.BigDecimalConverter",
    "javax.faces.BigInteger",    "javax.faces.convert.BigIntegerConverter",
    "javax.faces.Boolean",    "javax.faces.convert.BooleanConverter",
    "javax.faces.Byte",    "javax.faces.convert.ByteConverter",
    "javax.faces.Character",    "javax.faces.convert.CharacterConverter",
    "javax.faces.DateTime",    "javax.faces.convert.DateTimeConverter",
    "javax.faces.Double",    "javax.faces.convert.DoubleConverter",
    "javax.faces.Float",    "javax.faces.convert.FloatConverter",
    "javax.faces.Integer",    "javax.faces.convert.IntegerConverter",
    "javax.faces.Long",    "javax.faces.convert.LongConverter",
    "javax.faces.Number",    "javax.faces.convert.NumberConverter",
    "javax.faces.Short",    "javax.faces.convert.ShortConverter",

  };

  
  
  private void configureConverters(Application application ) throws Exception {

    int i = 0, len = 0;

    // at a minimum, configure the primitive converters
    for (i = 0, len = PRIM_CLASSES_TO_CONVERT.length; i < len; i++) {
      log.trace("addConverterByClass(" + PRIM_CLASSES_TO_CONVERT[i] + ',' +
                CONVERTERS_FOR_PRIMS[i] + ")    @@@");

      application.addConverter(PRIM_CLASSES_TO_CONVERT[i], CONVERTERS_FOR_PRIMS[i]);
    }


    for (int j = 0; j < converId.length; j += 2) {
      String converterId = converId[j + 0];
      String converterClass = converId[j + 1];
      log.trace("(284) converterId = " + converterId + ", converterClass = " +  converterClass);
      
      application.addConverter(converterId,  converterClass);
    }
  }

  //Configure Standard By-Id Converters
  //C:/javasrc/jsf1.1_02fcs-src/jsf-ri/src/com/sun/faces/jsf-ri-config.xml


  public void configureLocale(Application application) {

    application.setDefaultLocale(Util.getLocaleFromString("ja"));

    String[] values = {"en", "ja"};

    List locales = new ArrayList();
    for (int i = 0; i < values.length; i++) {
      if (log.isTraceEnabled()) {
        log.trace("addSupportedLocale(" + values[i] + ')');
      }
      locales.add(Util.getLocaleFromString(values[i]));
    }
    application.setSupportedLocales(locales);
  }
  private void configureApplication(Application application) {

    log.trace("(283) setActionListener ----- ");
    application.setActionListener(new com.sun.faces.application.ActionListenerImpl());
  }
  // ǉR|[lgƂ
  String[] otherComponents = {

  };

  public void configureComponents(Application application) {
    SetupUtilEx util = new SetupUtilEx();
    util.addStandardComponents( application);
    util.addComponents( application, otherComponents);
  }


  
  public Application configureFactory() {
    return this.getApplication();
  }

  ResourceResolver crr = null;

  public ResourceResolver getResourceResolver() {
    return crr;
  }
  
  public void setResourceResolver(ResourceResolver newValue) {
    crr = newValue;
  }
  
  
  public Application getApplication() {

    Application application = null;
    if (application == null) {
      application = new ApplicationImpl();

      ViewHandler original = new ViewHandlerImpl();

      FaceletViewHandler faceletVH = new FaceletViewHandler(original);
      // FaceletɕύX
      faceletVH.setCustomizedResourceResolver(getResourceResolver());

      log.debug("setResourceResolver Ă܂!! ");
      
      application.setViewHandler(faceletVH);

      if (log.isDebugEnabled()) {
        log.debug("Created Application instance " + application);
      }
    }
    return application;
  }
}
