package strawberry.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * Created on 2007/02/17, 18:08
 * @author masa
 */
public class MockELResolver extends ELResolver {
  
  private static final Log log = LogFactory.getLog(MockELResolver.class);
  
  /** Creates a new instance of MockELResolver */
  public MockELResolver() {
  }

  public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
    log.debug("setValue");
    pri.setValue(base, property, value);
  }

  public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
    log.debug("isReadOnly");
    throw new UnsupportedOperationException();
  }

  com.sun.faces.el.PropertyResolverImpl pri = new com.sun.faces.el.PropertyResolverImpl();
  
  public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
    log.debug("getValue   " + base + ", " + property );
    return pri.getValue(base, property);
  }

  public Class getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
    log.debug("getType");

    return pri.getType(base, property);
  }

  public Iterator getFeatureDescriptors(ELContext context, Object base) {
    log.debug("getFeatureDescriptors");
    throw new UnsupportedOperationException();
  }

  public Class getCommonPropertyType(ELContext context, Object base) {
    log.debug("getCommonPropertyType");
    throw new UnsupportedOperationException();
  }
  
}
