package strawberry.el;

import com.sun.faces.RIConstants;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import strawberry.application.ApplicationAssociate;
/**
 * Created on 2007/02/19, 21:05
 *
 * @author masa
 */
public class Next6ValueExpression extends ValueExpression {

  private static final Log log = LogFactory.getLog(Next6ValueExpression.class);

  FacesContext facesContext = null;
  String name;

  public Next6ValueExpression(FacesContext facesContext, String name) {
    this.name = name;
    this.facesContext = facesContext;
  }

  public void setValue(ELContext context, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
    throw new UnsupportedOperationException();
  }

  public boolean isReadOnly(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
    throw new UnsupportedOperationException();
  }

  public Object getValue(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {

    log.debug("-------------------getValue");

    ExternalContext ec = facesContext.getExternalContext();

    if (RIConstants.APPLICATION_SCOPE.equals(name)) {
      return (ec.getApplicationMap());
    } else if (RIConstants.COOKIE_IMPLICIT_OBJ.equals(name)) {
      return (ec.getRequestCookieMap());
    } else if (RIConstants.FACES_CONTEXT_IMPLICIT_OBJ.equals(name)){
      return (context);
    } else if (RIConstants.HEADER_IMPLICIT_OBJ.equals(name)) {
      return (ec.getRequestHeaderMap());
    } else if (RIConstants.HEADER_VALUES_IMPLICIT_OBJ.equals(name)){
      return (ec.getRequestHeaderValuesMap());
    } else if (RIConstants.INIT_PARAM_IMPLICIT_OBJ.equals(name)) {
      return (ec.getInitParameterMap());
    } else if (RIConstants.PARAM_IMPLICIT_OBJ.equals(name)) {
      return (ec.getRequestParameterMap());
    } else if (RIConstants.PARAM_VALUES_IMPLICIT_OBJ.equals(name)) {
      return (ec.getRequestParameterValuesMap());
    } else if (RIConstants.REQUEST_SCOPE.equals(name)) {
      return (ec.getRequestMap());
    } else if (RIConstants.SESSION_SCOPE.equals(name)) {
      return (ec.getSessionMap());
    } else if (RIConstants.VIEW_IMPLICIT_OBJ.equals(name)) {
      return (facesContext.getViewRoot());
    } else {
      // do the scoped lookup thing
      Object value = null;

      if (null == (value = ec.getRequestMap().get(name))) {
        if (null == (value = ec.getSessionMap().get(name))) {
          if (null == (value = ec.getApplicationMap().get(name))) {
            // if it's a managed bean try and create it
            ApplicationAssociate associate =
              ApplicationAssociate.getInstance(facesContext.getExternalContext());

            if (null != associate) {
              log.debug("(79) ********** associate != null ");
              value = associate.createAndMaybeStoreManagedBeans(facesContext,
                                                                name);
            } else {
              log.debug("(83) ********** associate is null !!");
            }
          }
        }
      }
      if (log.isDebugEnabled()) {
        String wk = "null";
        if (value != null) wk = value.toString();
        if (wk.length() > 70) wk = wk.substring(0, 70);
        log.debug("resolveVariable: Resolved variable:" + wk);
      }
      return (value);
    }
  }

  public Class getType(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
    throw new UnsupportedOperationException();
  }

  public boolean isLiteralText() {
    throw new UnsupportedOperationException();
  }

  public String getExpressionString() {
    throw new UnsupportedOperationException();
  }

  public Class getExpectedType() {
    throw new UnsupportedOperationException();
  }

  public boolean equals(Object obj) {
    return false;
  }

  public String toString() {
    return "Next6ValueExpression[name = " + name + "]";
  }

  public int hashCode() {
    return 123;
  }

}
