package strawberry.util;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 *  2007.2.17  dwarfp
 */
public class DLoadServlet extends HttpServlet {
  /**
   * VACY\NXΉ<br>
   */
  static final long serialVersionUID = 0x000000000000006CL;

  /**
   *  
   */
  public void init(ServletConfig config) throws ServletException {
    super.init(config);
  }

  
  /**
  public BtvProperties getConfigProperties() {
    BtvProperties menuProp = new BtvProperties();
    try {
      InputStream is = getServletContext().getResourceAsStream("WEB-INF/btv.properties");
      try {
        menuProp.load(is);
      } finally {
        is.close();
      }
    } catch (Exception e) {
      throw new RuntimeException(e.getMessage());
    }

    return menuProp;
  }
   */


  /**
   * doGet() \bh
   */
  protected final void doGet(HttpServletRequest request, HttpServletResponse res) throws ServletException, IOException {
    try {
      HttpSession ses = request.getSession();

      doGetProcess(request, res, ses);
    } catch (Exception ex) {
      throw new ServletException(ex);
    }
  }


  public void doGetProcess(HttpServletRequest req, HttpServletResponse res, HttpSession ses) throws Exception {
    ActionForm ac = new ActionForm();
    HttpUtil.setData(ac, req, "");

    DebugModeBean bean = new DebugModeBean();
    bean.setApplicationContext(getServletContext());
    bean.setServletName("ALoadServlet");

    String mode = ac.getString("mode");
    System.out.println("ALoadServlet::doGet, mode = " + mode);

    if ("del".equals(mode)) {
      bean.delete(ac, res, ses);
    } else if ("confirm".equals(mode)) {
      bean.confirm(ac, res, ses);
    } else if ("show".equals(mode)) {
      bean.showDetail(ac, res, ses);
    } else {
      bean.showInfo( req,  res,  ses);
    }
  }

  public String advisableContentType() {
    String ver = System.getProperty("java.version");
    String encoding = (ver.compareTo("1.4.1") < 0) ? "Shift_JIS" : "Windows-31J";

    return "text/html; charset=\"" + encoding + "\"";
  }
}
