/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.util.Locale;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.i18n.LocaleListener;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.AboutAction;
import net.jankenpoi.sudokuki.ui.swing.ActionsRepository;
import net.jankenpoi.sudokuki.ui.swing.CheckUpdateAction;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.OpenUpdateSiteAction;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;
import net.jankenpoi.sudokuki.ui.swing.TranslateAction;

public class HelpMenu
extends JMenu
implements L10nComponent {
    private final JFrame parent;
    private final JMenuItem itemCheckUpdate = new JMenuItem();
    private final Action actionCheckUpdate;
    private final JMenuItem itemUpdateSite = new JMenuItem();
    private final Action actionOpenUpdateSite;
    private final JMenuItem itemTranslate = new JMenuItem();
    private final Action actionTranslate;
    private final JMenuItem itemAbout = new JMenuItem();
    private final Action actionAbout;
    private final LocaleListener localeListener;

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setText(I18n._("Help"));
        this.itemCheckUpdate.setText(I18n._("Update"));
        this.actionCheckUpdate.putValue("SmallIcon", StockIcons.ICON_VIEW_REFRESH);
        this.actionCheckUpdate.putValue("ShortDescription", I18n._("Check for updates"));
        this.actionCheckUpdate.putValue("MnemonicKey", new Integer(85));
        this.itemUpdateSite.setText(I18n._("Download"));
        this.actionOpenUpdateSite.putValue("SmallIcon", StockIcons.ICON_UPDATE_AVAILABLE);
        this.actionOpenUpdateSite.putValue("ShortDescription", I18n._("Download new version"));
        this.actionOpenUpdateSite.putValue("MnemonicKey", new Integer(68));
        this.itemTranslate.setText(I18n._("Translate this application"));
        this.actionTranslate.putValue("SmallIcon", StockIcons.ICON_TRANSLATE);
        this.actionTranslate.putValue("ShortDescription", I18n._(I18n._("Help translate this application")));
        this.actionTranslate.putValue("MnemonicKey", new Integer(84));
        this.itemAbout.setText(I18n._("About..."));
        this.actionAbout.putValue("SmallIcon", StockIcons.ICON_HELP_ABOUT);
        this.actionAbout.putValue("ShortDescription", I18n._("About Sudokuki..."));
        this.actionAbout.putValue("MnemonicKey", new Integer(80));
    }

    HelpMenu(ActionsRepository actionsRepository, JFrame jFrame) {
        this.parent = jFrame;
        this.setMnemonic(72);
        this.getAccessibleContext().setAccessibleDescription("The only menu in this program that has menu items");
        this.actionOpenUpdateSite = new OpenUpdateSiteAction(this.parent);
        actionsRepository.put("OpenUpdateSite", this.actionOpenUpdateSite);
        this.actionCheckUpdate = new CheckUpdateAction(this.parent, this.actionOpenUpdateSite);
        actionsRepository.put("CheckUpdate", this.actionCheckUpdate);
        this.actionTranslate = new TranslateAction(this.parent);
        actionsRepository.put("Translate", this.actionTranslate);
        this.actionAbout = new AboutAction(this.parent);
        actionsRepository.put("About", this.actionAbout);
        this.addItems();
        this.setL10nMessages(null, I18n._("DETECTED_LANGUAGE"));
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
    }

    private void addItems() {
        this.itemCheckUpdate.setAction(this.actionCheckUpdate);
        this.add(this.itemCheckUpdate);
        this.itemUpdateSite.setAction(this.actionOpenUpdateSite);
        this.add(this.itemUpdateSite);
        this.addSeparator();
        this.itemTranslate.setAction(this.actionTranslate);
        this.add(this.itemTranslate);
        this.addSeparator();
        this.itemAbout.setAction(this.actionAbout);
        this.add(this.itemAbout);
    }
}

