/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.i18n.LocaleListener;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;

public class LanguageMenu
extends JMenu
implements L10nComponent {
    private HashMap<String, JRadioButtonMenuItem> itemsMap = new HashMap();
    private String langCode;
    private final LocaleListener localeListener;

    public LanguageMenu() {
        this.addItems();
        this.setIcon(LanguageMenu.languageIcon(I18n._("DETECTED_LANGUAGE")));
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                String string = I18n._("DETECTED_LANGUAGE");
                LanguageMenu.this.langCode = string;
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                I18n.reset(LanguageMenu.this.langCode);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
                I18n.reset(LanguageMenu.this.langCode);
            }
        });
        String string = I18n._("DETECTED_LANGUAGE");
        JRadioButtonMenuItem jRadioButtonMenuItem = this.itemsMap.get(string);
        this.setText(I18n._("Language"));
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
    }

    private void addItems() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.addItem("ar", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", buttonGroup);
        this.addItem("de", "Deutsch", buttonGroup);
        this.addItem("el", "E\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", buttonGroup);
        this.addItem("en", "English", buttonGroup);
        this.addItem("eo", "Esperanto", buttonGroup);
        this.addItem("es", "Espa\u00f1ol", buttonGroup);
        this.addItem("fr", "Fran\u00e7ais", buttonGroup);
        this.addItem("hu", "Hungarian", buttonGroup);
        this.addItem("ja", "\u65e5\u672c\u8a9e", buttonGroup);
        this.addItem("lv", "Latvie\u0161u", buttonGroup);
        this.addItem("nl", "Nederlands", buttonGroup);
        this.addItem("pt", "Portugu\u00eas", buttonGroup);
        this.addItem("pt_BR", "Portugu\u00eas (Brasil)", buttonGroup);
        this.addItem("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", buttonGroup);
        this.addItem("zh", "\u4e2d\u6587", buttonGroup);
    }

    private void addItem(final String string, String string2, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
        this.itemsMap.put(string, jRadioButtonMenuItem);
        jRadioButtonMenuItem.setAction(new AbstractAction(string2, LanguageMenu.languageIcon(string)){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                I18n.reset(string);
            }
        });
        jRadioButtonMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                I18n.reset(string);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                I18n.reset(LanguageMenu.this.langCode);
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        this.add(jRadioButtonMenuItem);
    }

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setText(I18n._("Language"));
        this.setIcon(LanguageMenu.languageIcon(string));
        JRadioButtonMenuItem jRadioButtonMenuItem = this.itemsMap.get(string);
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
        if (this.isSelected()) {
            return;
        }
    }

    public static Icon languageIcon(String string) {
        if ("ar".equals(string)) {
            return StockIcons.ICON_FLAG_AR;
        }
        if ("de".equals(string)) {
            return StockIcons.ICON_FLAG_DE;
        }
        if ("el".equals(string)) {
            return StockIcons.ICON_FLAG_EL;
        }
        if ("eo".equals(string)) {
            return StockIcons.ICON_FLAG_EO;
        }
        if ("en".equals(string)) {
            return StockIcons.ICON_FLAG_EN;
        }
        if ("es".equals(string)) {
            return StockIcons.ICON_FLAG_ES;
        }
        if ("fr".equals(string)) {
            return StockIcons.ICON_FLAG_FR;
        }
        if ("hu".equals(string)) {
            return StockIcons.ICON_FLAG_HU;
        }
        if ("ja".equals(string)) {
            return StockIcons.ICON_FLAG_JA;
        }
        if ("lv".equals(string)) {
            return StockIcons.ICON_FLAG_LV;
        }
        if ("nl".equals(string)) {
            return StockIcons.ICON_FLAG_NL;
        }
        if ("pt".equals(string)) {
            return StockIcons.ICON_FLAG_PT;
        }
        if ("pt_BR".equals(string)) {
            return StockIcons.ICON_FLAG_BR;
        }
        if ("ru".equals(string)) {
            return StockIcons.ICON_FLAG_RU;
        }
        if ("zh".equals(string)) {
            return StockIcons.ICON_FLAG_ZH;
        }
        return StockIcons.ICON_GO_HOME;
    }
}

