/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.jankenpoi.sudokuki.ui.swing.DualSelectionDialog;

public class SelectNumberPanel
extends JPanel {
    private static int FONT_SIZE = 20;
    Font font = new Font("Serif", 0, FONT_SIZE);
    private int digit = -1;
    private JButton btn1 = new JButton();
    private JButton btn2 = new JButton();
    private JButton btn3 = new JButton();
    private JButton btn4 = new JButton();
    private JButton btn5 = new JButton();
    private JButton btn6 = new JButton();
    private JButton btn7 = new JButton();
    private JButton btn8 = new JButton();
    private JButton btn9 = new JButton();
    private JButton[] btns = new JButton[]{this.btn1, this.btn2, this.btn3, this.btn4, this.btn5, this.btn6, this.btn7, this.btn8, this.btn9};
    private JPanel panel789 = new JPanel(new GridLayout());
    private JPanel panel456 = new JPanel(new GridLayout());
    private JPanel panel123 = new JPanel(new GridLayout());
    private byte previousValue = 0;
    private InnerKeyListener innerKeyListener = new InnerKeyListener();
    private int focusedElement = 4;
    private InnerFocusListener innerFocusListener = new InnerFocusListener();
    private DualSelectionDialog parent;

    public SelectNumberPanel(DualSelectionDialog dualSelectionDialog, byte by) {
        this.parent = dualSelectionDialog;
        this.previousValue = by;
        this.initComponents();
        this.btns[this.focusedElement].requestFocusInWindow();
        dualSelectionDialog.getTabbedPane().addKeyListener(this.innerKeyListener);
        dualSelectionDialog.getTabbedPane().addFocusListener(this.innerFocusListener);
    }

    private void configureButton(JButton jButton, String string, final int n) {
        jButton.setHorizontalTextPosition(0);
        if (this.previousValue == n) {
            jButton.setText("");
        } else {
            jButton.setText(string);
        }
        jButton.setToolTipText(string);
        jButton.setFont(this.font);
        jButton.setCursor(new Cursor(12));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectNumberPanel.this.buttonClicked(n);
            }
        });
        jButton.addKeyListener(this.innerKeyListener);
        jButton.addFocusListener(this.innerFocusListener);
    }

    private void initComponents() {
        this.configureButton(this.btn1, "1", 1);
        this.configureButton(this.btn2, "2", 2);
        this.configureButton(this.btn3, "3", 3);
        this.configureButton(this.btn4, "4", 4);
        this.configureButton(this.btn5, "5", 5);
        this.configureButton(this.btn6, "6", 6);
        this.configureButton(this.btn7, "7", 7);
        this.configureButton(this.btn8, "8", 8);
        this.configureButton(this.btn9, "9", 9);
        GridLayout gridLayout = new GridLayout(3, 1);
        this.setLayout(gridLayout);
        this.add(this.panel789);
        this.add(this.panel456);
        this.add(this.panel123);
        this.panel789.add((Component)this.btn7, "Before");
        this.panel789.add((Component)this.btn8, "Center");
        this.panel789.add((Component)this.btn9, "After");
        this.panel456.add((Component)this.btn4, "Before");
        this.panel456.add((Component)this.btn5, "Center");
        this.panel456.add((Component)this.btn6, "After");
        this.panel123.add((Component)this.btn1, "Before");
        this.panel123.add((Component)this.btn2, "Center");
        this.panel123.add((Component)this.btn3, "After");
    }

    private boolean isTabSelected() {
        int n = this.parent.getTabbedPane().getSelectedIndex();
        return n == 0;
    }

    private void buttonClicked(int n) {
        this.digit = n;
        this.parent.numberPanelConfirmed();
    }

    public int getClickedDigit() {
        return this.digit;
    }

    private class InnerFocusListener
    extends FocusAdapter {
        private InnerFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component == SelectNumberPanel.this.btns[SelectNumberPanel.this.focusedElement]) {
                return;
            }
            for (int i = 0; i < SelectNumberPanel.this.btns.length; ++i) {
                if (component != SelectNumberPanel.this.btns[i]) continue;
                SelectNumberPanel.this.focusedElement = i;
                return;
            }
        }
    }

    private class InnerKeyListener
    extends KeyAdapter {
        private InnerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (this.focusedTabPane() && SelectNumberPanel.this.isTabSelected()) {
                n = keyEvent.getKeyCode();
                if (n == 76) {
                    int n2 = SelectNumberPanel.this.parent.getTabbedPane().getSelectedIndex();
                    int n3 = n2 == 0 ? 1 : 0;
                    SelectNumberPanel.this.parent.getTabbedPane().setSelectedIndex(n3);
                    SelectNumberPanel.this.parent.getTabbedPane().requestFocusInWindow();
                    return;
                }
                if (n == 72) {
                    return;
                }
            }
            if (!SelectNumberPanel.this.isTabSelected()) {
                return;
            }
            n = keyEvent.getKeyCode();
            if (n == 225 || n == 40 || n == 74) {
                if (this.focusedTabPane()) {
                    SelectNumberPanel.this.focusedElement = 7;
                    SelectNumberPanel.this.btns[SelectNumberPanel.this.focusedElement].requestFocusInWindow();
                    return;
                }
                if (SelectNumberPanel.this.focusedElement / 3 == 0) {
                    return;
                }
                SelectNumberPanel.this.focusedElement = Math.max(0, SelectNumberPanel.this.focusedElement - 3);
                SelectNumberPanel.this.btns[SelectNumberPanel.this.focusedElement].requestFocusInWindow();
            } else if (n == 224 || n == 38 || n == 75) {
                if (this.focusedTabPane()) {
                    return;
                }
                if (SelectNumberPanel.this.focusedElement / 3 == 2) {
                    SelectNumberPanel.this.parent.getTabbedPane().requestFocusInWindow();
                    return;
                }
                SelectNumberPanel.this.focusedElement = Math.min(8, SelectNumberPanel.this.focusedElement + 3);
                SelectNumberPanel.this.btns[SelectNumberPanel.this.focusedElement].requestFocusInWindow();
            } else if (n == 226 || n == 37 || n == 72) {
                if (SelectNumberPanel.this.focusedElement % 3 == 0) {
                    return;
                }
                SelectNumberPanel.this.focusedElement = Math.max(0, SelectNumberPanel.this.focusedElement - 1);
                SelectNumberPanel.this.btns[SelectNumberPanel.this.focusedElement].requestFocusInWindow();
            } else if (n == 227 || n == 39 || n == 76) {
                if (SelectNumberPanel.this.focusedElement % 3 == 2) {
                    return;
                }
                SelectNumberPanel.this.focusedElement = Math.min(8, SelectNumberPanel.this.focusedElement + 1);
                SelectNumberPanel.this.btns[SelectNumberPanel.this.focusedElement].requestFocusInWindow();
            } else if (n == 27) {
                SelectNumberPanel.this.parent.numberPanelEscaped();
            }
        }

        private boolean focusedTabPane() {
            boolean bl = SelectNumberPanel.this.parent.getTabbedPane().hasFocus();
            return bl;
        }
    }
}

