/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.PaintEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.jankenpoi.sudokuki.model.GridModel;
import net.jankenpoi.sudokuki.model.Position;
import net.jankenpoi.sudokuki.preferences.UserPreferences;
import net.jankenpoi.sudokuki.ui.swing.DualSwingSelector;
import net.jankenpoi.sudokuki.ui.swing.Images;
import net.jankenpoi.sudokuki.view.GridView;

public class SwingGrid
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    private GridView view;
    private static final int offset = 2;
    private final int MIN_CELL_SIZE = 20;
    private int MAX_CELL_SIZE = 40;
    private int CELL_SIZE;
    private int FONT_SIZE;
    private MouseListener innerMouseListener;
    private KeyListener innerKeyListener;
    private ComponentListener componentListener;
    private final Timer timer;
    private int posX;
    private int posY;
    private JFrame parent;
    private static String[] digits = new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "", "\u0661", "\u0662", "\u0663", "\u0664", "\u0665", "\u0666", "\u0667", "\u0668", "\u0669"};

    SwingGrid(GridView gridView, JFrame jFrame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.MAX_CELL_SIZE = (Math.min(dimension.width, dimension.height) - 4) / 9;
        this.CELL_SIZE = 32;
        this.FONT_SIZE = this.CELL_SIZE * 5 / 6;
        this.innerMouseListener = new InnerMouseListener();
        this.innerKeyListener = new InnerKeyListener();
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Component component = (Component)componentEvent.getSource();
                SwingGrid.this.CELL_SIZE = Math.min(component.getSize().width - 4 - 3, component.getSize().height - 4 - 3) / 9;
                SwingGrid.this.CELL_SIZE = Math.max(SwingGrid.this.CELL_SIZE, 20);
                SwingGrid.this.CELL_SIZE = Math.min(SwingGrid.this.CELL_SIZE, SwingGrid.this.MAX_CELL_SIZE);
                SwingGrid.this.FONT_SIZE = SwingGrid.this.CELL_SIZE * 5 / 6;
                int n = 9 * SwingGrid.this.CELL_SIZE + 4 + 3;
                component.setPreferredSize(new Dimension(n, n));
                component.repaint();
                SwingGrid.this.parent.pack();
                SwingGrid.this.timer.stop();
                SwingGrid.this.timer.start();
            }
        };
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingGrid.this.CELL_SIZE = Math.min(SwingGrid.this.getSize().width - 4, SwingGrid.this.getSize().height - 4) / 9;
                SwingGrid.this.CELL_SIZE = Math.max(SwingGrid.this.CELL_SIZE, 20);
                SwingGrid.this.CELL_SIZE = Math.min(SwingGrid.this.CELL_SIZE, SwingGrid.this.MAX_CELL_SIZE);
                SwingGrid.this.FONT_SIZE = SwingGrid.this.CELL_SIZE * 5 / 6;
                int n = 9 * SwingGrid.this.CELL_SIZE + 4 + 3;
                SwingGrid.this.setPreferredSize(new Dimension(n, n));
                SwingGrid.this.repaint();
                SwingGrid.this.parent.pack();
            }
        });
        this.timer.setRepeats(false);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (!(aWTEvent instanceof PaintEvent)) {
                    return;
                }
                SwingGrid.this.timer.stop();
                SwingGrid.this.timer.start();
            }
        }, 8192L);
        this.posX = 4;
        this.posY = 4;
        this.parent = jFrame;
        this.view = gridView;
        this.addMouseListener(this.innerMouseListener);
        this.addKeyListener(this.innerKeyListener);
        this.addComponentListener(this.componentListener);
        int n = 9 * this.CELL_SIZE + 4 + 3;
        this.setPreferredSize(new Dimension(n, n));
    }

    private Point getPosition(Graphics2D graphics2D, int n, int n2, String string) {
        if (0 > n || n >= 9 || 0 > n2 || n2 >= 9) {
            throw new IllegalArgumentException();
        }
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont());
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.stringWidth(string);
        int n5 = this.startPos(n2) + (this.CELL_SIZE - n4) / 2;
        int n6 = this.startPos(n) + (this.CELL_SIZE + n3 / 2) / 2;
        return new Point(n5, n6 + 1);
    }

    private Point getPositionForMemo(Graphics2D graphics2D, int n, int n2, int n3) {
        if (0 > n || n >= 9 || 0 > n2 || n2 >= 9) {
            throw new IllegalArgumentException();
        }
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont());
        int n4 = fontMetrics.getHeight();
        int n5 = fontMetrics.stringWidth("X");
        int n6 = this.startPos(n2) + this.CELL_SIZE / 2 - n5 / 2;
        int n7 = this.startPos(n) + this.CELL_SIZE / 2 + n4 / 4;
        int n8 = (9 - n3) % 3 - 1;
        int n9 = (9 - n3) / 3 - 1;
        n6 = n6 - n8 * (this.CELL_SIZE / 3) + 1;
        n7 = n7 - n9 * (this.CELL_SIZE / 3) + 1;
        return new Point(n6, n7);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintGridBoard(graphics2D);
        this.paintFocusMark(graphics2D);
        int n = UserPreferences.getInstance().getInteger("numbersMode", 0);
        this.paintGridNumbers(graphics2D, n);
        this.paintPlayerMemos(graphics2D);
        this.paintPlayerNumbers(graphics2D, n);
    }

    private void paintGridNumbers(Graphics2D graphics2D, int n) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.BLACK);
        Font font = new Font("Serif", 1, this.FONT_SIZE - (n == 1 ? 4 : 0));
        graphics2D.setFont(font);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (!this.view.isCellReadOnly(i, j)) continue;
                String string = this.getValueAsStringAt(i, j, n);
                Point point = this.getPosition(graphics2D, i, j, string);
                graphics2D.drawString(string, point.x, point.y);
            }
        }
    }

    private String getValueAsStringAt(int n, int n2, int n3) {
        byte by = this.view.getValueAt(n, n2);
        String string = digits[by + 10 * n3];
        return string;
    }

    private void paintFocusMark(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.drawRect(this.startPos(this.posX), this.startPos(this.posY), this.CELL_SIZE, this.CELL_SIZE);
        graphics2D.setColor(Color.GRAY);
        graphics2D.drawRect(this.startPos(this.posX) + 1, this.startPos(this.posY) + 1, this.CELL_SIZE - 2, this.CELL_SIZE - 2);
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.drawRect(this.startPos(this.posX) + 2, this.startPos(this.posY) + 2, this.CELL_SIZE - 4, this.CELL_SIZE - 4);
    }

    private void paintPlayerNumbers(Graphics2D graphics2D, int n) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = new Font("Serif", 0, this.FONT_SIZE - (n == 1 ? 4 : 0));
        graphics2D.setFont(font);
        GridModel.GridValidity gridValidity = this.view.getGridValidity();
        Integer n2 = gridValidity.getFirstErrorLine();
        Integer n3 = gridValidity.getFirstErrorColumn();
        Integer n4 = gridValidity.getFirstErrorSquareX();
        Integer n5 = gridValidity.getFirstErrorSquareY();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.view.isCellReadOnly(i, j)) continue;
                String string = this.getValueAsStringAt(i, j, n);
                Point point = this.getPosition(graphics2D, i, j, string);
                if (n2 != null && n2 == i || n3 != null && n3 == j || n4 != null && n4 <= j && j < n4 + 3 && n5 != null && n5 <= i && i < n5 + 3) {
                    graphics2D.setColor(Color.RED);
                } else if (this.view.isGrigComplete()) {
                    graphics2D.setColor(Color.DARK_GRAY);
                } else {
                    graphics2D.setColor(Color.BLUE);
                }
                graphics2D.drawString(string, point.x, point.y);
            }
        }
    }

    private void paintPlayerMemos(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.BLUE);
        Font font = new Font("Serif", 0, 9 * this.FONT_SIZE / 22);
        graphics2D.setFont(font);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                for (int k = 1; k <= 9; ++k) {
                    if (!this.view.isCellMemoSet(i, j, (byte)k)) continue;
                    Point point = this.getPositionForMemo(graphics2D, i, j, k);
                    graphics2D.drawString(String.valueOf(k), point.x, point.y);
                }
            }
        }
    }

    private int startPos(int n) {
        return 2 + n * this.CELL_SIZE + n / 3 % 3;
    }

    private int endPos(int n) {
        return 2 + (n + 1) * this.CELL_SIZE + n / 3 % 3;
    }

    private void paintGridBoard(Graphics2D graphics2D) {
        int n;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(this.startPos(0), this.startPos(0), this.endPos(8) - 1, this.endPos(8) - 1);
        graphics2D.setColor(new Color(0xEEEEEE));
        graphics2D.fillRect(this.startPos(3), this.startPos(0), this.endPos(5) - this.startPos(3), this.endPos(8));
        graphics2D.fillRect(this.startPos(0), this.startPos(3), this.endPos(8), this.endPos(5) - this.startPos(3));
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(this.startPos(3), this.startPos(3), this.endPos(5) - this.startPos(3), this.endPos(5) - this.startPos(3));
        graphics2D.setColor(Color.BLACK);
        for (n = 0; n < 9; ++n) {
            graphics2D.drawLine(this.startPos(0), this.startPos(n), this.endPos(8), this.startPos(n));
            graphics2D.drawLine(this.startPos(0), this.endPos(n), this.endPos(8), this.endPos(n));
        }
        for (n = 0; n < 9; ++n) {
            graphics2D.drawLine(this.startPos(n), this.startPos(0), this.startPos(n), this.endPos(8));
            graphics2D.drawLine(this.endPos(n), this.startPos(0), this.endPos(n), this.endPos(8));
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(this.startPos(0) - 1, this.startPos(0) - 1, this.endPos(8) - this.startPos(0) + 2, this.endPos(8) - this.startPos(0) + 2);
    }

    private Position getLiCoForPos(Point point) {
        int n;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < 9; ++n) {
            if (this.startPos(n) + 2 > point.y || point.y >= this.endPos(n) + 2) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < 9; ++n) {
            if (this.startPos(n) > point.x || point.x >= this.endPos(n)) continue;
            n3 = n;
            break;
        }
        if (n2 == -1) {
            // empty if block
        }
        if (n3 == -1) {
            // empty if block
        }
        return new Position(n2, n3);
    }

    private Point getTopLeftPoint(int n, int n2) {
        int n3 = this.startPos(n2);
        int n4 = this.startPos(n);
        return new Point(n3, n4);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = new Font("Serif", 0, 24);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.translate(0, n2);
        graphics2D.drawString("Sudokuki - essential sudoku game", 0, 0);
        graphics2D.translate(0, n2);
        font = new Font("Serif", 0, 20);
        graphics2D.setFont(font);
        n2 = graphics2D.getFontMetrics().getHeight();
        graphics2D.drawString("http://sudokuki.sourceforge.net/", 0, n2);
        graphics2D.translate(240, -40);
        ImageIcon imageIcon = Images.ICON_APPLICATION_LOGO_SMALL;
        graphics2D.drawImage(imageIcon.getImage(), 130, 0, this);
        graphics2D.translate(-160, 140);
        this.paintGridBoard(graphics2D);
        int n3 = UserPreferences.getInstance().getInteger("numbersMode", 0);
        this.paintGridNumbers(graphics2D, n3);
        this.paintPlayerNumbers(graphics2D, n3);
        return 0;
    }

    private void selectValue(int n, int n2, int n3, int n4) {
        if (this.view.isGrigComplete() || this.view.isCellReadOnly(n, n2)) {
            return;
        }
        this.pickUpValueOrMemos(true, n, n2, n3, n4);
    }

    private void selectMemos(int n, int n2, int n3, int n4) {
        if (this.view.isGrigComplete() || this.view.isCellReadOnly(n, n2)) {
            return;
        }
        this.pickUpValueOrMemos(false, n, n2, n3, n4);
    }

    private void pickUpValueOrMemos(boolean bl, int n, int n2, int n3, int n4) {
        byte[] byArray;
        byte by = this.view.getValueAt(n, n2);
        Vector<Byte> vector = new Vector<Byte>();
        for (byte by2 = 1; by2 <= 9; by2 = (byte)(by2 + 1)) {
            if (!this.view.isCellMemoSet(n, n2, by2)) continue;
            vector.add(new Byte(by2));
        }
        Byte[] byteArray = new Byte[vector.size()];
        DualSwingSelector dualSwingSelector = new DualSwingSelector(bl, this.parent, this, n3, n4, by, byteArray = vector.toArray(byteArray));
        int n5 = dualSwingSelector.retrieveNumber();
        if (n5 == by) {
            n5 = 0;
        }
        if (0 <= n5 && n5 <= 9) {
            this.view.getController().notifyGridValueChanged(n, n2, n5, false);
        }
        if ((byArray = dualSwingSelector.retrieveMemos()) != null) {
            this.view.getController().notifyGridMemosChanged(n, n2, byArray);
        }
    }

    private class InnerKeyListener
    extends KeyAdapter {
        private InnerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            boolean bl = false;
            if (n == 225 || n == 40 || n == 74) {
                if (SwingGrid.this.posY < 8) {
                    SwingGrid.this.posY++;
                    bl = true;
                    SwingGrid.this.repaint();
                }
            } else if (n == 224 || n == 38 || n == 75) {
                if (SwingGrid.this.posY > 0) {
                    SwingGrid.this.posY--;
                    bl = true;
                    SwingGrid.this.repaint();
                }
            } else if (n == 226 || n == 37 || n == 72) {
                if (SwingGrid.this.posX > 0) {
                    SwingGrid.this.posX--;
                    bl = true;
                    SwingGrid.this.repaint();
                }
            } else if ((n == 227 || n == 39 || n == 76) && SwingGrid.this.posX < 8) {
                SwingGrid.this.posX++;
                bl = true;
                SwingGrid.this.repaint();
            }
            if (bl) {
                SwingGrid.this.view.getController().notifyFocusPositionChanged(SwingGrid.this.posY, SwingGrid.this.posX);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 32) {
                Point point = SwingGrid.this.getTopLeftPoint(SwingGrid.this.posY, SwingGrid.this.posX);
                SwingGrid.this.selectValue(SwingGrid.this.posY, SwingGrid.this.posX, point.x, point.y);
            } else if (n == 16) {
                Point point = SwingGrid.this.getTopLeftPoint(SwingGrid.this.posY, SwingGrid.this.posX);
                SwingGrid.this.selectMemos(SwingGrid.this.posY, SwingGrid.this.posX, point.x, point.y);
            }
        }
    }

    private class InnerMouseListener
    extends MouseAdapter {
        private InnerMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            switch (mouseEvent.getButton()) {
                case 1: {
                    this.pressedLeft(mouseEvent);
                    return;
                }
                case 3: {
                    this.pressedRight(mouseEvent);
                    return;
                }
            }
        }

        private void pressedLeft(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Position position = SwingGrid.this.getLiCoForPos(point);
            int n = position.getLi();
            int n2 = position.getCo();
            if (n == -1 || n2 == -1) {
                return;
            }
            SwingGrid.this.posY = n;
            SwingGrid.this.posX = n2;
            SwingGrid.this.repaint();
            SwingGrid.this.selectValue(n, n2, point.x, point.y);
            SwingGrid.this.view.getController().notifyFocusPositionChanged(n, n2);
        }

        private void pressedRight(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Position position = SwingGrid.this.getLiCoForPos(point);
            int n = position.getLi();
            int n2 = position.getCo();
            if (n == -1 || n2 == -1) {
                return;
            }
            SwingGrid.this.posY = n;
            SwingGrid.this.posX = n2;
            SwingGrid.this.repaint();
            SwingGrid.this.selectMemos(n, n2, point.x, point.y);
            SwingGrid.this.view.getController().notifyFocusPositionChanged(n, n2);
        }
    }
}

