/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.solver;

import net.jankenpoi.sudokuki.model.GridModel;
import net.jankenpoi.sudokuki.solver.GridShadow;
import net.jankenpoi.sudokuki.solver.GridSolution;
import net.jankenpoi.sudokuki.solver.GridSolver;

public class BruteForceGridSolver
implements GridSolver {
    private static final int MAX_ITER_NB = 20000;
    private final GridModel originalGrid;
    private final int[] cellShadowMemory = new int[6561];
    private int currentIndex = 0;
    private Boolean cancelled = Boolean.FALSE;

    public BruteForceGridSolver(GridModel gridModel) {
        this.originalGrid = gridModel;
        int[] nArray = gridModel.cloneCellInfosAsInts();
        System.arraycopy(nArray, 0, this.cellShadowMemory, 0, nArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelRequested() {
        Boolean bl = this.cancelled;
        synchronized (bl) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Boolean bl = this.cancelled;
        synchronized (bl) {
            this.cancelled = Boolean.TRUE;
        }
    }

    @Override
    public GridSolution resolve() {
        GridShadow gridShadow = new GridShadow(this.cellShadowMemory, this.currentIndex, true);
        gridShadow.debugDump();
        boolean bl = false;
        for (int i = 1; !bl && i < 20000; ++i) {
            int n;
            if (this.cancelRequested()) {
                return null;
            }
            int[] nArray = gridShadow.popFirstCellWithMinPossValues();
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (n2 == 10 && n3 == 10) {
                short[] sArray = new short[81];
                for (n = 0; n < 81; ++n) {
                    sArray[n] = (short)this.cellShadowMemory[this.currentIndex + n];
                }
                GridModel gridModel = new GridModel(sArray, 0);
                GridSolution gridSolution = new GridSolution(true, gridModel);
                return gridSolution;
            }
            if (n2 == 11 && n3 == 11) {
                bl = this.backToPreviousPosition();
                if (bl) break;
                gridShadow = new GridShadow(this.cellShadowMemory, this.currentIndex, false);
                gridShadow.debugDump();
                continue;
            }
            byte by = gridShadow.popFirstValueForCell(n2, n3);
            this.copyCurrentFlagsToNextPosition();
            gridShadow = new GridShadow(this.cellShadowMemory, this.currentIndex, false);
            gridShadow.debugDump();
            gridShadow.setCellValueScreened(n2, n3, by);
            this.forwardToNextPosition();
            gridShadow = new GridShadow(this.cellShadowMemory, this.currentIndex, false);
            gridShadow.debugDump();
            n = gridShadow.setCellValueAt(n2, n3, by) ? 1 : 0;
            if (n == 0) continue;
            bl = this.backToPreviousPosition();
            gridShadow = new GridShadow(this.cellShadowMemory, this.currentIndex, false);
            gridShadow.debugDump();
        }
        GridSolution gridSolution = new GridSolution(false, this.originalGrid);
        return gridSolution;
    }

    void copyCurrentFlagsToNextPosition() {
        if (this.currentIndex + 81 >= this.cellShadowMemory.length) {
            throw new IllegalStateException("Already reached the end of the solver memory");
        }
        System.arraycopy(this.cellShadowMemory, this.currentIndex, this.cellShadowMemory, this.currentIndex + 81, 81);
    }

    void forwardToNextPosition() {
        this.currentIndex += 81;
    }

    boolean backToPreviousPosition() {
        this.currentIndex -= 81;
        return this.currentIndex < 0;
    }

    int[] getCellShadowMemory() {
        return this.cellShadowMemory;
    }

    int getCurrentIndex() {
        return this.currentIndex;
    }
}

