/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.resources.UIResources;
import net.jankenpoi.sudokuki.ui.swing.Images;

public class AboutDialog
extends JDialog {
    private Frame parent;
    private final String ABOUT_SUDOKUKI = I18n._("About Sudokuki...");
    private final String INFORMATION = I18n._("Information");
    private final String CONTRIBUTORS = I18n._("Contributors");
    private final String TRANSFER = I18n._("Transfer");
    private final String LICENSE = I18n._("License");

    public AboutDialog(Frame frame) {
        super(frame, true);
        this.parent = frame;
        this.initComponents();
        this.setTitle(this.ABOUT_SUDOKUKI);
        this.pack();
    }

    private void initComponents() {
        URI uRI = null;
        try {
            uRI = new URI("http://sudokuki.sourceforge.net");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(this.INFORMATION, null, this.makeInfoPanel(uRI), this.INFORMATION);
        jTabbedPane.addTab(this.CONTRIBUTORS, null, this.makeTextPanel("<html><body><table border=\"0\"><tr></tr><tr><td align=\"right\"><b>" + I18n._("Sathish Anandh") + "</b></td><td></td><td align=\"left\">" + I18n._("Tamil translations") + "<tr><td align=\"right\"><b>" + I18n._("Aritz Beraza") + "</b></td><td></td><td align=\"left\">" + I18n._("Spanish translations (v1.0)") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Jeroen P. Broks") + "</b></td><td></td><td align=\"left\">" + I18n._("Dutch translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Helene Damianakos") + "</b></td><td></td><td align=\"left\">" + I18n._("Greek translations (v1.0)") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Janis Eisaks") + "</b></td><td></td><td align=\"left\">" + I18n._("Latvian translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Rafael Ferreira") + "</b></td><td></td><td align=\"left\">" + I18n._("Brazilian Portuguese translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Daneih Ismail") + "</b></td><td></td><td align=\"left\">" + I18n._("Arabic translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Stavros Mavrakis") + "</b></td><td></td><td align=\"left\">" + I18n._("Greek translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Fumiaki Nakanishi") + "</b></td><td></td><td align=\"left\">" + I18n._("Japanese translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Ahmet Kemal Okmen") + "</b></td><td></td><td align=\"left\">" + I18n._("Turkish translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Jeanne Peng") + "</b></td><td></td><td align=\"left\">" + I18n._("Chinese translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Claus Poerschke") + "</b></td><td></td><td align=\"left\">" + I18n._("Patches (v1.0) and German translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Dmitry Salnikov") + "</b></td><td></td><td align=\"left\">" + I18n._("Portuguese and Russian translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Toni") + "</b></td><td></td><td align=\"left\">" + I18n._("Hungarian translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Helene Vedrenne") + "</b></td><td></td><td align=\"left\">" + I18n._("Japanese translations") + "</td></tr><tr><td align=\"right\"><b>" + I18n._("Sylvain Vedrenne") + "</b></td><td></td><td align=\"left\">" + I18n._("Esperanto, French, and Japanese translations (v1.0)") + "</td>" + "</tr>" + "</table>" + "</body></html>"), this.CONTRIBUTORS);
        jTabbedPane.addTab(this.TRANSFER, null, this.makeTextPanel("<html><body><p>" + I18n._("<b>Sudokuki</b> is released under the terms of the GNU General Public License version 3 or later (GPL v3+).") + "<br/>" + "</p>" + "<p>" + I18n._("The full license text is available in the file called COPYING that must be included in every copy of the program.") + "<br/>" + "</p>" + "<p>" + I18n._("This program is Free Software (\"Free\" as in \"Freedom\") developped during the author's free-time in the hope that some users will find it useful, but WITHOUT ANY WARRANTY of any kind.") + "<br/>" + "</p>" + "<p>" + I18n._("You are welcome to transfer this program to other people as long as you respect the license terms. Read the GNU General Public License for more details.") + "<br/>" + "</p>" + "<p>" + I18n._("Copyright (C) 2007-2013 Sylvain Vedrenne") + "<br/>" + "</p>" + "</body></html>"), this.TRANSFER);
        String string = "<html> <table border=\"0\"> <tr> <td>Please visit:</td> </tr><tr> <td>http://www.gnu.org/licenses/gpl.html</td> </tr>";
        try {
            string = AboutDialog.readTextFile("text/COPYING.html");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JEditorPane jEditorPane = new JEditorPane("text/html", string);
        jEditorPane.setEditable(false);
        Serializable serializable = new JPanel().getBackground();
        jEditorPane.setBackground(new Color(serializable.getRed(), serializable.getGreen(), serializable.getBlue()));
        jEditorPane.setCaretPosition(0);
        serializable = new JScrollPane(jEditorPane);
        jTabbedPane.addTab(this.LICENSE, null, (Component)serializable, this.LICENSE);
        Dimension dimension = this.parent.getPreferredSize();
        Dimension dimension2 = new Dimension();
        double d = dimension.getHeight() * 1.2;
        double d2 = dimension.getWidth() * 1.3;
        dimension2.setSize(d, d2);
        jTabbedPane.setPreferredSize(dimension2);
        this.add(jTabbedPane);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    protected JComponent makeTextPanel(String string) {
        JEditorPane jEditorPane = new JEditorPane("text/html", string);
        Serializable serializable = new JPanel().getBackground();
        jEditorPane.setBackground(new Color(serializable.getRed(), serializable.getGreen(), serializable.getBlue()));
        jEditorPane.setEditable(false);
        jEditorPane.setCaretPosition(0);
        serializable = new JScrollPane(jEditorPane);
        return serializable;
    }

    protected JComponent makeInfoPanel(final URI uRI) {
        JPanel jPanel = new JPanel();
        JEditorPane jEditorPane = new JEditorPane("text/html", "<html><table border=\"0\"><tr><td align=\"center\"><b>Sudokuki 1.2.2</b></td></tr><tr><td align=\"center\">" + I18n._("Copyright (C) 2007-2013 Sylvain Vedrenne") + "</td>" + "</tr>" + "</table>" + "</html>");
        Serializable serializable = new JPanel().getBackground();
        jEditorPane.setBackground(new Color(((Color)serializable).getRed(), ((Color)serializable).getGreen(), ((Color)serializable).getBlue()));
        jEditorPane.setEditable(false);
        jEditorPane.setCaretPosition(0);
        serializable = new JPanel(false);
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
        JPanel jPanel2 = new JPanel(false);
        ImageIcon imageIcon = Images.ICON_APPLICATION_LOGO;
        JLabel jLabel = new JLabel(imageIcon);
        jPanel2.add(jLabel);
        ((Container)serializable).add(jPanel2);
        jPanel.add(jEditorPane);
        ((Container)serializable).add(jPanel);
        JPanel jPanel3 = new JPanel(false);
        JButton jButton = new JButton();
        jButton.setText("<HTML><FONT color=\"#000099\"><U>Sudokuki " + I18n._("on the Web") + "</U></FONT></HTML>");
        jButton.setHorizontalAlignment(0);
        jButton.setBorderPainted(false);
        jButton.setOpaque(false);
        jButton.setToolTipText(uRI.toString());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.open(uRI);
            }
        });
        jButton.setCursor(new Cursor(12));
        jPanel3.add(jButton);
        ((Container)serializable).add(jPanel3);
        JScrollPane jScrollPane = new JScrollPane((Component)serializable);
        return jScrollPane;
    }

    protected JComponent makeFeedbackPanel(final URI uRI) {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String string = "<html><body><p></p><p>" + I18n._("Feel free to request features and report bugs<br/>on the Sudokuki Forums hosted by Sourceforge!") + "</p></body>" + "</html>";
        JEditorPane jEditorPane = new JEditorPane("text/html", string);
        jEditorPane.setEditable(false);
        jEditorPane.setCaretPosition(0);
        Color color = jPanel.getBackground();
        jEditorPane.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        JPanel jPanel2 = new JPanel(false);
        jPanel2.add(jEditorPane);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(false);
        JButton jButton = new JButton();
        jButton.setText("<HTML><FONT color=\"#000099\"><U>" + I18n._("Sudokuki Forums") + "</U></FONT></HTML>");
        jButton.setHorizontalAlignment(0);
        jButton.setBorderPainted(false);
        jButton.setOpaque(false);
        jButton.setToolTipText(uRI.toString());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.open(uRI);
            }
        });
        jButton.setCursor(new Cursor(12));
        jPanel3.add(jButton);
        jPanel.add(jPanel3);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        return jScrollPane;
    }

    private void open(URI uRI) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uRI);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("Desktop.isDesktopSupported() returned false");
        }
    }

    private static String readTextFile(String string) throws IOException {
        String string2;
        InputStream inputStream = UIResources.class.getResourceAsStream(string);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2 + "\n");
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
        return stringBuffer.toString();
    }
}

