/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.LocaleToCharsetMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class LocaleNegotiator {
    private ResourceBundle chosenBundle;
    private Locale chosenLocale;
    private String chosenCharset;

    public LocaleNegotiator(String string, String string2, String string3) {
        Locale locale = new Locale("en", "US");
        String string4 = "ISO-8859-1";
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == null) {
            this.chosenLocale = locale;
            this.chosenCharset = string4;
            this.chosenBundle = resourceBundle;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            Locale locale2 = this.getLocaleForLanguage(string6);
            ResourceBundle resourceBundle2 = this.getBundleNoFallback(string, locale2);
            if (resourceBundle2 == null || (string5 = this.getCharsetForLocale(locale2, string3)) == null) continue;
            this.chosenLocale = locale2;
            this.chosenBundle = resourceBundle2;
            this.chosenCharset = string5;
            return;
        }
        this.chosenLocale = locale;
        this.chosenCharset = string4;
        this.chosenBundle = resourceBundle;
    }

    public ResourceBundle getBundle() {
        return this.chosenBundle;
    }

    public Locale getLocale() {
        return this.chosenLocale;
    }

    public String getCharset() {
        return this.chosenCharset;
    }

    private Locale getLocaleForLanguage(String string) {
        int n;
        int n2 = string.indexOf(59);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        Locale locale = (n = (string = string.trim()).indexOf(45)) == -1 ? new Locale(string, "") : new Locale(string.substring(0, n), string.substring(n + 1));
        return locale;
    }

    private ResourceBundle getBundleNoFallback(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, new Locale("bogus", ""));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(string, locale);
            if (resourceBundle2 != resourceBundle) {
                return resourceBundle2;
            }
            if (resourceBundle2 == resourceBundle && locale.getLanguage().equals(Locale.getDefault().getLanguage())) {
                return resourceBundle2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    protected String getCharsetForLocale(Locale locale, String string) {
        return LocaleToCharsetMap.getCharset(locale);
    }
}

