/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DiffException;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.ArchiveParser;
import org.apache.commons.jrcs.rcs.BranchNode;
import org.apache.commons.jrcs.rcs.HeadAlreadySetException;
import org.apache.commons.jrcs.rcs.InvalidBranchVersionNumberException;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.InvalidTrunkVersionNumberException;
import org.apache.commons.jrcs.rcs.InvalidVersionNumberException;
import org.apache.commons.jrcs.rcs.KeywordsFormat;
import org.apache.commons.jrcs.rcs.Lines;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.ParseException;
import org.apache.commons.jrcs.rcs.Path;
import org.apache.commons.jrcs.rcs.Phrases;
import org.apache.commons.jrcs.rcs.TrunkNode;
import org.apache.commons.jrcs.rcs.Version;
import org.apache.commons.jrcs.util.ToString;

public class Archive
extends ToString {
    public static final String RCS_NEWLINE = "\n";
    protected TrunkNode head;
    protected Version branch;
    protected Map nodes;
    protected Set users;
    protected Set locked;
    protected Map symbols;
    protected Phrases phrases;
    protected String desc;
    protected boolean strictLocking;
    protected String expand;
    protected String comment;
    protected String filename;
    private static final KeywordsFormat FORMATTER = new KeywordsFormat();

    public Archive(Object[] text, String desc) {
        this(text, desc, new Version(1, 1));
    }

    public Archive(Object[] text, String desc, String vernum) {
        this(text, desc, new Version(vernum));
    }

    /*
     * Unable to fully structure code
     */
    public Archive(Object[] text, String desc, Version vernum) {
        super();
        this.nodes = new TreeMap<K, V>();
        this.users = new TreeSet<E>();
        this.locked = new TreeSet<E>();
        this.symbols = new TreeMap<K, V>();
        this.phrases = new Phrases();
        this.desc = new String();
        this.strictLocking = true;
        this.comment = "# ";
        this.filename = "__unknown__,v";
        if (vernum.size() <= 2) ** GOTO lbl14
        throw new InvalidVersionNumberException(vernum + " must be a trunk version");
lbl-1000:
        // 1 sources

        {
            vernum = vernum.newBranch(1);
lbl14:
            // 2 sources

            ** while (vernum.size() < 2)
        }
lbl15:
        // 1 sources

        this.head = (TrunkNode)this.newNode(vernum, null);
        this.head.setText(text);
        this.head.setLog(desc);
    }

    public Archive(String fname, InputStream input) throws ParseException {
        this.nodes = new TreeMap();
        this.users = new TreeSet();
        this.locked = new TreeSet();
        this.symbols = new TreeMap();
        this.phrases = new Phrases();
        this.desc = new String();
        this.strictLocking = true;
        this.comment = "# ";
        this.filename = "__unknown__,v";
        this.filename = fname;
        ArchiveParser.load(this, input);
    }

    public Archive(String path) throws ParseException, FileNotFoundException {
        this.nodes = new TreeMap();
        this.users = new TreeSet();
        this.locked = new TreeSet();
        this.symbols = new TreeMap();
        this.phrases = new Phrases();
        this.desc = new String();
        this.strictLocking = true;
        this.comment = "# ";
        this.filename = "__unknown__,v";
        this.filename = new File(path).getPath();
        ArchiveParser.load(this, this.filename);
    }

    Archive() {
        this.nodes = new TreeMap();
        this.users = new TreeSet();
        this.locked = new TreeSet();
        this.symbols = new TreeMap();
        this.phrases = new Phrases();
        this.desc = new String();
        this.strictLocking = true;
        this.comment = "# ";
        this.filename = "__unknown__,v";
    }

    public void setFileName(String path) {
        this.filename = path;
    }

    public void save(OutputStream output) throws IOException {
        output.write(this.toByteArray());
    }

    public void save(String path) throws IOException {
        FileOutputStream output = new FileOutputStream(path);
        try {
            this.save(output);
            this.filename = new File(path).getPath();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ((OutputStream)output).close();
            throw throwable;
        }
        Object var3_5 = null;
        ((OutputStream)output).close();
    }

    protected void setHead(Version vernum) throws InvalidVersionNumberException {
        if (this.head != null) {
            throw new HeadAlreadySetException(this.head.getVersion());
        }
        this.head = new TrunkNode(vernum, null);
        this.nodes.put(vernum, this.head);
    }

    public void setBranch(String v) throws InvalidBranchVersionNumberException {
        this.setBranch(new Version(v));
    }

    public void setBranch(Version vernum) throws InvalidBranchVersionNumberException {
        if (!vernum.isBranch()) {
            throw new InvalidBranchVersionNumberException(vernum);
        }
        if (this.head == null || vernum.getBase(2).isGreaterThan(this.head.getVersion())) {
            throw new InvalidBranchVersionNumberException(vernum + "is greater than _head version " + this.head.getVersion());
        }
        this.branch = vernum;
    }

    public void addUser(String name) {
        this.users.add(name);
    }

    public void addSymbol(String sym, Version vernum) throws InvalidVersionNumberException {
        this.symbols.put(sym, vernum);
    }

    public Map getSymbols() {
        return this.symbols;
    }

    public void addLock(String user, Version vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        this.addUser(user);
        Node node = this.newNode(vernum);
        node.setLocker(user);
        if (user == null) {
            this.locked.remove(node);
        } else {
            this.locked.add(node);
        }
    }

    public void setStrictLocking(boolean value) {
        this.strictLocking = value;
    }

    public void setExpand(String value) {
        this.expand = value;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public void setDesc(String value) {
        this.desc = value;
    }

    public void addPhrase(String key, Collection values) {
        this.phrases.put(key, values);
    }

    protected Node newNode(Version vernum) {
        return this.newNode(vernum, null);
    }

    protected Node newNode(Version vernum, Node prev) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!vernum.isRevision()) {
            throw new InvalidVersionNumberException(vernum);
        }
        Node node = (Node)this.nodes.get(vernum);
        if (node == null) {
            node = Node.newNode(vernum, prev);
            this.nodes.put(vernum, node);
        }
        return node;
    }

    protected TrunkNode newTrunkNode(Version vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!vernum.isTrunk()) {
            throw new InvalidTrunkVersionNumberException(vernum);
        }
        return (TrunkNode)this.newNode(vernum);
    }

    protected BranchNode newBranchNode(Version vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!vernum.isBranch()) {
            throw new InvalidBranchVersionNumberException(vernum);
        }
        return (BranchNode)this.newNode(vernum);
    }

    protected Node getNode(Version vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!vernum.isRevision()) {
            throw new InvalidVersionNumberException(vernum);
        }
        Node node = (Node)this.nodes.get(vernum);
        if (node == null) {
            throw new NodeNotFoundException(vernum);
        }
        return node;
    }

    public Node findNode(Version vernum) {
        Path path = this.getRevisionPath(vernum);
        return path == null ? null : path.last();
    }

    public void toString(StringBuffer s) {
        this.toString(s, RCS_NEWLINE);
    }

    public String toString(String EOL) {
        StringBuffer s = new StringBuffer();
        this.toString(s, EOL);
        return s.toString();
    }

    public char[] toCharArray() {
        return this.toString(RCS_NEWLINE).toCharArray();
    }

    public byte[] toByteArray() {
        return this.toString(RCS_NEWLINE).getBytes();
    }

    protected Path getRevisionPath(Version vernum) {
        if (this.head == null) {
            return null;
        }
        try {
            Path path = this.head.pathTo(vernum, true);
            Node revisionFound = path.last();
            if (revisionFound == null) {
                return null;
            }
            if (revisionFound.getVersion().isLessThan(vernum)) {
                return null;
            }
            return path;
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    public Version getRevisionVersion(Version vernum) {
        Path path = this.getRevisionPath(vernum);
        return path == null ? null : path.last().getVersion();
    }

    public Version getRevisionVersion(String vernum) {
        return this.getRevisionVersion(new Version(vernum));
    }

    public Version getRevisionVersion() {
        if (this.branch != null) {
            return this.getRevisionVersion(this.branch);
        }
        if (this.head != null) {
            return this.head.getVersion();
        }
        return null;
    }

    public void toString(StringBuffer s, String EOL) {
        String EOI = ";" + EOL;
        String NLT = String.valueOf(EOL) + "\t";
        s.append("head");
        if (this.head != null) {
            s.append("\t");
            this.head.getVersion().toString(s);
        }
        s.append(EOI);
        if (this.branch != null) {
            s.append("branch\t");
            s.append(this.branch.toString());
            s.append(EOI);
        }
        s.append("access");
        Iterator<Object> i = this.users.iterator();
        while (i.hasNext()) {
            s.append(EOL);
            s.append("\t");
            s.append(i.next());
        }
        s.append(EOI);
        s.append("symbols");
        i = this.symbols.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            s.append(NLT);
            s.append(e.getKey().toString());
            s.append(":");
            s.append(e.getValue().toString());
        }
        s.append(EOI);
        s.append("locks");
        i = this.locked.iterator();
        while (i.hasNext()) {
            String locker = ((Node)i.next()).getLocker();
            s.append(NLT);
            s.append(locker);
        }
        if (this.strictLocking) {
            s.append("; strict");
        }
        s.append(EOI);
        if (this.comment != null) {
            s.append("comment\t");
            s.append(Archive.quoteString(this.comment));
            s.append(EOI);
        }
        if (this.expand != null) {
            s.append("expand\t");
            s.append(Archive.quoteString(this.expand));
            s.append(EOI);
        }
        if (this.phrases != null) {
            this.phrases.toString(s, EOL);
        }
        s.append(EOL);
        i = this.nodes.values().iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n.getVersion().isGhost() || n.getText() == null) continue;
            n.toString(s, EOL);
        }
        s.append(String.valueOf(EOL) + EOL);
        s.append("desc");
        s.append(EOL);
        s.append(Archive.quoteString(this.desc));
        s.append(EOL);
        Node n = this.head;
        while (n != null) {
            n.toText(s, EOL);
            n = n.getRCSNext();
        }
    }

    public static String quoteString(String s) {
        StringBuffer result = new StringBuffer(s);
        int i = 0;
        while (i < s.length()) {
            if (result.charAt(i) == '@') {
                result.insert(i++, '@');
            }
            ++i;
        }
        result.insert(0, '@');
        result.append('@');
        return new String(result);
    }

    public static String unquoteString(String s) {
        return Archive.unquoteString(s, true);
    }

    public static String unquoteString(String s, boolean removeExtremes) {
        StringBuffer result = new StringBuffer();
        int start = 0;
        int end = s.length();
        if (removeExtremes) {
            ++start;
            --end;
        }
        int i = start;
        while (i < end) {
            char c = s.charAt(i);
            result.append(c);
            if (c == '@') {
                ++i;
            }
            ++i;
        }
        return new String(result);
    }

    public Object[] getRevision() throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.getRevision(false);
    }

    public Object[] getRevision(boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        if (this.branch != null) {
            return this.getRevision(this.branch);
        }
        if (this.head != null) {
            return this.getRevision(this.head.getVersion());
        }
        throw new IllegalStateException("no head node");
    }

    public Object[] getRevision(String vernum) throws InvalidFileFormatException, PatchFailedException, InvalidVersionNumberException, NodeNotFoundException {
        return this.getRevision(vernum, false);
    }

    public Object[] getRevision(String vernum, boolean annotate) throws InvalidVersionNumberException, NodeNotFoundException, InvalidFileFormatException, PatchFailedException {
        return this.getRevision(new Version(vernum), annotate);
    }

    public Object[] getRevision(Version vernum) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.getRevision(vernum, false);
    }

    public Object[] getRevision(Version vernum, boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        Path path = this.getRevisionPath(vernum);
        if (path == null) {
            throw new NodeNotFoundException(vernum);
        }
        Lines lines = new Lines();
        Node revisionFound = path.last();
        path.patch(lines, annotate);
        return this.doKeywords(lines.toArray(), revisionFound);
    }

    public Version addRevision(Object[] text, String log) throws InvalidFileFormatException, DiffException, InvalidVersionNumberException, NodeNotFoundException {
        if (this.branch != null) {
            return this.addRevision(text, this.branch, log);
        }
        return this.addRevision(text, this.head.getVersion().next(), log);
    }

    public Version addRevision(Object[] text, String vernum, String log) throws InvalidFileFormatException, DiffException, InvalidVersionNumberException, NodeNotFoundException {
        return this.addRevision(text, new Version(vernum), log);
    }

    public Version addRevision(Object[] text, Version vernum, String log) throws InvalidFileFormatException, DiffException, NodeNotFoundException, InvalidVersionNumberException {
        String deltaText;
        if (this.head == null) {
            throw new IllegalStateException("no head node");
        }
        Path path = this.head.pathTo(vernum, true);
        Node target = path.last();
        if (vernum.size() < target.getVersion().size()) {
            vernum = target.nextVersion();
        } else {
            if (!vernum.isGreaterThan(target.getVersion())) {
                throw new InvalidVersionNumberException(vernum + " revision must be higher than " + target.getVersion());
            }
            if (vernum.odd()) {
                vernum = vernum.last() == 0 ? target.newBranchVersion() : vernum.newBranch(1);
            } else if (vernum.last() == 0) {
                vernum = vernum.next();
            }
        }
        boolean headAdd = target == this.head && !vernum.isBranch();
        text = Archive.removeKeywords(text);
        if (headAdd) {
            deltaText = Diff.diff(text, this.head.getText()).toRCSString(RCS_NEWLINE);
        } else {
            Object[] oldText = path.patch().toArray();
            deltaText = Diff.diff(oldText, text).toRCSString(RCS_NEWLINE);
        }
        if (deltaText.length() == 0) {
            return null;
        }
        Node newNode = null;
        if (headAdd) {
            newNode = this.newNode(vernum, this.head);
            newNode.setText(text);
            this.head.setText(deltaText);
            this.head = (TrunkNode)newNode;
        } else {
            newNode = this.newNode(vernum);
            newNode.setText(deltaText);
            if (vernum.size() > target.getVersion().size()) {
                target.addBranch((BranchNode)newNode);
            } else {
                target.setRCSNext(newNode);
            }
        }
        newNode.setLog(log);
        return newNode.getVersion();
    }

    public Object[] doKeywords(Object[] text, Node rev) throws PatchFailedException {
        Object[] revisionInfo = new Object[]{this.filename, new File(this.filename).getName(), rev.getVersion().toString(), rev.getDate(), rev.getAuthor(), rev.getState(), rev.getLocker()};
        Object[] result = new Object[text.length];
        int i = 0;
        while (i < text.length) {
            result[i] = FORMATTER.update(text[i].toString(), revisionInfo);
            ++i;
        }
        return result;
    }

    protected static Object[] removeKeywords(Object[] text) throws PatchFailedException {
        Object[] result = new Object[text.length];
        int i = 0;
        while (i < text.length) {
            result[i] = FORMATTER.reset(text[i].toString());
            ++i;
        }
        return result;
    }

    public Node[] changeLog() {
        return this.changeLog(this.head.version);
    }

    public Node[] changeLog(Version latest) {
        return this.changeLog(latest, this.head.root().version);
    }

    public Node[] changeLog(Version latest, Version earliest) {
        Node last = this.findNode(latest);
        if (last == null) {
            throw new NodeNotFoundException(latest.toString());
        }
        Node first = this.findNode(earliest);
        if (first == null) {
            throw new NodeNotFoundException(earliest.toString());
        }
        LinkedList<Node> result = new LinkedList<Node>();
        Node node = last;
        while (node != null) {
            result.add(0, node);
            if (node == first) break;
            node = node.parent;
        }
        if (node == null) {
            throw new NodeNotFoundException(earliest.toString());
        }
        return result.toArray(new Node[result.size()]);
    }

    public String getDesc() {
        return this.desc;
    }

    public String getLog(Version version) throws NodeNotFoundException {
        Node node = this.findNode(version);
        if (node == null) {
            throw new NodeNotFoundException("There's no version " + version);
        }
        return node.getLog();
    }

    public String getLog(String vernum) throws InvalidVersionNumberException, NodeNotFoundException {
        return this.getLog(new Version(vernum));
    }
}

