/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.Lines;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.TrunkNode;

class Path {
    private List path = new LinkedList();

    public void add(Node node) {
        this.path.add(node);
    }

    public int size() {
        return this.path.size();
    }

    public Node last() {
        if (this.size() == 0) {
            return null;
        }
        return (Node)this.path.get(this.size() - 1);
    }

    public List patch() throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(false);
    }

    public List patch(boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(new Lines(), annotate);
    }

    public List patch(List lines) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(lines, false);
    }

    public List patch(List lines, boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        Iterator p = this.path.iterator();
        TrunkNode head = (TrunkNode)p.next();
        head.patch0(lines, annotate);
        while (p.hasNext()) {
            Node n = (Node)p.next();
            n.patch(lines, annotate);
        }
        return lines;
    }
}

