/*
 * Decompiled with CFR 0.152.
 */
package com.wam_soft.wiki;

import com.wam_soft.wiki.PluginSupport;
import com.wam_soft.wiki.WikiEngine;
import com.wam_soft.wiki.WikiServlet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class Article
extends PluginSupport {
    int article_COLS = 70;
    int article_ROWS = 5;
    int NAME_COLS = 24;
    int SUBJECT_COLS = 60;
    String name_format = "[[$name]]";
    String subject_format = "**$subject";
    String no_subject = "\u7121\u984c";
    int ARTICLE_INS = 0;
    boolean ARTICLE_COMMENT = true;
    boolean ARTICLE_AUTO_BR = true;

    Article() {
    }

    public String convert(WikiEngine we, String[] args) {
        Integer articleNo = (Integer)we.request.getAttribute("wiki.articleNo");
        if (articleNo == null) {
            articleNo = new Integer(0);
        }
        String button = "";
        if (this.empty(we.page)) {
            we.page = we.defaultpage;
        }
        if (this.argCheck("read", we) || !this.available("cmd", we) || this.argCheck("unfreeze", we) || this.argCheck("freeze", we) || this.available("write", we) || this.available("article", we)) {
            button = "<input type=\"submit\" name=\"article\" value=\"" + we._("btn_article") + "\" />\n";
        }
        String digest = WikiServlet.getDigest(we.page, we);
        String text = "<form action=\"" + we.script + "?#article" + articleNo + "\" method=\"post\">\n" + "<div><a name=\"article" + articleNo + "\">\n" + "<input type=\"hidden\" name=\"article_no\" value=\"" + articleNo + "\" />\n" + "<input type=\"hidden\" name=\"refer\" value=\"" + this.htmlspecialchars(we.page) + "\" />\n" + "<input type=\"hidden\" name=\"plugin\" value=\"article\" />\n" + "<input type=\"hidden\" name=\"digest\" value=\"" + this.htmlspecialchars(digest) + "\" />\n" + we._("btn_name") + "<input type=\"text\" name=\"name\" size=\"" + this.NAME_COLS + "\" /><br />\n" + we._("btn_subject") + "<input type=\"text\" name=\"subject\" size=\"" + this.SUBJECT_COLS + "\" /><br />\n" + "<textarea name=\"msg\" rows=\"" + this.article_ROWS + "\" cols=\"" + this.article_COLS + "\">\n</textarea><br />\n" + button + "</div></a>\n</form>";
        we.request.setAttribute("wiki.articleNo", (Object)new Integer(articleNo + 1));
        return text;
    }

    public Map action(WikiEngine we) {
        boolean conflict;
        String msg = we.request.getParameter("msg");
        if (this.empty(msg)) {
            return super.action(we);
        }
        msg = we.normalize(msg);
        String refer = we.request.getParameter("refer");
        int particle_no = Integer.parseInt(we.request.getParameter("article_no"));
        String[] postdata_old = we.getSource(refer);
        int article_no = 0;
        String name = "";
        String subject = "";
        if (this.available("name", we)) {
            name = this.strReplace("$name", we.request.getParameter("name"), this.name_format);
        }
        subject = this.available("subject", we) ? this.strReplace("$subject", we.request.getParameter("subject"), this.subject_format) : this.strReplace("$subject", this.no_subject, this.subject_format);
        String article = String.valueOf(subject) + "\n>" + name + "(" + we.now + ")\n> ~\n>";
        if (this.ARTICLE_AUTO_BR) {
            String article_body = we.preg.substitute("s/\n/ ~\n>/g", msg);
            article_body = we.preg.substitute("s/\n\n/\n/g", article_body);
            article = String.valueOf(article) + article_body + " ~";
        } else {
            article = String.valueOf(article) + ">" + msg;
        }
        if (this.ARTICLE_COMMENT) {
            article = String.valueOf(article) + "\n\n#comment\n";
        }
        StringBuffer postdata = new StringBuffer();
        int i = 0;
        while (i < postdata_old.length) {
            String line = postdata_old[i];
            if (this.ARTICLE_INS == 0) {
                postdata.append(line).append('\n');
            }
            if (we.preg.match("/^#article$/", line) && article_no++ == particle_no) {
                postdata.append(article).append('\n');
            } else if (this.ARTICLE_INS == 1) {
                postdata.append(line).append('\n');
            }
            ++i;
        }
        String postdata_input = article;
        String digest = we.request.getParameter("digest");
        try {
            conflict = we.writeText(refer, new String(postdata), digest, false);
        }
        catch (IOException e) {
            PluginSupport.log.warn((Object)e);
            throw new RuntimeException(e.getMessage());
        }
        if (conflict) {
            PluginSupport.log.debug((Object)"!!!conflict!!!");
            HashMap<String, String> p = new HashMap<String, String>();
            String body = String.valueOf(we._("msg_collided")) + "\n<form action=\"" + we.script + "?cmd=preview\" method=\"post\">\n" + "<div>\n" + "<input type=\"hidden\" name=\"refer\" value=\"" + refer + "\" />\n" + "<input type=\"hidden\" name=\"digest\" value=\"" + digest + "\" />\n" + "<textarea name=\"msg\" rows=\"" + we.rows + "\" cols=\"" + we.cols + "\" wrap=\"virtual\" id=\"textarea\">" + postdata_input + "</textarea><br />\n" + "</div>\n</form>\n";
            p.put("title", we._("title_collided"));
            p.put("body", body);
            return p;
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("page", refer);
        p.put("msg", we._("title_updated"));
        return p;
    }
}

