/*
 * Decompiled with CFR 0.152.
 */
package com.wam_soft.wiki;

import com.wam_soft.wiki.Folder;
import com.wam_soft.wiki.PluginSupport;
import com.wam_soft.wiki.WikiEngine;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

class Attach
extends PluginSupport {
    static Logger log;
    int MAX_FILESIZE = 1000000;
    String icon = "<img src=\"file.gif\" width=\"20\" height=\"20\" alt=\"file\" style=\"border-width:0px\">";
    static long count;
    static final String ATTR_ATTACH_FILES = "wiki.attachFiles";
    static long ct;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wam_soft.wiki.Attach");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((String)clazz.getName());
        ct = 0L;
    }

    Attach() {
    }

    Map findFile(String page, WikiEngine we) {
        TreeMap<String, String> p = new TreeMap<String, String>();
        String decoded_pgname = we.encode(we.page);
        Object[] objectArray = new Object[2];
        Date xnow = new Date();
        objectArray[0] = xnow;
        Object[] opt = objectArray;
        MessageFormat lastmodMsg = new MessageFormat("{0,date,yyyy/MM/dd HH:mm:ss}");
        MessageFormat sizeMsg = new MessageFormat(" {1,number,###,###,###.#}KB");
        File attach = we.getDataDir("attach");
        String[] files = attach.list();
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            if (!file.startsWith(".") && we.preg.match("/^" + decoded_pgname + "_([^.]+)$/", file)) {
                File target = new File(attach, file);
                xnow.setTime(target.lastModified());
                opt[1] = new Double((double)target.length() / 1000.0);
                String lastmod = lastmodMsg.format(opt);
                String dfsize = sizeMsg.format(opt);
                String filename = we.decode(we.preg.group(1));
                String filename_url = we.urlEncode(filename);
                String refername_url = we.urlEncode(we.page);
                String counter = "";
                String[] list = we.file(new File(attach, String.valueOf(file) + ".log"));
                if (list.length > 0) {
                    counter = " <span class=\"small\">" + this.strReplace("$1", list[0].trim(), we._("attach_plugin_files")) + "</span>";
                }
                String item = "<a href=\"" + we.script + "?plugin=attach&amp;openfile=" + filename_url + "&amp;refer=" + refername_url + "\" title=\"" + lastmod + dfsize + "\">" + this.icon + filename + "</a>" + counter + "\n" + "<span class=\"small\">" + "[<a href=\"" + we.script + "?plugin=attach&amp;mode=confirm&amp;delfile=" + filename_url + "&amp;refer=" + refername_url + "\" title=\"" + this.strReplace("$1", filename, we._("msg_delete")) + "\">" + we._("btn_delete") + "</a>]" + "</span>";
                p.put(String.valueOf(lastmod) + ++count, item);
            }
            ++i;
        }
        return p;
    }

    String formText(WikiEngine we) {
        String refer = we.page;
        log.debug((Object)("attach form page:" + refer));
        String max_size = String.valueOf(this.MAX_FILESIZE / 1000) + "KB";
        return "<form enctype=\"multipart/form-data\" action=\"" + we.script + "?\" method=\"post\">\n" + "<blockquote>\n" + "<input type=\"hidden\" name=\"plugin\" value=\"attach\" />\n" + "<input type=\"hidden\" name=\"refer\" value=\"" + WikiEngine.htmlspecialchars(refer) + "\" />\n" + "<span class=\"small\">[<a href=\"" + we.script + "?plugin=attach&amp;pcmd=list\">" + we._("msg_attach_filelist") + "</a>]</span><br />\n" + "<span class=\"small\">" + we.strReplace("$1", max_size, we._("msg_maxsize")) + "</span><br />\n" + we._("msg_attachfile") + ": <input type=\"file\" name=\"attach_file\" />\n" + "<input type=\"submit\" value=\"" + we._("btn_upload") + "\" /><br />\n" + "</blockquote>\n" + "</form>\n";
    }

    public String convert(WikiEngine we, String[] args) {
        StringBuffer buf = new StringBuffer(80);
        Map p = this.findFile(we.page, we);
        Map q = (Map)we.request.getAttribute(ATTR_ATTACH_FILES);
        if (q == null) {
            we.request.setAttribute(ATTR_ATTACH_FILES, (Object)p);
        } else {
            q.putAll(p);
        }
        log.debug((Object)"attach files ");
        log.debug((Object)p);
        if (!p.isEmpty()) {
            WikiEngine.join(buf, "", p.values().toArray());
        }
        buf.append(this.formText(we));
        Object refHint = we.request.getAttribute("wiki.attach.hint");
        if (refHint != null) {
            buf.append("\n#ref(").append(refHint).append(")</br>");
        }
        return new String(buf);
    }

    StringBuffer getFileList(WikiEngine we) {
        File dir = we.getDataDir("attach");
        String[] files = dir.list();
        HashMap<String, String> pagenames = new HashMap<String, String>();
        HashMap<String, StringBuffer> aryret = new HashMap<String, StringBuffer>();
        Date[] xnow = new Date[]{new Date()};
        MessageFormat lastModMsg = new MessageFormat("{0,Date} {0,Time}");
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            if (file.charAt(0) != '.' && file.indexOf(".log") <= 0 && we.preg.match("/^([^_]+)_([^_]+)$/", file)) {
                String pagename = we.decode(we.preg.group(1));
                String filename = we.decode(we.preg.group(2));
                String pagename_url = we.urlEncode(pagename);
                String filename_url = we.urlEncode(filename);
                String passage = we.getPgPassage(pagename, true);
                pagename = we.stripBracket(pagename);
                File dfile = new File(dir, file);
                long dfile_size = dfile.length() / 1000L;
                pagenames.put(pagename, "<li><a href=\"" + we.script + "?" + pagename_url + "\">" + pagename + "</a>" + passage + "</li>\n");
                String file_size = String.valueOf(dfile_size) + "KB";
                xnow[0].setTime(dfile.lastModified());
                String lastmod = lastModMsg.format(xnow);
                String del = "[<a href=\"" + we.script + "?plugin=attach&amp;mode=confirm&amp;delfile=" + filename_url + "&amp;refer=" + pagename_url + "\" title=\"" + we.strReplace("$1", filename, we._("msg_delete")) + "\">" + we._("btn_delete") + "</a>]";
                String open = "<a href=\"" + we.script + "?plugin=attach&amp;openfile=" + filename_url + "&amp;refer=" + pagename_url + "\" title=\"" + lastmod + " " + file_size + "\">" + filename + "</a>";
                StringBuffer buf = (StringBuffer)aryret.get(pagename);
                if (buf == null) {
                    buf = new StringBuffer();
                    aryret.put(pagename, buf);
                }
                buf.append("<li>").append(open).append(" <span class=\"small\">").append(del).append("</span></li>\n");
            }
            ++i;
        }
        ArrayList keys = new ArrayList(aryret.keySet());
        Collections.sort(keys);
        StringBuffer retbody = new StringBuffer();
        Iterator iter = ((AbstractList)keys).iterator();
        while (iter.hasNext()) {
            String pagename = (String)iter.next();
            retbody.append(pagenames.get(pagename)).append("<ul>\n").append(aryret.get(pagename)).append("</ul>\n");
        }
        return retbody;
    }

    void touchIfExists(File t) {
        if (t.exists()) {
            t.setLastModified(System.currentTimeMillis());
        }
    }

    File getAttachFile(String name, WikiEngine we) {
        return new File(we.getDataDir("attach"), name);
    }

    String nameHint(String t) {
        if (t == null) {
            return "file" + ct;
        }
        int p = t.lastIndexOf(47);
        if (p > 0) {
            t = t.substring(p + 1);
        }
        if ((p = t.lastIndexOf(92)) > 0) {
            t = t.substring(p + 1);
        }
        if (this.empty(t)) {
            return "file" + ct;
        }
        return t;
    }

    public Map action(WikiEngine we) {
        String filename;
        if (we.request == null) {
            log.warn((Object)"no request.");
            return super.action(we);
        }
        String pcmd = we.request.getParameter("pcmd");
        String ret = "";
        HashMap<String, String> retvars = new HashMap<String, String>();
        String refer = we.request.getParameter("refer");
        Folder.FileItem attach_file = we.getFileItem("attach_file");
        if (attach_file != null) {
            if (attach_file.getSize() > (long)this.MAX_FILESIZE) {
                return PluginSupport.asMap(new String[]{"msg", we._("msg_exceed")});
            }
            if (we.isFreeze(refer)) {
                return PluginSupport.asMap(new String[]{"msg", we._("msg_noparm")});
            }
            String pagename = we.encode(refer);
            String refHint = this.nameHint(attach_file.getNameHint());
            String filename2 = String.valueOf(pagename) + "_" + we.encode(refHint);
            File dst = this.getAttachFile(filename2, we);
            try {
                if (Folder.moveFile(dst, attach_file.getFile())) {
                    attach_file.remove();
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
            this.touchIfExists(we.getFileName(pagename));
            retvars.put("msg", we._("title_uploaded"));
            retvars.put("page", refer);
            we.request.setAttribute("wiki.attach.hint", (Object)refHint);
        }
        String delfile = we.request.getParameter("delfile");
        String mode = we.request.getParameter("mode");
        String openfile = we.request.getParameter("openfile");
        if ("list".equals(pcmd)) {
            retvars.put("msg", we._("msg_attach_filelist"));
            retvars.put("body", this.getFileList(we).toString());
            return retvars;
        }
        if (!this.empty(delfile)) {
            if ("confirm".equals(mode)) {
                String form = "\n<form action=\"" + we.script + "?\" method=\"post\">\n" + "<div>\n" + "<input type=\"hidden\" name=\"plugin\" value=\"attach\" />\n" + "<input type=\"hidden\" name=\"refer\" value=\"" + this.htmlspecialchars(refer) + "\" />\n" + "<input type=\"hidden\" name=\"delfile\" value=\"" + this.htmlspecialchars(delfile) + "\" />\n" + "<input type=\"submit\" value=\"" + we._("btn_delete") + "\" />\n" + "</div>\n</form>";
                retvars.put("body", this.strReplace("$2", form, this.strReplace("$1", delfile, we._("msg_confirm_delete"))));
                retvars.put("msg", this.strReplace("$1", delfile, we._("title_confirm_delete")));
            } else {
                if (we.isFreeze(refer)) {
                    return PluginSupport.asMap(new String[]{"msg", we._("msg_noparm")});
                }
                filename = String.valueOf(we.encode(refer)) + "_" + we.encode(delfile);
                File target = this.getAttachFile(filename, we);
                if (!target.exists()) {
                    return PluginSupport.asMap(new String[]{"msg", we._("title_notfound")});
                }
                if (!target.delete()) {
                    log.warn((Object)(target + " remove faild."));
                }
                this.touchIfExists(we.getFileName(we.encode(refer)));
                retvars.put("msg", we._("title_file_deleted"));
                retvars.put("page", refer);
            }
        } else if (!this.empty(openfile)) {
            filename = String.valueOf(we.encode(refer)) + "_" + we.encode(openfile);
            File target = this.getAttachFile(filename, we);
            if (!target.exists()) {
                return PluginSupport.asMap(new String[]{"msg", we._("title_notfound")});
            }
            this.die();
        } else if ("upload".equals(pcmd) && !this.empty(we.page)) {
            ret = String.valueOf(ret) + this.formText(we);
            retvars.put("msg", we._("title_upload"));
            retvars.put("body", ret);
            return retvars;
        }
        return retvars;
    }
}

