/*
 * Decompiled with CFR 0.152.
 */
package com.wam_soft.wiki;

import com.wam_soft.wiki.PluginSupport;
import com.wam_soft.wiki.WikiEngine;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;

class Calendar
extends PluginSupport {
    String cmd = "read";
    String weekHeader = "\u65e5:\u6708:\u706b:\u6c34:\u6728:\u91d1:\u571f";

    Calendar() {
    }

    boolean isDateFormat(String t, WikiEngine we) {
        return t.length() == 6 && we.preg.match("/\\d+/", t);
    }

    String genDateText(Date dt, WikiEngine we) {
        Object[] opt = new Object[]{dt};
        return MessageFormat.format("{0,date,yyyyMM}", opt);
    }

    String genPrefixText(String hint, WikiEngine we) {
        return String.valueOf(we.preg.substitute("s/^\\[\\[(.*)\\]\\]$/$1/", hint)) + "/";
    }

    public String convert(WikiEngine we, String[] args) {
        String prefix;
        String pre;
        String date_str;
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(we.now);
        cal.setLenient(true);
        int tyr = cal.get(1);
        int tmon = cal.get(2) + 1;
        int tday = cal.get(5);
        switch (args.length) {
            default: {
                return "";
            }
            case 0: {
                date_str = this.genDateText(we.now, we);
                pre = we.page;
                prefix = this.genPrefixText(pre, we);
                break;
            }
            case 1: {
                if (this.isDateFormat(args[0], we)) {
                    date_str = args[0];
                    pre = we.page;
                    prefix = this.genPrefixText(pre, we);
                    break;
                }
                date_str = this.genDateText(we.now, we);
                pre = args[0];
                prefix = String.valueOf(args[0]) + "/";
                break;
            }
            case 2: {
                if (this.isDateFormat(args[0], we)) {
                    date_str = args[0];
                    pre = args[1];
                    prefix = String.valueOf(args[1]) + "/";
                    break;
                }
                if (this.isDateFormat(args[1], we)) {
                    date_str = args[1];
                    pre = args[0];
                    prefix = String.valueOf(args[0]) + "/";
                    break;
                }
                date_str = this.genDateText(we.now, we);
                pre = we.page;
                prefix = this.genPrefixText(pre, we);
            }
        }
        PluginSupport.log.debug(Arrays.asList("date_str", date_str, "pre", pre, "prefix", prefix));
        if (this.empty(this.cmd)) {
            this.cmd = "read";
        }
        prefix = we.stripHtmlTag(prefix);
        int yr = Integer.parseInt(date_str.substring(0, 4));
        int mon = Integer.parseInt(date_str.substring(4));
        boolean other_month = yr != tyr || mon != tmon;
        cal.clear();
        cal.set(1, yr);
        cal.set(2, mon - 1);
        cal.set(5, 1);
        String prefix_url = !we.preg.match("/^((" + we.wikiName + ")|(" + we.bracketName + "))$/", pre) ? "[[" + pre + "]]" : pre;
        prefix_url = we.urlEncode(prefix_url);
        pre = we.stripBracket(pre);
        StringBuffer ret = new StringBuffer(300).append("<table class=\"style_calendar\" cellspacing=\"1\" width=\"150\" border=\"0\">\n<tr><td align=\"middle\" class=\"style_td_caltop\" colspan=\"7\">\n<div class=\"small\" style=\"text-align:center\"><strong>").append(PluginSupport.zp(yr, 4)).append('.').append(PluginSupport.zp(mon, 2)).append(" (").append(this.cmd).append(") </strong><br />[<a href=\"").append(we.script).append('?').append(prefix_url).append("\">").append(pre).append("</a>]</div>\n</td></tr>\n<tr>");
        String[] weeklabels = we.explode(':', this.weekHeader);
        int i = 0;
        while (i < weeklabels.length) {
            String label = weeklabels[i];
            ret.append("<td align=\"middle\" class=\"style_td_week\">\n<div class=\"small\" style=\"text-align:center\"><strong>").append(label).append("</strong></div></td>\n");
            ++i;
        }
        ret.append("</tr><tr>");
        int days = cal.getActualMaximum(5);
        int wday = cal.get(7) - 1;
        boolean fweek = true;
        String dtPrefix = String.valueOf(PluginSupport.zp(yr, 4)) + "." + PluginSupport.zp(mon, 2);
        int day = 1;
        while (day <= days) {
            String tdc;
            String name = String.valueOf(prefix) + dtPrefix + "." + PluginSupport.zp(day, 2);
            String page = "[[" + name + "]]";
            String page_url = we.urlEncode(page);
            String refer = "";
            if ("edit".equals(this.cmd)) {
                refer = "&amp;refer=" + page_url;
            }
            String link = "read".equals(this.cmd) && !we.isPage(page) ? "<strong>" + day + "</strong>" : "<a href=\"" + we.script + "?cmd=" + this.cmd + "&amp;page=" + page_url + refer + "\" title=\"" + name + "\"><strong>" + day + "</strong></a>";
            if (fweek) {
                int i2 = 0;
                while (i2 < wday) {
                    ret.append("<td align=\"center\" class=\"style_td_blank\">&nbsp;</td>\n");
                    ++i2;
                }
                fweek = false;
            }
            if (wday == 0) {
                ret.append("</tr><tr>\n");
            }
            if (!other_month && day == tday && mon == tmon && yr == tyr) {
                tdc = "style_td_today";
            } else {
                switch (wday) {
                    case 0: {
                        tdc = "style_td_sun";
                        break;
                    }
                    case 6: {
                        tdc = "style_td_sat";
                        break;
                    }
                    default: {
                        tdc = "style_td_day";
                    }
                }
            }
            ret.append("<td align=\"center\" class=\"").append(tdc).append("\"><span class=\"small\">").append(link).append("</span></td>\n");
            ++wday;
            wday %= 7;
            ++day;
        }
        if (wday > 0) {
            while (wday++ < 7) {
                ret.append("<td align=\"center\" class=\"style_td_blank\">&nbsp;</td>\n");
            }
        }
        return new String(ret.append("  </tr>\n</table>\n"));
    }

    static class Edit
    extends Calendar {
        Edit() {
            this.cmd = "edit";
        }
    }
}

