/*
 * Decompiled with CFR 0.152.
 */
package com.wam_soft.wiki;

import com.wam_soft.wiki.PluginSupport;
import com.wam_soft.wiki.WikiEngine;
import com.wam_soft.wiki.WikiServlet;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class Comment
extends PluginSupport {
    int NAME_COLS = 15;
    int COMMENT_COLS = 70;
    String NAME_FORMAT = "[[$name]]";
    String NOW_FORMAT = "SIZE(10){$now}";
    String COMMENT_FORMAT = "$msg -- $name $now";
    int comment_ins = 1;

    Comment() {
    }

    public Map action(WikiEngine we) {
        boolean conflict;
        String msg = we.request.getParameter("msg");
        if (this.empty(msg)) {
            return super.action(we);
        }
        String comment_format = "1".equals(we.request.getParameter("nodate")) ? this.strReplace("$now", "", this.COMMENT_FORMAT) : this.COMMENT_FORMAT;
        msg = we.normalize(msg);
        msg = this.strReplace("\n", "", msg);
        String refer = we.request.getParameter("refer");
        String memo_body = msg;
        int pcomment_no = Integer.parseInt(we.request.getParameter("comment_no"));
        String[] postdata_old = we.getSource(refer);
        int comment_no = 0;
        String name = this.available("name", we) ? this.strReplace("$name", we.request.getParameter("name"), this.NAME_FORMAT) : "";
        String head = "";
        if (we.preg.match("/^(-{1,2})(.*)/", msg)) {
            head = we.preg.group(1);
            msg = we.preg.group(2);
        }
        String comment = this.strReplace("$msg", msg, comment_format);
        comment = this.strReplace("$name", name, comment);
        comment = this.strReplace("$now", MessageFormat.format("{0,date,EEE, dd MMM yyyy HH:mm:ss z}", we.now), comment);
        comment = String.valueOf(head) + comment;
        StringBuffer postdata = new StringBuffer();
        int i = 0;
        while (i < postdata_old.length) {
            String line = postdata_old[i];
            if (this.comment_ins == 0) {
                postdata.append(line).append('\n');
            }
            if (we.preg.match("/^#comment$/", line) && comment_no++ == pcomment_no && !this.empty(msg)) {
                postdata.append('-').append(comment).append('\n');
            }
            if (this.comment_ins == 1) {
                postdata.append(line).append('\n');
            }
            ++i;
        }
        String digest = we.request.getParameter("digest");
        try {
            conflict = we.writeText(refer, new String(postdata), digest, false);
        }
        catch (IOException e) {
            PluginSupport.log.warn((Object)e);
            throw new RuntimeException(e.getMessage());
        }
        if (conflict) {
            PluginSupport.log.debug((Object)"!!!conflict!!!");
            HashMap<String, String> p = new HashMap<String, String>();
            p.put("title", we._("title_comment_collided"));
            p.put("body", String.valueOf(we._("msg_comment_collided")) + we.makeLink(refer));
            return p;
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("page", refer);
        return p;
    }

    public String convert(WikiEngine we, String[] args) {
        Integer commentNo = (Integer)we.request.getAttribute("wiki.commentNo");
        if (commentNo == null) {
            commentNo = new Integer(0);
        }
        String nametags = String.valueOf(we._("btn_name")) + "<input type=\"text\" name=\"name\" size=\"" + this.NAME_COLS + "\" />\n";
        String button = "";
        String nodate = "0";
        if (Arrays.asList(args).contains("nodate")) {
            nodate = "1";
        }
        if (this.argCheck("read", we) || !this.available("cmd", we) || this.argCheck("unfreeze", we) || this.argCheck("freeze", we) || this.available("write", we) || this.available("comment", we)) {
            button = "<input type=\"submit\" name=\"comment\" value=\"" + this.htmlspecialchars(we._("btn_comment")) + "\" />\n";
        }
        String digest = WikiServlet.getDigest(we.page, we);
        String text = "<br/><form action=\"" + we.script + "?#comment" + commentNo + "\" method=\"post\">\n" + "<div><a name=\"comment" + commentNo + "\">\n" + "<input type=\"hidden\" name=\"comment_no\" value=\"" + commentNo + "\" />\n" + "<input type=\"hidden\" name=\"refer\" value=\"" + this.htmlspecialchars(we.page) + "\" />\n" + "<input type=\"hidden\" name=\"plugin\" value=\"comment\" />\n" + "<input type=\"hidden\" name=\"nodate\" value=\"" + this.htmlspecialchars(nodate) + "\" />\n" + "<input type=\"hidden\" name=\"digest\" value=\"" + this.htmlspecialchars(digest) + "\" />\n" + nametags + "<input type=\"text\" name=\"msg\" size=\"" + this.COMMENT_COLS + "\" />\n" + button + "</a></div></form>\n";
        we.request.setAttribute("wiki.commentNo", (Object)new Integer(commentNo + 1));
        return text;
    }
}

