/*
 * Decompiled with CFR 0.152.
 */
package com.wam_soft.wiki;

import com.oreilly.servlet.MultipartRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.DefaultFileItem;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;

class Folder {
    static Logger log;
    static final String[] EMPTY_VALUES;
    static final String ATTR_FILE_ITEMS = "wiki.fileItems";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wam_soft.wiki.Folder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((String)clazz.getName());
        EMPTY_VALUES = new String[0];
    }

    Folder() {
    }

    static long passThru(OutputStream out, InputStream in) throws IOException {
        long ct = 0L;
        if (in == null) {
            return ct;
        }
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                ct += (long)len;
            }
            out.flush();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            in.close();
            throw throwable;
        }
        Object var6_7 = null;
        in.close();
        return ct;
    }

    static boolean moveFile(File dst, File src) throws IOException {
        if (src.renameTo(dst)) {
            return false;
        }
        FileOutputStream out = new FileOutputStream(dst);
        try {
            long ct = Folder.passThru(out, new FileInputStream(src));
            log.debug((Object)(dst + " moved in " + ct + " bytes."));
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        Object var5_6 = null;
        ((OutputStream)out).close();
        return true;
    }

    static boolean _empty(String t) {
        return t == null || t.trim().length() == 0;
    }

    static File getWorkFolder(ServletContext app, String name) throws ServletException {
        File workFolder = (File)app.getAttribute("javax.servlet.context.tempdir");
        if (!(Folder._empty(name) || (workFolder = new File(workFolder, name)).exists() || workFolder.mkdir())) {
            app.log("Cant't create work folder:" + workFolder);
            throw new UnavailableException("can't create work folder:" + workFolder);
        }
        return workFolder;
    }

    private static Map addParam(Map p, String key, String value) {
        Object a = p.get(key);
        if (a == null) {
            p.put(key, value);
            return p;
        }
        if (a instanceof String) {
            p.put(key, new String[]{(String)a, value});
            return p;
        }
        int len = ((String[])a).length;
        String[] tt = new String[len + 1];
        tt[len] = value;
        System.arraycopy(a, 0, tt, 0, len);
        p.put(key, tt);
        return p;
    }

    static UploadSupport createUploadSupport(String name) throws ServletException {
        try {
            log.debug((Object)name);
            return (UploadSupport)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            throw new ServletException("upload adapter" + name + " not exists.", (Throwable)e);
        }
    }

    static class UploadFailure
    extends RuntimeException {
        UploadFailure(String message, Exception rootCause) {
            super(message, rootCause);
        }
    }

    interface FileItem {
        public String getContentType();

        public InputStream getInputStream() throws IOException;

        public File getFile();

        public long getSize();

        public String getNameHint();

        public void remove() throws IOException;
    }

    private static class Wraped
    implements FileItem {
        org.apache.commons.fileupload.FileItem item;
        File workFolder;

        Wraped(org.apache.commons.fileupload.FileItem item) {
            this.item = item;
        }

        public String getContentType() {
            return this.item.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this.item.getInputStream();
        }

        public long getSize() {
            return this.item.getSize();
        }

        public void remove() {
            this.item.delete();
        }

        public String getNameHint() {
            return this.item.getName();
        }

        String getFieldName() {
            return this.item.getFieldName();
        }

        public File getFile() {
            DefaultFileItem xitem;
            if (this.item instanceof DefaultFileItem && (xitem = (DefaultFileItem)this.item).getStoreLocation() != null) {
                return xitem.getStoreLocation();
            }
            try {
                File tmp = File.createTempFile("afu", null, this.workFolder);
                this.item.write(tmp);
                log.debug((Object)("wrote:" + tmp));
                return tmp;
            }
            catch (IOException e) {
                throw new UploadFailure("java.io.File#createTempFile failed ?" + this.workFolder, e);
            }
            catch (Exception e) {
                throw new UploadFailure("org.apache.commons.fileupload.FileItem#write failed ?", e);
            }
        }
    }

    static abstract class UploadSupport {
        ServletConfig conf;
        protected HttpServletRequest request;
        protected String inputEncodingHint;
        int parseLongFailCount;

        UploadSupport() {
        }

        public void init(ServletConfig config) {
            this.conf = config;
        }

        protected String getInitParameter(String t) {
            return this.conf.getInitParameter(t);
        }

        protected File getWorkFolder() throws ServletException {
            return Folder.getWorkFolder(this.conf.getServletContext(), "wiki.upload");
        }

        protected abstract int parse(HttpServletRequest var1, String var2) throws ServletException, IOException;

        long parseLong(String t, long def) {
            try {
                return Long.parseLong(t);
            }
            catch (NumberFormatException e) {
                if (this.parseLongFailCount++ < 5) {
                    log.warn((Object)e);
                }
                return def;
            }
        }

        public abstract String getParameter(String var1);

        public abstract String[] getParameterValues(String var1);

        public final HttpServletRequest getWrapper() {
            Map p;
            if (this.request == null) {
                new IllegalStateException("request was null.");
            }
            if ((p = (Map)this.request.getAttribute(Folder.ATTR_FILE_ITEMS)) == null) {
                log.warn((Object)"no file items in request attributes.");
            } else {
                Iterator i = p.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    this.request.setAttribute(key, p.get(key));
                }
            }
            return new ReqWrap(this.request, this);
        }
    }

    private static class ReqWrap
    extends HttpServletRequestWrapper {
        UploadSupport us;

        ReqWrap(HttpServletRequest req, UploadSupport us) {
            super(req);
            this.us = us;
        }

        public String getCharacterEncoding() {
            return !Folder._empty(this.us.inputEncodingHint) ? this.us.inputEncodingHint : super.getCharacterEncoding();
        }

        public String getParameter(String name) {
            String t = this.us.getParameter(name);
            return t != null ? t : super.getParameter(name);
        }

        public String[] getParameterValues(String name) {
            String[] values = this.us.getParameterValues(name);
            return values != null ? values : super.getParameterValues(name);
        }
    }

    static final class ApacheUpload
    extends UploadSupport {
        Map fileItems = new HashMap();
        Map fieldItems = new HashMap();
        File workFolder;

        ApacheUpload() {
        }

        protected int parse(HttpServletRequest request, String encodingHint) throws ServletException, IOException {
            this.inputEncodingHint = encodingHint;
            DiskFileUpload fu = new DiskFileUpload();
            String t = (String)request.getAttribute("wiki.headerEncoding");
            if (!Folder._empty(t) || !Folder._empty(t = this.getInitParameter("ul.headerEncoding"))) {
                fu.setHeaderEncoding(t);
            }
            if (!Folder._empty(t = this.getInitParameter("ul.sizeMax"))) {
                fu.setSizeMax(this.parseLong(t, 0xA00000L));
            }
            if (!Folder._empty(t = this.getInitParameter("ul.sizeThreshold"))) {
                fu.setSizeThreshold((int)this.parseLong(t, 10240L));
            }
            this.workFolder = this.getWorkFolder();
            log.debug((Object)("encodingHint:" + encodingHint));
            t = this.getInitParameter("ul.repositoryPath");
            if (Folder._empty(t)) {
                t = this.workFolder.getPath();
            }
            fu.setRepositoryPath(t);
            List items = null;
            try {
                items = fu.parseRequest(request);
            }
            catch (FileUploadException e) {
                throw new UploadFailure("#parseRequest failed.", (Exception)((Object)e));
            }
            int i = 0;
            int n = items.size();
            while (i < n) {
                org.apache.commons.fileupload.FileItem item = (org.apache.commons.fileupload.FileItem)items.get(i);
                if (item.isFormField()) {
                    Folder.addParam(this.fieldItems, item.getFieldName(), encodingHint == null ? item.getString() : item.getString(encodingHint));
                } else {
                    Wraped a = new Wraped(item);
                    this.fileItems.put(item.getFieldName(), a);
                    a.workFolder = this.workFolder;
                    this.fieldItems.put(item.getFieldName(), item.getName());
                }
                ++i;
            }
            this.request = request;
            request.setAttribute(Folder.ATTR_FILE_ITEMS, (Object)this.fileItems);
            log.debug((Object)this.fieldItems);
            log.debug((Object)this.fileItems);
            return this.fileItems.size();
        }

        private String classNameOf(Object t) {
            return t == null ? "unknown(null)" : t.getClass().getName();
        }

        public String getParameter(String name) {
            Object t = this.fieldItems.get(name);
            return t == null || t instanceof String ? (String)t : ((String[])t)[0];
        }

        public String[] getParameterValues(String name) {
            String[] stringArray;
            Object t = this.fieldItems.get(name);
            if (t == null) {
                stringArray = EMPTY_VALUES;
            } else if (t instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)t;
            } else {
                stringArray = (String[])t;
            }
            return stringArray;
        }
    }

    private static class CosWraped
    implements FileItem {
        CosUpload owner;
        String name;
        File cached;

        CosWraped(CosUpload owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        public String getContentType() {
            return this.owner.holder.getContentType(this.name);
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.getFile());
        }

        public long getSize() {
            return this.getFile().length();
        }

        public void remove() {
        }

        public String getNameHint() {
            return this.owner.holder.getOriginalFileName(this.name);
        }

        String getFieldName() {
            return this.name;
        }

        public File getFile() {
            if (this.cached == null) {
                this.cached = this.owner.holder.getFile(this.name);
            }
            return this.cached;
        }
    }

    static final class CosUpload
    extends UploadSupport {
        MultipartRequest holder;
        Map fileItems = new HashMap();

        CosUpload() {
        }

        public String getParameter(String name) {
            return this.holder.getParameter(name);
        }

        public String[] getParameterValues(String name) {
            String[] values = this.holder.getParameterValues(name);
            return values != null ? values : EMPTY_VALUES;
        }

        protected int parse(HttpServletRequest request, String encodingHint) throws ServletException, IOException {
            this.inputEncodingHint = encodingHint;
            int maxPostSize = 0xA00000;
            String t = this.getInitParameter("ul.sizeMax");
            if (!Folder._empty(t)) {
                maxPostSize = (int)this.parseLong(t, 0xA00000L);
            }
            this.holder = new MultipartRequest(request, this.getWorkFolder().getPath(), maxPostSize, encodingHint);
            Enumeration e = this.holder.getFileNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                CosWraped a = new CosWraped(this, name);
                this.fileItems.put(name, a);
            }
            this.request = request;
            request.setAttribute(Folder.ATTR_FILE_ITEMS, (Object)this.fileItems);
            log.debug((Object)this.fileItems);
            return this.fileItems.size();
        }
    }
}

