/*
 * Decompiled with CFR 0.152.
 */
package com.wam_soft.wiki;

import com.wam_soft.wiki.DiffTool;
import com.wam_soft.wiki.Folder;
import com.wam_soft.wiki.Plugin;
import com.wam_soft.wiki.WikiServlet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Substitution;

class WikiEngine {
    private static final String RCSID = "$Id: WikiEngine.java,v 1.11 2004/08/23 02:33:16 iwao Exp $";
    static String EUCEncoding = "EUC-JP";
    static Logger log;
    String rbName = "com.wam_soft.wiki.message";
    Perl5Util preg = new Perl5Util();
    static final String[] line_rules;
    static final String[] facemark_rules;
    boolean usefacemark = true;
    Date now = new Date();
    private String[] user_rules_reg;
    private String[] user_rules_reg2;
    boolean strip_link_wall;
    String wikiName;
    String bracketName;
    String interWikiName;
    private Perl5Matcher matcher;
    private Perl5Compiler p5c;
    SubstitutionSupport linkSupport;
    Map related;
    String link_target;
    String interwiki_target;
    static final String xbase = "0123456789ABCDEF";
    static final char[] xcode;
    int content_id;
    int rows;
    int cols;
    String script;
    String defaultpage;
    String whatsnew;
    String interwiki;
    String hr;
    String note_hr;
    String top;
    boolean related_link;
    boolean show_passage;
    String top_link;
    MakeNote noteHelper;
    int note_id;
    ArrayList foot_explain;
    private PluginHandler ph;
    private PluginHandler phNoArg;
    int _list_left_margin;
    int _list_margin;
    private File xdataDir;
    static final String[] EMPTY_VALUES;
    Map _isPage;
    String page;
    Boolean _isFreeze;
    Map _pg_passage;
    int maxshow;
    boolean useRawUrlEncode;
    static Map pluginMap;
    Map pluginInstanceMap;
    HttpServletRequest request;
    String non_list;
    boolean list_index;
    static String rule_body;
    static final int SEARCH_AND = 0;
    static final int SEARCH_OR = 1;
    int searchCount;
    boolean auto_template_func;
    Map auto_template_rules;
    int cycle;
    int maxage;
    String splitter;
    DiffTool diffTool;
    String savedDigest;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wam_soft.wiki.WikiEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((String)clazz.getName());
        line_rules = new String[]{"s#COLOR\\(([^\\(\\)]*)\\){([^}]*)}#<span style='color:$1'>$2</span>#g", "s#SIZE\\(([^\\(\\)]*)\\){([^}]*)}#<span style='font-size:$1px;display:inline-block;line-height:130%;text-indent:0px'>$2</span>#g", "s#COLOR\\(([^\\(\\)]*)\\):((?:(?!COLOR\\([^\\)]+\\)\\:).)*)#<span style='color:$1'>$2</span>#g", "s#SIZE\\(([^\\(\\)]*)\\):((?:(?!SIZE\\([^\\)]+\\)\\:).)*)#<span class='size$1'>$2</span>#g", "s#LEFT:((?:(?!LEFT\\:).)*)#<div style='text-align:left'>$1</div>#g", "s#CENTER:((?:(?!CENTER\\:).)*)#<div style='text-align:center'>$1</div>#g", "s#RIGHT:((?:(?!RIGHT\\:).)*)#<div style='text-align:right'>$1</div>#g", "s#%%((?:(?!%%).)*)%%#<del>$1</del>#g", "s#'''((?:(?!''').)*)'''#<em>$1</em>#g", "s#''((?:(?!'').)*)''#<strong>$1</strong>#g", "s#~((?:<\\/[a-zA-Z]+>)*)$#$1<br />#g", "s#&amp;aname\\(([A-Za-z][\\w\\-]*)\\);#<a id='$1' name='$1'></a>#g"};
        facemark_rules = new String[]{"s#\\s(\\:\\))# <img src='face/smile.gif' alt='$1' />#g", "s#\\s(\\:D)# <img src='face/bigsmile.gif' alt='$1' />#g", "s#\\s(\\:p)# <img src='face/huh.gif' alt='$1' />#g", "s#\\s(\\:d)# <img src='face/huh.gif' alt='$1' />#g", "s#\\s(XD)# <img src='face/oh.gif' alt='$1' />#g", "s#\\s(X\\()# <img src='face/oh.gif' alt='$1' />#g", "s#\\s(;\\))# <img src='face/wink.gif' alt='$1' />#g", "s#\\s(;\\()# <img src='face/sad.gif' alt='$1' />#g", "s#\\s(\\:\\()# <img src='face/sad.gif' alt='$1' />#g", "s#(\\:heart\\:)# <img src='face/heart.gif' alt='$1' />#g"};
        xcode = xbase.toCharArray();
        EMPTY_VALUES = new String[0];
        Object[] objectArray = new Object[32];
        objectArray[0] = "aname";
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.wam_soft.wiki.Anchor$Name");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[1] = clazz2;
        objectArray[2] = "anchor";
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.wam_soft.wiki.Anchor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[3] = clazz3;
        objectArray[4] = "article";
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("com.wam_soft.wiki.Article");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[5] = clazz4;
        objectArray[6] = "attach";
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("com.wam_soft.wiki.Attach");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[7] = clazz5;
        objectArray[8] = "back";
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("com.wam_soft.wiki.Back");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[9] = clazz6;
        objectArray[10] = "calendar";
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("com.wam_soft.wiki.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[11] = clazz7;
        objectArray[12] = "calendar_read";
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("com.wam_soft.wiki.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[13] = clazz8;
        objectArray[14] = "calendar_edit";
        Class<?> clazz9 = class$7;
        if (clazz9 == null) {
            try {
                clazz9 = class$7 = Class.forName("com.wam_soft.wiki.Calendar$Edit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[15] = clazz9;
        objectArray[16] = "comment";
        Class<?> clazz10 = class$8;
        if (clazz10 == null) {
            try {
                clazz10 = class$8 = Class.forName("com.wam_soft.wiki.Comment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[17] = clazz10;
        objectArray[18] = "counter";
        Class<?> clazz11 = class$9;
        if (clazz11 == null) {
            try {
                clazz11 = class$9 = Class.forName("com.wam_soft.wiki.Counter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[19] = clazz11;
        objectArray[20] = "include";
        Class<?> clazz12 = class$10;
        if (clazz12 == null) {
            try {
                clazz12 = class$10 = Class.forName("com.wam_soft.wiki.Include");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[21] = clazz12;
        objectArray[22] = "memo";
        Class<?> clazz13 = class$11;
        if (clazz13 == null) {
            try {
                clazz13 = class$11 = Class.forName("com.wam_soft.wiki.Memo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[23] = clazz13;
        objectArray[24] = "newpage";
        Class<?> clazz14 = class$12;
        if (clazz14 == null) {
            try {
                clazz14 = class$12 = Class.forName("com.wam_soft.wiki.NewPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[25] = clazz14;
        objectArray[26] = "ref";
        Class<?> clazz15 = class$13;
        if (clazz15 == null) {
            try {
                clazz15 = class$13 = Class.forName("com.wam_soft.wiki.Ref");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[27] = clazz15;
        objectArray[28] = "recent";
        Class<?> clazz16 = class$14;
        if (clazz16 == null) {
            try {
                clazz16 = class$14 = Class.forName("com.wam_soft.wiki.Recent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[29] = clazz16;
        objectArray[30] = "vote";
        Class<?> clazz17 = class$15;
        if (clazz17 == null) {
            try {
                clazz17 = class$15 = Class.forName("com.wam_soft.wiki.Vote");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[31] = clazz17;
        pluginMap = WikiEngine.asMap(objectArray);
    }

    WikiEngine() {
        Object[] opt = new Object[]{this.now};
        String[] str_rules = new String[]{MessageFormat.format("s#now\\?#{0,date,yyyy-MM-dd(E) HH:mm}#g", opt), MessageFormat.format("s#date\\?#{0,date,yyyy-MM-dd(E)}#g", opt), MessageFormat.format("s#time\\?#{0,date,HH:mm}#g", opt)};
        this.user_rules_reg2 = str_rules;
        ArrayList<String> rules = new ArrayList<String>(Arrays.asList(str_rules));
        rules.addAll(Arrays.asList(line_rules));
        if (this.usefacemark) {
            rules.addAll(Arrays.asList(facemark_rules));
        }
        this.user_rules_reg = rules.toArray(EMPTY_VALUES);
        this.strip_link_wall = true;
        this.wikiName = "[A-Z][a-z]+(?:[A-Z][a-z]+)+";
        this.bracketName = "\\[\\[(?!\\/|\\.\\/|\\.\\.\\/)(:?[^\\s\\]#&<>\":]+:?)\\]\\]";
        this.interWikiName = "\\[\\[(\\[*[^\\s\\]]+?\\]*):(\\[*[^>\\]]+?\\]*)\\]\\]";
        this.matcher = new Perl5Matcher();
        this.p5c = new Perl5Compiler();
        this.related = new HashMap();
        this.link_target = "_top";
        this.interwiki_target = "_top";
        this.rows = 20;
        this.cols = 80;
        this.script = "";
        this.defaultpage = "FrontPage";
        this.whatsnew = "RecentChanges";
        this.interwiki = "InterWikiName";
        this.hr = "<hr class='full_hr'>";
        this.note_hr = "<hr class='note_hr'>";
        this.top = this._("msg_content_back_to_top");
        this.related_link = true;
        this.show_passage = true;
        this.top_link = "";
        this.note_id = 1;
        this.foot_explain = new ArrayList();
        try {
            this.ph = new PluginHandler();
            this.phNoArg = new PluginHandlerNoArg();
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException(e.getMessage());
        }
        this._list_left_margin = 0;
        this._list_margin = 16;
        this.xdataDir = new File("wiki");
        this._isPage = new HashMap();
        this._pg_passage = new HashMap();
        this.maxshow = 300;
        this.useRawUrlEncode = true;
        this.pluginInstanceMap = new HashMap();
        this.non_list = "^(\\[\\[\\:)";
        this.list_index = true;
        this.auto_template_func = true;
        this.auto_template_rules = WikiEngine.asMap(new String[]{"\\[\\[((.+)\\/([^\\/]+))\\]\\]", "[[$2/template]]"});
        this.cycle = 1;
        this.maxage = 20;
        this.splitter = ">>>>>>>>>>";
    }

    String _(String key) {
        try {
            return ResourceBundle.getBundle(this.rbName).getString(key);
        }
        catch (MissingResourceException e) {
            log.warn((Object)(String.valueOf(key) + ": not found."));
            return key;
        }
    }

    static Map asMap(Object[] a) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        int i = 0;
        while (i + 1 < a.length) {
            p.put(a[i], a[i + 1]);
            i += 2;
        }
        return p;
    }

    String makeUserRules(String str) {
        int i = 0;
        while (i < this.user_rules_reg.length) {
            str = this.preg.substitute(this.user_rules_reg[i], str);
            ++i;
        }
        return str;
    }

    List makeUserRules(List a) {
        int i = 0;
        int n = a.size();
        while (i < n) {
            a.set(i, this.makeUserRules((String)a.get(i)));
            ++i;
        }
        return a;
    }

    String userRulesStr(String str) {
        Object[] lines = this.explode('\n', str);
        int j = 0;
        while (j < lines.length) {
            Object line = lines[j];
            int i = 0;
            while (i < this.user_rules_reg2.length) {
                line = this.preg.substitute(this.user_rules_reg2[i], (String)line);
                ++i;
            }
            lines[j] = line;
            ++j;
        }
        return WikiEngine.join("\n", lines);
    }

    String stripHtmlTag(String t) {
        if (t == null) {
            return t;
        }
        return this.preg.substitute("s/<[^>]+>//g", t);
    }

    String stripBracket(String str) {
        if (str != null && this.strip_link_wall && this.preg.match("/^\\[\\[(.*)\\]\\]$/", str)) {
            return this.preg.group(1);
        }
        return str;
    }

    int substitute(StringBuffer result, SubstitutionSupport sort, PatternMatcherInput input) {
        int beginOffset = input.getBeginOffset();
        int subCount = 0;
        char[] inputBuffer = input.getBuffer();
        boolean ct = false;
        while (this.matcher.contains(input, sort.pattern)) {
            result.append(inputBuffer, beginOffset, input.getMatchBeginOffset() - beginOffset);
            sort.appendSubstitution(result, this.matcher.getMatch(), ++subCount, input, (PatternMatcher)this.matcher, sort.pattern);
            beginOffset = input.getMatchEndOffset();
        }
        result.append(inputBuffer, beginOffset, input.length() - beginOffset);
        return subCount;
    }

    String substitute(SubstitutionSupport sort, String text) {
        StringBuffer buf = new StringBuffer();
        this.substitute(buf, sort, new PatternMatcherInput(text));
        return new String(buf);
    }

    String makeLink(String t) {
        if (this.linkSupport == null) {
            try {
                this.linkSupport = new LinkReplace();
            }
            catch (MalformedPatternException e) {
                log.error((Object)e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.substitute(this.linkSupport, t);
    }

    List makeLink(List a) {
        int i = 0;
        int n = a.size();
        while (i < n) {
            a.set(i, this.makeLink((String)a.get(i)));
            ++i;
        }
        return a;
    }

    String normalize(String t) {
        return this.preg.substitute("s/((\\x0D\\x0A)|(\\x0D)|(\\x0A))/\n/g", t);
    }

    static String hexCode(byte[] b) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            int value = b[i] & 0xFF;
            buf.append(xcode[value >> 4]).append(xcode[value & 0xF]);
            ++i;
        }
        return new String(buf);
    }

    String encode(String t) {
        if (t == null) {
            return t;
        }
        try {
            return WikiEngine.hexCode(t.getBytes(EUCEncoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    String decode(String t) {
        int len;
        if (t == null || (len = t.length()) < 2) {
            return "";
        }
        byte[] buf = new byte[len / 2];
        int ct = 0;
        int i = 0;
        while (i + 1 < len) {
            buf[ct++] = (byte)Integer.parseInt(t.substring(i, i + 2), 16);
            i += 2;
        }
        try {
            return new String(buf, EUCEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    static boolean empty(String t) {
        return t == null || t.trim().length() == 0;
    }

    public void parse(String text, Writer out) throws IOException {
        if (WikiEngine.empty(text)) {
            return;
        }
        out.write(this.convertHtml(text).toString());
    }

    static StringBuffer q(StringBuffer buf, Object a) {
        if (buf == null || a == null) {
            return buf;
        }
        String s = a.toString();
        int len = s.length();
        int i = 0;
        while (i < len) {
            block8: {
                String t;
                char c = s.charAt(i);
                switch (c) {
                    case '<': {
                        t = "&lt;";
                        break;
                    }
                    case '>': {
                        t = "&gt;";
                        break;
                    }
                    case '&': {
                        t = "&amp;";
                        break;
                    }
                    case '\"': {
                        t = "&quot;";
                        break;
                    }
                    default: {
                        buf.append(c);
                        break block8;
                    }
                }
                buf.append(t);
            }
            ++i;
        }
        return buf;
    }

    static String htmlspecialchars(String t) {
        return new String(WikiEngine.q(new StringBuffer(80), t));
    }

    private char c0(Object a) {
        if (a == null) {
            return '\u0000';
        }
        String t = a.toString();
        return t.length() == 0 ? (char)'\u0000' : t.charAt(0);
    }

    static boolean xeq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    static boolean xeq(int a, int b, Map bag) {
        return a == b || WikiEngine.xeq(bag.get(new Integer(a)), bag.get(new Integer(b)));
    }

    String convertHtml(String src) {
        int content_id_local = this.content_id++;
        long start_mtime = System.currentTimeMillis();
        src = this.normalize(src);
        ArrayList<Object> result = new ArrayList<Object>();
        LinkedList<Object> saved = new LinkedList<Object>();
        ArrayList result_last = new ArrayList();
        ArrayList<String> arycontents = new ArrayList<String>();
        src = this.preg.substitute("s/^#freeze\n//gm", src);
        String[] lines = this.explode('\n', src);
        HashMap<Integer, String> headform = new HashMap<Integer, String>();
        int _cnt = 0;
        boolean _p = false;
        boolean _bq = false;
        int table = 0;
        int level = 0;
        int content_count = 0;
        this.top_link = "";
        if (this.preg.match("/#contents/", src)) {
            this.top_link = "<a href='#contents_" + content_id_local + "'>" + this.top + "</a>";
        }
        int i = 0;
        while (i < lines.length) {
            char line_head;
            String line = lines[i];
            String comment_out = "";
            if (this.preg.match("/^\\/\\/(.*)/", line)) {
                comment_out = this.preg.group(1);
            } else if (!(table == 0 || this.preg.match("/^\\|(.+)\\|$/", line) && table == this.explode('|', this.preg.group(1)).length)) {
                table = 0;
                result.add("</table></div>");
            }
            char c = line_head = line.length() > 0 ? line.charAt(0) : (char)'\u0000';
            if (line_head == ' ' || line_head == ':' || line_head == '>' || line_head == '-' || line_head == '+' || line_head == '|' || line_head == '*' || line_head == '#' || !WikiEngine.empty(comment_out)) {
                String out1;
                if ("".equals(headform.get(new Integer(_cnt - 1))) && _p) {
                    result.add("</p>");
                    _p = false;
                }
                if (line_head != '>' && _bq) {
                    result.add("</p>");
                    _bq = false;
                }
                if (this.preg.match("/^\\#([^\\(]+)(.*)$/", line)) {
                    String plugin = this.preg.group(1);
                    String args = this.preg.group(2);
                    log.debug((Object)("plugin #" + plugin));
                    if (this.exist_plugin_convert(plugin)) {
                        result.addAll(saved);
                        saved.clear();
                        String _plugin = !WikiEngine.empty(args) ? this.substitute(this.ph, line) : this.substitute(this.phNoArg, line);
                        result.add("\t" + _plugin);
                    } else {
                        log.debug((Object)("no plugin #" + plugin));
                        result.add(WikiEngine.htmlspecialchars(line));
                    }
                } else if (this.preg.match("/^(\\*{1,3})(.*)/", line)) {
                    result.addAll(saved);
                    saved.clear();
                    out1 = this.preg.group(1);
                    String out2 = this.preg.group(2);
                    headform.put(new Integer(_cnt), out1);
                    String str = this.inline(out2, false);
                    level = out1.length() + 1;
                    result.add("<h" + level + "><a name='content_" + content_id_local + "_" + content_count + "'></a>" + str + " " + this.top_link + "</h" + level + ">");
                    arycontents.add(String.valueOf(this.strRepeat("-", level - 1)) + "<a href='#content_" + content_id_local + "_" + content_count + "'>" + this.stripHtmlTag(this.makeUserRules(this.inline(out2, true))) + "</a>\n");
                    ++content_count;
                } else if (this.preg.match("/^(-{1,4})(.*)/", line)) {
                    out1 = this.preg.group(1);
                    String out2 = this.preg.group(2);
                    headform.put(new Integer(_cnt), out1);
                    if (out1.length() == 4) {
                        result.addAll(saved);
                        saved.clear();
                        result.add(this.hr);
                    } else {
                        this.listPush(result, saved, "ul", out1.length());
                        result.add("<li>" + this.inline(out2, false));
                    }
                } else if (this.preg.match("/^(\\+{1,3})(.*)/", line)) {
                    out1 = this.preg.group(1);
                    String out2 = this.preg.group(2);
                    headform.put(new Integer(_cnt), out1);
                    this.listPush(result, saved, "ol", out1.length());
                    result.add("<li>" + this.inline(out2, false));
                } else if (this.preg.match("/^:([^:]+):(.*)/", line)) {
                    out1 = this.preg.group(1);
                    String out2 = this.preg.group(2);
                    headform.put(new Integer(_cnt), ":" + out1 + ":");
                    this.backPush(result, saved, "dl", 1);
                    result.add("<dt>" + this.inline(out1, false) + "</dt>");
                    result.add("<dd>" + this.inline(out2, false) + "</dd>");
                } else if (this.preg.match("/^(>{1,3})(.*)/", line)) {
                    out1 = this.preg.group(1);
                    String out2 = this.preg.group(2);
                    headform.put(new Integer(_cnt), out1);
                    this.backPush(result, saved, "blockquote", out1.length());
                    if (!WikiEngine.xeq(_cnt, _cnt - 1, headform)) {
                        if (!_bq) {
                            result.add("<p class=\"quotation\">");
                            _bq = true;
                        } else {
                            Object cntL1 = headform.get(new Integer(_cnt - 1));
                            if (this.c0(cntL1) == '>') {
                                Object a;
                                int _level_diff = Math.abs(out1.length() - this.nvl(cntL1).length());
                                if (_level_diff == 1) {
                                    a = this.arrayPop(result);
                                    result.add("</p>");
                                    result.add(a);
                                    result.add("<p class=\"quotation\">");
                                    _bq = true;
                                } else {
                                    a = this.arrayPop(result);
                                    Object b = this.arrayPop(result);
                                    result.add("</p>");
                                    result.add(a);
                                    result.add(b);
                                    result.add("<p class=\"quotation\">");
                                    _bq = true;
                                }
                            }
                        }
                    }
                    result.add(this.ltrim(this.inline(out2, false)));
                } else if (this.preg.match("/^(\\s+.*)/", line)) {
                    headform.put(new Integer(_cnt), " ");
                    this.backPush(result, saved, "pre", 1);
                    result.add(WikiEngine.htmlspecialchars(this.preg.group(1)));
                } else if (this.preg.match("/^\\|(.+)\\|$/", line)) {
                    headform.put(new Integer(_cnt), "|");
                    String[] arytable = this.explode('|', this.preg.group(1));
                    if (table == 0) {
                        result.addAll(saved);
                        saved.clear();
                        result.add("<div class='ie5'><table class='style_table' cellspacing='1' border='0'>");
                        table = arytable.length;
                    }
                    result.add("<tr>");
                    int j = 0;
                    while (j < arytable.length) {
                        String td = arytable[j];
                        String style = "";
                        if (this.preg.match("/^(LEFT|CENTER|RIGHT):(.*)$/", td)) {
                            style = " align='" + this.preg.group(1).toLowerCase() + "'";
                            td = this.preg.group(2);
                        }
                        result.add("<td class='style_td'" + style + ">");
                        result.add(this.ltrim(this.inline(td, false)));
                        result.add("</td>");
                        ++j;
                    }
                    result.add("</tr>");
                } else if (!WikiEngine.empty(comment_out)) {
                    headform.put(new Integer(_cnt), "//");
                    result.add(" <!-- " + WikiEngine.htmlspecialchars(comment_out) + " -->");
                }
            } else {
                headform.put(new Integer(_cnt), "");
                if (!"".equals(headform.get(new Integer(_cnt - 1)))) {
                    if (!saved.isEmpty()) {
                        if (_bq) {
                            saved.add(0, "</p>");
                            _bq = false;
                        }
                        Object t = this.arrayPop(saved);
                        saved.add(t);
                        result.addAll(saved);
                        saved.clear();
                    }
                    if (line.length() == 0 && !_p) {
                        result.add("<p>");
                        _p = true;
                    } else if (line.length() > 0 && _p) {
                        result.add("</p>");
                        _p = false;
                    }
                }
                if (this.preg.match("/^(LEFT|CENTER|RIGHT):(.*)$/", line)) {
                    if (_p) {
                        result.add("</p>");
                    }
                    String p1 = this.preg.group(1);
                    String p2 = this.preg.group(2);
                    result.add("<div class='p_" + p1.toLowerCase() + "'>");
                    result.add(this.inline(p2, false));
                    result.add("</div>");
                    line = "";
                    _p = false;
                }
                if (line.length() == 0 && _p) {
                    Object _tmp = this.arrayPop(result);
                    if ("<p>".equals(_tmp)) {
                        _tmp = "<p class='empty'>";
                    }
                    result.add(_tmp);
                    result.add("</p>");
                    _p = false;
                } else if (line.length() > 0 && !_p) {
                    result.add("<p>");
                    _p = true;
                }
                if (line.length() > 0) {
                    result.add(this.inline(line, false));
                }
            }
            ++_cnt;
            ++i;
        }
        if (_p) {
            result.add("</p>");
        }
        if (_bq) {
            result.add("</p>");
        }
        if (table > 0) {
            result.add("</table></div>");
        }
        result.addAll(saved);
        saved.clear();
        result_last = result;
        String contents = "";
        if (content_count != 0) {
            result = new ArrayList();
            Iterator iter = ((AbstractList)arycontents).iterator();
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if (!this.preg.match("/^(-{1,3})(.*)/", line)) continue;
                String out1 = this.preg.group(1);
                String out2 = this.preg.group(2);
                this.listPush(result, saved, "ul", out1.length());
                result.add("<li>" + out2);
            }
            result.addAll(saved);
            saved.clear();
            contents = "<a name=\"contents_" + content_id_local + "\"></a>\n" + WikiEngine.join("\n", result.toArray());
            if (this.strip_link_wall) {
                contents = this.preg.substitute("s/\\[\\[([^\\]:]+):(.+)\\]\\]/$1/g", contents);
                contents = this.preg.substitute("s/\\[\\[([^\\]]+)\\]\\]/$1/g", contents);
            }
        }
        Object[] r2 = this.inline2(result_last).toArray(EMPTY_VALUES);
        int i2 = 0;
        while (i2 < r2.length) {
            if (((String)r2[i2]).equals("#contents")) {
                r2[i2] = contents;
            }
            ++i2;
        }
        return WikiEngine.join("\n", r2);
    }

    private String nvl(Object t) {
        return t == null ? "" : t.toString();
    }

    String ltrim(String t) {
        return this.preg.substitute("s/^\\s+//", t);
    }

    String rtrim(String t) {
        return this.preg.substitute("s/\\s+$//", t);
    }

    String strRepeat(String t, int cnt) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cnt) {
            buf.append(t);
            ++i;
        }
        return new String(buf);
    }

    Object arrayPop(List a) {
        if (a == null || a.isEmpty()) {
            return null;
        }
        return a.remove(a.size() - 1);
    }

    String inline(String t, boolean removeFlag) {
        if (removeFlag) {
            return this.preg.substitute("s/\\(\\(((?:(?!\\)\\)).)*)\\)\\)//gx", WikiEngine.htmlspecialchars(t));
        }
        StringBuffer buf = new StringBuffer();
        PatternMatcherInput input = new PatternMatcherInput(WikiEngine.htmlspecialchars(t));
        try {
            if (this.noteHelper == null) {
                this.noteHelper = new MakeNote();
            }
            this.substitute(buf, this.noteHelper, input);
        }
        catch (MalformedPatternException e) {
            log.warn((Object)e.getMessage());
        }
        return new String(buf);
    }

    List inline2(List str) {
        ArrayList<Integer> cnts_plain = new ArrayList<Integer>();
        ArrayList<String> arykeep = new ArrayList<String>(str);
        int cnt = 0;
        int n = str.size();
        while (cnt < n) {
            String t = (String)str.get(cnt);
            if (!this.preg.match("/^(\\s)/", t)) {
                arykeep.set(cnt, "");
            } else {
                cnts_plain.add(new Integer(cnt));
                str.set(cnt, "");
            }
            ++cnt;
        }
        str = this.makeLink(str);
        str = this.makeUserRules(str);
        Iterator iter = ((AbstractList)cnts_plain).iterator();
        while (iter.hasNext()) {
            Integer idx = (Integer)iter.next();
            str.set(idx, arykeep.get(idx));
        }
        return str;
    }

    String getFootNoteText() {
        if (this.foot_explain.isEmpty()) {
            return "";
        }
        return "\n" + this.note_hr + "\n" + WikiEngine.join("\n", this.inline2(this.foot_explain).toArray());
    }

    static StringBuffer replace(StringBuffer buf, String from, String to) {
        if (buf == null || from == null) {
            return buf;
        }
        if (to == null) {
            to = "";
        }
        int pos = 0;
        int len = from.length();
        int to_len = to.length();
        while ((pos = buf.toString().indexOf(from, pos)) >= 0) {
            buf.replace(pos, pos + len, to);
            pos += to_len;
        }
        return buf;
    }

    String strReplace(String a, String b, String t) {
        if (t == null) {
            return t;
        }
        return new String(WikiEngine.replace(new StringBuffer(t), a, b));
    }

    String[] explode1(String sep, String text) {
        StringTokenizer tk = new StringTokenizer(text, sep);
        ArrayList<String> a = new ArrayList<String>();
        while (tk.hasMoreTokens()) {
            a.add(tk.nextToken());
        }
        return a.toArray(EMPTY_VALUES);
    }

    String[] explode(char sep, String text) {
        int p;
        if (text == null || text.length() == 0) {
            return EMPTY_VALUES;
        }
        ArrayList<String> a = new ArrayList<String>();
        int p1 = 0;
        while ((p = text.indexOf(sep, p1)) >= 0) {
            a.add(text.substring(p1, p));
            p1 = p + 1;
        }
        a.add(text.substring(p1));
        return a.toArray(EMPTY_VALUES);
    }

    void backPush(List result, List saved, String tag, int level) {
        while (saved.size() > level) {
            result.add(saved.remove(0));
        }
        if (!saved.isEmpty() && !("</" + tag + ">").equals(saved.get(0))) {
            result.addAll(saved);
            saved.clear();
        }
        while (saved.size() < level) {
            saved.add(0, "</" + tag + ">");
            result.add("<" + tag + ">");
        }
    }

    void listPush(List result, List saved, String tag, int level) {
        boolean cont = true;
        String close = "</li></" + tag + ">";
        while (saved.size() > level || !saved.isEmpty() && !close.equals(saved.get(0))) {
            result.add(saved.remove(0));
        }
        int margin = level - saved.size();
        while (saved.size() < level - 1) {
            saved.add(0, "");
        }
        if (saved.size() < level) {
            cont = false;
            saved.add(0, close);
            int left = margin * this._list_margin;
            if (level == margin) {
                left += this._list_left_margin;
            }
            result.add("<" + tag + " class='list" + level + "' style='padding-left:" + left + "px;margin-left:" + left + "px'>");
        }
        if (cont) {
            result.add("</li>");
        }
    }

    static String join(String del, Object[] a) {
        return new String(WikiEngine.join(new StringBuffer(), del, a));
    }

    static StringBuffer join(StringBuffer buf, String del, Object[] a) {
        if (buf == null || a == null) {
            return buf;
        }
        if (del == null) {
            del = "";
        }
        String t = "";
        int i = 0;
        while (i < a.length) {
            buf.append(t).append(a[i]);
            t = del;
            ++i;
        }
        return buf;
    }

    File changeDataDir(File dataDir) {
        File last = this.xdataDir;
        this.xdataDir = dataDir;
        return last;
    }

    File getDataDir(String subName) {
        File sub = new File(this.getDataDir(), subName);
        if (!sub.isDirectory() && !sub.mkdirs()) {
            throw new RuntimeException("can't create subDir:" + sub);
        }
        return sub;
    }

    File getDataDir() {
        if (!this.xdataDir.isDirectory()) {
            if (!this.xdataDir.mkdirs()) {
                throw new RuntimeException("can't create dataDir:" + this.xdataDir);
            }
            try {
                new FileWriter(new File(this.xdataDir, ".wiki")).close();
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }
        return this.xdataDir;
    }

    File getFileName(String pageName) {
        return new File(this.getDataDir(), String.valueOf(pageName) + ".txt");
    }

    boolean pageExist(String page) {
        return this.getFileName(this.encode(page)).exists();
    }

    String[] getSource(String page) {
        return this.file(this.getFileName(this.encode(page)));
    }

    String getSourceText(String page) {
        return WikiEngine.join("\n", this.getSource(page));
    }

    String[] file(File name) {
        if (!name.exists()) {
            return EMPTY_VALUES;
        }
        try {
            return this.file(new InputStreamReader((InputStream)new FileInputStream(name), EUCEncoding));
        }
        catch (IOException e) {
            return EMPTY_VALUES;
        }
    }

    String[] file(Reader in) throws IOException {
        ArrayList<String> a = new ArrayList<String>();
        BufferedReader in1 = new BufferedReader(in);
        try {
            String text;
            while ((text = in1.readLine()) != null) {
                a.add(text);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            in1.close();
            throw throwable;
        }
        Object var5_7 = null;
        in1.close();
        return a.toArray(EMPTY_VALUES);
    }

    String[] getExistPages() {
        ArrayList<String> a = new ArrayList<String>();
        String[] list = this.getDataDir().list();
        int i = 0;
        while (i < list.length) {
            String t = list[i];
            if (!t.equals("..") && !t.equals(".") && t.indexOf(".txt") >= 0) {
                String page = this.decode(this.preg.substitute("s/\\.txt$/ /", t).trim());
                a.add(page);
            }
            ++i;
        }
        return a.toArray(EMPTY_VALUES);
    }

    boolean isPage(String page) {
        return this.isPage(page, false);
    }

    boolean isPage(String page, boolean reload) {
        if (this._isPage.containsKey(page) && !reload) {
            return (Boolean)this._isPage.get(page);
        }
        boolean result = false;
        if (!this.preg.match("/" + this.interWikiName + "/", page)) {
            result = this.pageExist(page);
        }
        this._isPage.put(page, result);
        return result;
    }

    boolean isFreeze(String page) {
        if (!this.isPage(page)) {
            return false;
        }
        if (this._isFreeze != null) {
            return this._isFreeze;
        }
        String[] lines = this.getSource(page);
        boolean result = lines.length > 0 && "#freeze".equals(lines[0]);
        this._isFreeze = result;
        log.debug((Object)("isFreeze: " + this._isFreeze));
        return result;
    }

    String getPgPassage(String page, boolean detailFlag) {
        if (!this.show_passage) {
            return "";
        }
        String res = (String)this._pg_passage.get(page);
        if (!this._pg_passage.containsKey(page)) {
            long pgdt = this.getFileName(this.encode(page)).lastModified();
            pgdt = (this.now.getTime() - pgdt) / 1000L;
            res = pgdt / 60L < 60L ? "(" + pgdt / 60L + "m)" : (pgdt / 60L / 60L < 24L ? "(" + pgdt / 60L / 60L + "h)" : "(" + pgdt / 60L / 60L / 24L + "d)");
            this._pg_passage.put(page, res);
        }
        if (WikiEngine.empty(res)) {
            return "";
        }
        return detailFlag ? "<small>" + res + "</small>" : res;
    }

    void putLastmodified() throws IOException {
        String[] files = this.getExistPages();
        HashMap<Long, String> putval = new HashMap<Long, String>();
        int mk = 0;
        int i = 0;
        while (i < files.length) {
            String page = files[i];
            if (!page.equals(this.whatsnew) && !this.preg.match("/" + this.non_list + "/", page)) {
                String page_url = this.urlEncode(page);
                long lastMod = this.getFileName(this.encode(page)).lastModified() / 1000L * 1000L;
                Object[] opt = new Object[]{new Date(lastMod)};
                if (putval.containsKey(new Long(lastMod))) {
                    lastMod += (long)mk++;
                }
                putval.put(new Long(lastMod), String.valueOf(MessageFormat.format("-{0,date,yyyy-MM-dd (E) hh:mm:ss} - ", opt)) + page);
            }
            ++i;
        }
        int cnt = 0;
        ArrayList sortedKey = new ArrayList(putval.keySet());
        Collections.sort(sortedKey);
        PrintWriter out = this.getWriter(this.whatsnew);
        try {
            int n = sortedKey.size() - 1;
            while (n >= 0) {
                if (cnt++ < this.maxshow) {
                    out.println(putval.get(sortedKey.get(n)));
                    --n;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (out.checkError()) {
                log.warn((Object)("error occured while wrote " + this.whatsnew));
            }
            out.close();
            throw throwable;
        }
        Object var8_12 = null;
        if (out.checkError()) {
            log.warn((Object)("error occured while wrote " + this.whatsnew));
        }
        out.close();
    }

    PrintWriter getWriter(String name) throws IOException {
        File target = this.getFileName(this.encode(name));
        log.debug((Object)("wirter for " + name + ":" + target));
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), EUCEncoding)));
    }

    String urlEncode(String t) {
        if (this.useRawUrlEncode) {
            return WikiEngine.rawurlencode(t, EUCEncoding);
        }
        return this.strReplace("%", "_", WikiEngine.rawurlencode(t, EUCEncoding));
    }

    String urlDecode(String t) {
        if (this.useRawUrlEncode) {
            return t;
        }
        return WikiEngine.rawurldecode(this.strReplace("_", "%", t), EUCEncoding);
    }

    String urlDecodeForce(String t) {
        try {
            if (this.useRawUrlEncode) {
                WikiEngine.rawurldecode(t, EUCEncoding);
            }
            return WikiEngine.rawurldecode(this.strReplace("_", "%", t), EUCEncoding);
        }
        catch (IllegalArgumentException ignored) {
            log.debug((Object)ignored);
            return t;
        }
    }

    static String rawurlencode(String t, String encodingName) {
        if (WikiEngine.empty(t)) {
            return t;
        }
        try {
            return URLEncoder.encode(t, encodingName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    static String rawurldecode(String t, String encodingName) {
        if (WikiEngine.empty(t)) {
            return t;
        }
        try {
            return URLDecoder.decode(t, encodingName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void fileWrite(File folder, String page, String text, boolean noTimestamp) {
        File target = new File(folder, String.valueOf(this.encode(page)) + ".txt");
        if (WikiEngine.empty(text)) {
            target.delete();
            log.debug((Object)(String.valueOf(page) + "(" + target + ") removed."));
            return;
        }
        Long timestamp = null;
        try {
            if (noTimestamp && this.isPage(page)) {
                timestamp = new Long(target.lastModified());
            }
            this.fileWrite1(new FileOutputStream(target), text);
            log.debug((Object)(String.valueOf(page) + "(" + target + ") wrote."));
            if (timestamp == null) {
                this.putLastmodified();
            } else if (!target.setLastModified(timestamp)) {
                log.warn((Object)(target + " #setLastModified failed."));
            }
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
    }

    private void fileWrite1(OutputStream out, String text) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, EUCEncoding);
        try {
            writer.write(text);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((Writer)writer).close();
            throw throwable;
        }
        Object var4_6 = null;
        ((Writer)writer).close();
    }

    Map openInterwikinameList() {
        HashMap<String, InterWiki> p = new HashMap<String, InterWiki>();
        String[] lines = this.getSource(this.interwiki);
        int i = 0;
        while (i < lines.length) {
            if (this.preg.match("/\\[((https?|ftp|news)(\\:\\/\\/[\\w\\+\\$\\;\\?\\.%,!#~\\*\\/\\:@&=_\\-]+))\\s([^\\]]+)\\]\\s?([^\\s]*)/", lines[i])) {
                p.put(this.preg.group(4), new InterWiki(this.preg.group(1), this.preg.group(5)));
            }
            ++i;
        }
        return p;
    }

    boolean exist_plugin_action(String plugin) {
        if (WikiEngine.empty(plugin)) {
            return false;
        }
        return pluginMap.containsKey(plugin);
    }

    boolean exist_plugin_convert(String plugin) {
        return pluginMap.containsKey(plugin);
    }

    Plugin getPluginInstance(String pluginName) throws InstantiationException, IllegalAccessException {
        Class cz;
        Plugin p = (Plugin)this.pluginInstanceMap.get(pluginName);
        if (p == null && (cz = (Class)pluginMap.get(pluginName)) != null) {
            p = (Plugin)cz.newInstance();
            ServletContext con = null;
            if (this.request != null) {
                con = (ServletContext)this.request.getAttribute("wiki.ServletContext");
            }
            p.init(con);
            this.pluginInstanceMap.put(pluginName, p);
        }
        return p;
    }

    Map do_plugin_action(String pluginName) {
        log.debug((Object)(String.valueOf(pluginName) + " action call."));
        Exception failed = null;
        try {
            Plugin p = this.getPluginInstance(pluginName);
            if (p != null) {
                return p.action(this);
            }
        }
        catch (InstantiationException e) {
            failed = e;
        }
        catch (IllegalAccessException e) {
            failed = e;
        }
        catch (WikiServlet.Redirect e) {
            throw e;
        }
        catch (RuntimeException e) {
            failed = e;
        }
        log.warn((Object)("while processing #" + pluginName), (Throwable)failed);
        return Collections.EMPTY_MAP;
    }

    Folder.FileItem getFileItem(String name) {
        return (Folder.FileItem)this.request.getAttribute(name);
    }

    String do_plugin_convert(String pluginName, String[] args) {
        log.debug((Object)(String.valueOf(pluginName) + " called." + Arrays.asList(args)));
        Exception failed = null;
        try {
            Plugin p = this.getPluginInstance(pluginName);
            if (p != null) {
                return p.convert(this, args);
            }
        }
        catch (InstantiationException e) {
            failed = e;
        }
        catch (IllegalAccessException e) {
            failed = e;
        }
        catch (RuntimeException e) {
            failed = e;
        }
        log.warn((Object)("while processing #" + pluginName + Arrays.asList(args)), (Throwable)failed);
        return "#" + pluginName + Arrays.asList(args);
    }

    List listSort(Map a) {
        ArrayList keys = new ArrayList(a.keySet());
        ArrayList values = new ArrayList();
        Collections.sort(keys);
        Iterator iter = ((AbstractList)keys).iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            values.add(a.get(key));
        }
        return values;
    }

    String getList(boolean withfilename) {
        HashMap<String, String> retval1 = new HashMap<String, String>();
        String[] files = this.getExistPages();
        int i = 0;
        while (i < files.length) {
            String page = files[i];
            if (!(this.preg.match("/" + this.non_list + "/", page) && !withfilename || page.equals(this.whatsnew))) {
                String page_url = this.urlEncode(page);
                String page2 = this.stripBracket(page);
                String pg_passage = this.getPgPassage(page, true);
                StringBuffer buf = new StringBuffer();
                buf.append("<li><a href='").append(this.script).append("?").append(page_url).append("'>").append(WikiEngine.htmlspecialchars(page2)).append("</a>").append(pg_passage);
                if (withfilename) {
                    buf.append("<ul><li>").append(this.encode(page)).append(".txt</li></ul>\n");
                }
                buf.append("</li>\n");
                retval1.put(page2, buf.toString());
            }
            ++i;
        }
        List retval = this.listSort(retval1);
        if (!this.list_index) {
            this.top_link = "<ul>";
            retval.add(0, this.top_link);
        }
        return String.valueOf(WikiEngine.join("", retval.toArray())) + "</ul>";
    }

    static String md5(byte[] t) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(t);
            return WikiEngine.hexCode(md.digest());
        }
        catch (NoSuchAlgorithmException ignored) {
            throw new RuntimeException(ignored.getMessage());
        }
    }

    static String md5(String[] t) {
        try {
            return WikiEngine.md5(WikiEngine.join("", t).getBytes(EUCEncoding));
        }
        catch (UnsupportedEncodingException ignored) {
            log.error((Object)ignored.getMessage());
            return "unkown";
        }
    }

    String catrule() {
        if (!WikiEngine.empty(rule_body)) {
            return rule_body;
        }
        try {
            rule_body = WikiEngine.join("", this.file(new InputStreamReader(this.getClass().getResourceAsStream("help.html"), EUCEncoding)));
        }
        catch (IOException e) {
            return "(no help text.)";
        }
        return rule_body;
    }

    Map doSearch(String word, int type, boolean nonFormat, String page) {
        int cnt = 0;
        String[] pages = this.getExistPages();
        String[] arywords = this.preg.split(word).toArray(EMPTY_VALUES);
        String iword = word.toLowerCase();
        HashMap<Object, String> retval = new HashMap<Object, String>();
        int i = 0;
        while (i < pages.length) {
            block11: {
                String name;
                block13: {
                    String line;
                    block12: {
                        name = pages[i];
                        if (name.equals(this.whatsnew) || name.equals(page) && nonFormat) break block11;
                        ++cnt;
                        line = this.getSourceText(name).toLowerCase();
                        if (arywords.length <= 1) break block12;
                        boolean hit = false;
                        int j = 0;
                        while (j < arywords.length) {
                            String key = arywords[j];
                            if (type == 0) {
                                if (line.indexOf(key) < 0) {
                                    hit = false;
                                    break;
                                }
                                hit = true;
                            } else if (type == 1 && (line.indexOf(key) >= 0 || name.toLowerCase().indexOf(key) >= 0)) {
                                hit = true;
                            }
                            ++j;
                        }
                        if (hit) break block13;
                        break block11;
                    }
                    if (name.toLowerCase().indexOf(iword) < 0 && line.indexOf(iword) < 0) break block11;
                }
                String page_url = this.urlEncode(name);
                String word_url = this.urlEncode(word);
                String name2 = this.stripBracket(name);
                String link_tag = "<a href='" + this.script + "?" + page_url + "'>" + WikiEngine.htmlspecialchars(name2) + "</a>" + this.getPgPassage(name, false);
                if (nonFormat) {
                    long tm = this.getFileName(this.encode(name)).lastModified();
                    retval.put(new Long(tm), link_tag);
                } else {
                    retval.put(name2, "<li>" + link_tag + "</li>");
                }
            }
            ++i;
        }
        this.searchCount = cnt;
        return retval;
    }

    String autoTemplate(String page) {
        if (!this.auto_template_func) {
            return "";
        }
        String body = "";
        Iterator iter = this.auto_template_rules.keySet().iterator();
        if (iter.hasNext()) {
            String rule = (String)iter.next();
            String template = (String)this.auto_template_rules.get(rule);
            if (this.preg.match("m#" + rule + "#", page)) {
                MatchResult match = this.preg.getMatch();
                String template_page = this.preg.substitute("s#" + rule + "#" + template + "#g", page);
                body = this.getSourceText(template_page);
                log.debug((Object)("match length:" + match.length()));
                int i = 0;
                int n = match.length();
                while (i < n) {
                    String t = match.group(i);
                    if (WikiEngine.empty(t)) {
                        t = "";
                    }
                    body = this.strReplace("$" + i, match.group(i), body);
                    ++i;
                }
            }
        }
        return body;
    }

    String[] backup_file(File filename) throws IOException {
        return this.file(new InputStreamReader((InputStream)new FileInputStream(filename), EUCEncoding));
    }

    void backup_delete(File filename) throws IOException {
        if (!filename.delete()) {
            log.warn((Object)(filename + " not removed."));
        }
    }

    PrintWriter backup_getWriter(File filename) throws IOException {
        log.debug((Object)("wirter for " + filename));
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), EUCEncoding)));
    }

    String do_diff(String[] src1, String[] src2, boolean asViewText) {
        if (this.diffTool == null) {
            this.diffTool = new DiffTool();
        }
        Object[] diffdata = this.diffTool.diffText(src1, src2);
        if (asViewText) {
            this.diffAttr((String[])diffdata);
        }
        return WikiEngine.join("\n", diffdata);
    }

    String update_diff(String[] src1, String[] src2) {
        if (this.diffTool == null) {
            this.diffTool = new DiffTool();
        }
        Object[] diffdata = this.diffTool.diffText(src1, src2);
        int i = 0;
        while (i < diffdata.length) {
            Object t = diffdata[i];
            if (((String)t).startsWith("  ")) {
                diffdata[i] = ((String)t).substring(2);
            }
            ++i;
        }
        return WikiEngine.join("\n", diffdata);
    }

    File getDiffFile(String page) {
        return new File(this.getDataDir("diff"), String.valueOf(this.encode(page)) + ".txt");
    }

    void diffAttr(String[] diffdata) {
        int i = 0;
        while (i < diffdata.length) {
            String t = WikiEngine.htmlspecialchars(diffdata[i]);
            t = this.preg.substitute("s#^(\\-)(.*)#<span class=\"diff_removed\"> $2</span>#", t);
            diffdata[i] = this.preg.substitute("s#^(\\+)(.*)#<span class=\"diff_added\"> $2</span>#", t);
            ++i;
        }
    }

    String[] get_backup(String filename, int age) throws IOException {
        List a = this.read_backup(filename);
        if (--age < 0 || age > a.size()) {
            return EMPTY_VALUES;
        }
        return ((WikiText)a.get((int)age)).lines.toArray(EMPTY_VALUES);
    }

    List get_backup_info(String filename, boolean hold) throws IOException {
        File bkname = new File(this.getDataDir("backup"), filename);
        String[] lines = this.backup_file(bkname);
        if (lines == null || lines.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WikiText> res = new ArrayList<WikiText>();
        WikiText a = null;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (this.preg.match("/^" + this.splitter + "\\s+(\\d+)$/", line)) {
                a = new WikiText();
                a.timestamp = Long.parseLong(this.preg.group(1));
                res.add(a);
                if (!hold) {
                    a = null;
                }
            } else if (a != null) {
                a.lines.add(line);
            }
            ++i;
        }
        return res;
    }

    List read_backup(String filename) throws IOException {
        return this.get_backup_info(filename, true);
    }

    void make_backup(String filename, String body, long oldtime) throws IOException {
        if (WikiEngine.empty(body)) {
            log.debug((Object)"empty body.");
            return;
        }
        File bkname = new File(this.getDataDir("backup"), filename);
        log.debug((Object)bkname);
        List outL = Collections.EMPTY_LIST;
        if (bkname.exists()) {
            if (this.now.getTime() / 1000L - bkname.lastModified() / 1000L <= (long)(3600 * this.cycle)) {
                log.debug((Object)"\u66f4\u65b0\u9593\u9694\u304c\u77ed\u3044\u306e\u3067\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306e\u5bfe\u8c61\u306b\u3057\u306a\u3044\u3002");
                return;
            }
            outL = this.read_backup(filename);
            if (outL.size() > this.maxage) {
                outL.remove(0);
            }
        }
        PrintWriter out = this.backup_getWriter(bkname);
        try {
            Iterator iter = outL.iterator();
            while (iter.hasNext()) {
                WikiText a = (WikiText)iter.next();
                out.print(this.splitter);
                out.print(" ");
                out.println(a.timestamp);
                int i = 0;
                int n = a.lines.size();
                while (i < n) {
                    out.println(a.lines.get(i));
                    ++i;
                }
            }
            out.print(this.splitter);
            out.print(" ");
            out.println(oldtime);
            out.print(body);
            if (this.lastChar(body) != '\n') {
                out.println();
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (out.checkError()) {
                log.warn((Object)(bkname + " out failed."));
            }
            out.close();
            throw throwable;
        }
        Object var12_13 = null;
        if (out.checkError()) {
            log.warn((Object)(bkname + " out failed."));
        }
        out.close();
    }

    private char lastChar(String t) {
        return t.charAt(t.length() - 1);
    }

    String get_backup_list(String page) throws IOException {
        if (WikiEngine.empty(page)) {
            return this.get_backup_list();
        }
        StringBuffer buf = new StringBuffer(500);
        buf.append("<ul><li><a href=\"").append(this.script).append("?cmd=backup\">").append(this._("msg_backuplist")).append("</a>\n");
        String page_url = this.urlEncode(page);
        List info = this.get_backup_info(String.valueOf(this.encode(page)) + ".txt", false);
        if (!info.isEmpty()) {
            buf.append("<ul>");
        }
        int j = 0;
        int m = info.size();
        while (j < m) {
            WikiText wt = (WikiText)info.get(j);
            int age = j + 1;
            buf.append("<li><a href=\"").append(this.script).append("?cmd=backup&amp;page=").append(page_url).append("&amp;age=").append(age).append("\">").append(age).append(' ').append(wt.getTimeStamp()).append("</a> [<a href=\"").append(this.script).append("?cmd=backup_diff&amp;page=").append(page_url).append("&amp;age=").append(age).append("\">").append(this._("msg_diff")).append("</a> | <a href=\"").append(this.script).append("?cmd=backup_nowdiff&amp;page=").append(page_url).append("&amp;age=").append(age).append("\">").append(this._("msg_nowdiff")).append("</a> | <a href=\"").append(this.script).append("?cmd=backup_source&amp;page=").append(page_url).append("&amp;age=").append(age).append("\">").append(this._("msg_source")).append("</a> ]</li>\n");
            ++j;
        }
        if (!info.isEmpty()) {
            buf.append("</ul>");
        }
        buf.append("</ul>\n");
        return new String(buf);
    }

    String get_backup_list() throws IOException {
        HashMap<String, BkWiki> p = new HashMap<String, BkWiki>();
        File bk = this.getDataDir("backup");
        log.debug((Object)(bk + ":backup folder"));
        String[] list = bk.list();
        int i = 0;
        while (i < list.length) {
            String t = list[i];
            if (!t.equals("..") && !t.equals(".") && t.indexOf(".txt") >= 0) {
                String page = this.decode(this.preg.substitute("s/\\.txt$/ /", t).trim());
                String name = this.stripBracket(page);
                String s_name = WikiEngine.htmlspecialchars(name);
                String link = this.isPage(page) ? "\n<li><a href=\"" + this.script + "?" + this.urlEncode(page) + "\">" + s_name + "</a>" : "\n<li>" + s_name;
                p.put(page, new BkWiki(name, link));
            }
            ++i;
        }
        StringBuffer buf = new StringBuffer(500);
        ArrayList keys = new ArrayList(p.keySet());
        Collections.sort(keys);
        String[] keya = keys.toArray(EMPTY_VALUES);
        int i2 = 0;
        while (i2 < keya.length) {
            String page = keya[i2];
            String page_url = this.urlEncode(page);
            List info = this.get_backup_info(String.valueOf(this.encode(page)) + ".txt", false);
            BkWiki bb = (BkWiki)p.get(page);
            buf.append(bb.link);
            if (!info.isEmpty()) {
                buf.append("<ul>");
            }
            int j = 0;
            int m = info.size();
            while (j < m) {
                WikiText wt = (WikiText)info.get(j);
                int age = j + 1;
                buf.append("<li><a href=\"").append(this.script).append("?cmd=backup&amp;page=").append(page_url).append("&amp;age=").append(age).append("\">").append(age).append(' ').append(wt.getTimeStamp()).append("</a></li>\n");
                ++j;
            }
            if (!info.isEmpty()) {
                buf.append("</ul>");
            }
            ++i2;
        }
        return new String(buf);
    }

    boolean backupExist(String page) {
        if (WikiEngine.empty(page)) {
            return false;
        }
        return new File(this.getDataDir("backup"), String.valueOf(this.encode(page)) + ".txt").exists();
    }

    String getDigest(String page) throws IOException {
        return WikiEngine.md5(this.getSource(page));
    }

    File getLockFile(String page) throws IOException {
        File lock = new File(this.getDataDir(), String.valueOf(this.encode(page)) + ".lock");
        int retryCt = 30;
        while (retryCt-- >= 0 && lock.createNewFile()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (retryCt <= 0 && !lock.exists()) {
            throw new IOException("can't lock:" + page);
        }
        return lock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeText(String page, String postdata, String digest, boolean noTimestamp) throws IOException {
        File lock = this.getLockFile(page);
        try {
            String[] oldpagesrc = this.getSource(page);
            if (!WikiEngine.empty(digest) && !(this.savedDigest = WikiEngine.md5(oldpagesrc)).equals(digest)) {
                Object var7_7 = null;
                lock.delete();
                return true;
            }
            this.writeText1(page, postdata, oldpagesrc, noTimestamp);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            lock.delete();
            throw throwable;
        }
        Object var7_9 = null;
        lock.delete();
        return false;
    }

    private void writeText1(String page, String postdata, String[] oldpostdata, boolean noTimestamp) throws IOException {
        long oldposttime;
        postdata = this.userRulesStr(postdata);
        String diffdata = "";
        if (!WikiEngine.empty(postdata)) {
            diffdata = this.do_diff(oldpostdata, this.explode('\n', postdata), false);
        }
        this.fileWrite(this.getDataDir("diff"), page, diffdata, false);
        long l = oldposttime = this.isPage(page) ? this.getFileName(this.encode(page)).lastModified() : this.now.getTime();
        if (this.isPage(page)) {
            this.make_backup(String.valueOf(this.encode(page)) + ".txt", WikiEngine.join("\n", oldpostdata), oldposttime / 1000L);
        }
        this.fileWrite(this.getDataDir(), page, postdata, noTimestamp);
        this.isPage(page, true);
    }

    static abstract class SubstitutionSupport
    implements Substitution {
        Pattern pattern;

        SubstitutionSupport() {
        }

        public void appendSubstitution(StringBuffer buf, MatchResult result, int subCount, PatternMatcherInput input, PatternMatcher matcher, Pattern pattern) {
            this.substitutionHook(buf, result);
        }

        void debugReport(MatchResult r) {
            log.debug((Object)("Match:" + r + ",Length: " + r.length() + ",Groups:" + r.groups() + ",Begin offset:" + r.beginOffset(0) + ",End offset:" + r.endOffset(0)));
            int i = 1;
            int ng = r.groups();
            while (i < ng) {
                log.debug((Object)(String.valueOf(i) + ":" + r.group(i) + ",Begin:" + r.begin(i) + ",End:" + r.end(i)));
                ++i;
            }
        }

        String nvl(String t) {
            return t == null ? "" : t;
        }

        public void appendSubstitution(StringBuffer buf, MatchResult result, int subCount, String arg3, PatternMatcher input, Pattern arg5) {
            this.substitutionHook(buf, result);
        }

        protected abstract void substitutionHook(StringBuffer var1, MatchResult var2);
    }

    class LinkReplace
    extends SubstitutionSupport {
        LinkReplace() throws MalformedPatternException {
            this.pattern = WikiEngine.this.p5c.compile("(?:\\[\\[([^\\]]+):)?(\\[)?((?:https?|ftp|news)(?::\\/\\/[!~*'();\\/?:\\@&=+\\$,%#\\w.-]+))(?:(?:[\\t ]([^\\]]+)\\])|(?:\\]\\]))?|(?:\\[\\[([^\\]]+):)?(\\[)?([\\w.-]+@[\\w-]+\\.[\\w.-]+)(\\]\\])?|(?:\\[\\[(?:([^\\]]+)>)?([^\\]]+)\\]\\])|([A-Z][a-z]+(?:[A-Z][a-z]+)+)", 32);
        }

        protected void substitutionHook(StringBuffer buf, MatchResult result) {
            LinkRef ref = null;
            String t = result.group(3);
            if (!WikiEngine.empty(t)) {
                ref = new URLLink(t, String.valueOf(this.nvl(result.group(1))) + this.nvl(result.group(4)));
            } else {
                t = result.group(7);
                if (!WikiEngine.empty(t)) {
                    ref = new MailToLink(t, result.group(6));
                } else {
                    t = result.group(10);
                    if (!WikiEngine.empty(t)) {
                        ref = t.indexOf(58) > 0 ? new InterWikiLink(t, t) : new WikiNameLink("[[" + t + "]]", "", "", "");
                    } else {
                        t = result.group(11);
                        if (!WikiEngine.empty(t)) {
                            ref = new WikiNameLink(t, "", "", "");
                        }
                    }
                }
            }
            if (ref != null) {
                buf.append(((LinkRef)ref).getText());
            } else {
                if (log.isDebugEnabled()) {
                    this.debugReport(result);
                }
                buf.append(result.group(0));
            }
        }
    }

    private static abstract class LinkRef {
        String name;
        String alias;

        LinkRef() {
        }

        protected abstract String getText();
    }

    private class URLLink
    extends LinkRef {
        String image;
        boolean isImage;

        URLLink(String name, String alias1) {
            this.name = name;
            String string = this.alias = WikiEngine.empty(alias1) ? name : alias1;
            if (WikiEngine.empty(this.alias) && WikiEngine.this.preg.match("/\\.(gif|png|jpeg|jpg)$/i", name)) {
                this.isImage = true;
                this.image = "<img src=\"" + name + "\" border=\"0\" alt=\"" + this.alias + "\">";
            } else if (WikiEngine.this.preg.match("/\\.(gif|png|jpeg|jpg)$/i", this.alias)) {
                this.isImage = true;
                this.image = "<img src=\"" + this.alias + "\" border=\"0\" alt=\"" + name + "\">";
            } else {
                this.isImage = false;
                this.image = "";
            }
        }

        protected String getText() {
            return "<a href=\"" + this.name + "\" target=\"" + WikiEngine.this.link_target + "\">" + (this.isImage ? this.image : this.alias) + "</a>";
        }
    }

    private class MailToLink
    extends LinkRef {
        MailToLink(String name, String alias1) {
            this.name = name;
            this.alias = WikiEngine.empty(this.alias) ? name : this.alias;
        }

        protected String getText() {
            return "<a href=\"mailto:" + this.name + "\">" + this.alias + "</a>";
        }
    }

    private class InterWikiLink
    extends LinkRef {
        String rawname;

        InterWikiLink(String name, String alias) {
            this.name = name;
            this.alias = WikiEngine.empty(alias) ? WikiEngine.this.stripBracket(name) : alias;
            this.rawname = WikiEngine.this.urlEncode(name);
        }

        protected String getText() {
            return "<a href=\"" + WikiEngine.this.script + "?" + this.rawname + "\" target=\"" + WikiEngine.this.interwiki_target + "\">" + this.alias + "</a>";
        }
    }

    private class WikiNameLink
    extends LinkRef {
        String anchor;
        String strip;
        String special;
        String rawname;
        String rawrefer;
        String passage;

        WikiNameLink(String name, String alias1, String anchor, String refer) {
            this.name = name;
            this.alias = WikiEngine.empty(alias1) ? String.valueOf(WikiEngine.this.stripBracket(name)) + anchor : alias1;
            this.anchor = anchor;
            this.strip = WikiEngine.this.stripBracket(name);
            this.special = WikiEngine.htmlspecialchars(this.strip);
            this.rawname = WikiEngine.this.urlEncode(name);
            this.rawrefer = WikiEngine.this.urlEncode(refer);
            if (!name.equals(WikiEngine.this.page) && WikiEngine.this.isPage(name)) {
                WikiEngine.this.related.put("t" + WikiEngine.this.getFileName(WikiEngine.this.encode(name)).lastModified(), "<a href=\"" + WikiEngine.this.script + "?" + this.rawname + "\">" + this.special + "</a>" + this.passage());
            }
        }

        String passage() {
            String p = WikiEngine.this.getPgPassage(this.name, false);
            this.passage = WikiEngine.this.show_passage ? p : "";
            return p;
        }

        String getText(String refer) {
            if (WikiEngine.empty(this.name) && !WikiEngine.empty(this.anchor)) {
                return "<a href=\"" + this.anchor + "\">" + this.alias + "</a>";
            }
            if (WikiEngine.this.isPage(this.name)) {
                return "<a href=\"" + WikiEngine.this.script + "?" + this.rawname + this.anchor + "\" title=\"" + this.special + this.passage + "\">" + this.alias + "</a>";
            }
            String rawrefer = WikiEngine.empty(refer) ? WikiEngine.this.urlEncode(refer) : this.rawrefer;
            return "<span class=\"noexists\">" + this.alias + "<a href=\"" + WikiEngine.this.script + "?cmd=edit&amp;page=" + this.rawname + "&amp;refer=" + rawrefer + "\">?</a></span>";
        }

        protected String getText() {
            return this.getText("");
        }
    }

    public static class Test
    extends TestCase {
        WikiEngine we = new WikiEngine();

        public Test(String t) {
            super(t);
        }

        public void testBackupList() throws Exception {
            this.trace(this.we.get_backup_list(null));
        }

        public void testMakeBackup() throws Exception {
            this.trace(this.we.encode("HogeHoge"));
            this.we.cycle = 0;
            this.we.make_backup(String.valueOf(this.we.encode("HogeHoge")) + ".txt", "HOGEHOGE", this.we.now.getTime() / 1000L);
            Assert.assertTrue((!this.we.read_backup(String.valueOf(this.we.encode("HogeHoge")) + ".txt").isEmpty() ? 1 : 0) != 0);
        }

        public void testReadBackup() throws Exception {
            List a = this.we.read_backup(String.valueOf(this.we.encode("FrontPage")) + ".txt");
            Assert.assertNotNull((Object)a);
            this.xtrace(a);
        }

        public void testDiff() throws Exception {
            DiffTool diff = new DiffTool();
            this.trace(Arrays.asList(diff.diffText(new String[]{"AAA", "BBB", "CCC", "EEE"}, new String[]{"AAA", "CCC", "DDD", "EEE"})));
        }

        public void testRecent() throws Exception {
            this.xtrace(this.we.convertHtml("#recent(30)\n"));
        }

        public void testInterWikiName() throws Exception {
            Assert.assertTrue((boolean)this.we.preg.match("/" + this.we.interWikiName + "/", "  [[aaa:xxx]]"));
        }

        public void testLTrim() throws Exception {
            Assert.assertEquals((String)"ABC", (String)this.we.ltrim("     ABC"));
        }

        public void testGetList() {
            this.xtrace(this.we.getList(false));
        }

        public void testMd5() throws Exception {
            Assert.assertEquals((String)"1a1dc91c907325c69271ddf0c944bc72".toUpperCase(), (String)WikiEngine.md5("pass".getBytes(EUCEncoding)));
        }

        public void testStripBracket() {
            Assert.assertEquals((String)"\u53c2\u8003\u30ea\u30f3\u30af", (String)this.we.stripBracket("[[\u53c2\u8003\u30ea\u30f3\u30af]]"));
            this.we.strip_link_wall = false;
            Assert.assertEquals((String)"[[\u53c2\u8003\u30ea\u30f3\u30af]]", (String)this.we.stripBracket("[[\u53c2\u8003\u30ea\u30f3\u30af]]"));
        }

        public void testOpenInterwikinameList() {
            Map p = this.we.openInterwikinameList();
            Assert.assertNotNull((Object)p);
            this.xtrace(p);
        }

        public void testExplode() {
            Assert.assertEquals(Arrays.asList("AA", "BB", "CC"), Arrays.asList(this.we.explode(':', "AA:BB:CC")));
            Assert.assertEquals(Arrays.asList("AABBCC"), Arrays.asList(this.we.explode(':', "AABBCC")));
        }

        public void testMakeUserRules() {
            this.xtrace(Arrays.asList(this.we.user_rules_reg));
            this.xtrace(this.we.makeUserRules(" XD :) :D :p :d  X( ;)"));
            this.xtrace(this.we.makeUserRules("CENTER: COLOR(ff0000){\u4e2d\u5fc3\uff01}"));
        }

        public void testConvertHtml1() {
            this.xtrace(this.we.convertHtml("*AAA\n**BBB\n***CCC\n****DDD\n\n-aaa\n--bbb\n---ccc\n----ddd\n\n+www\n++xxx\n+++yyy\n++++zzz\n\n\u3042\u3042\u3042\u3042\u3042\u3042\n\u3044\u3044\u3044\u3044\u3044\u3044\u3044\u3044\n\n\u3046\u3046\u3046\u3046\u3046\u3046\u3046\u3046\u3046\n\u3048\u3048\u3048\u3048\u3048\u3048\u3048\u3048\u3048\n\n"));
        }

        public void testEncode() {
            Assert.assertEquals((String)"BBB2B9CDA5EAA5F3A5AF", (String)this.we.encode("\u53c2\u8003\u30ea\u30f3\u30af"));
        }

        void regTrace() {
            int n = this.we.preg.groups();
            int i = 0;
            while (i <= n) {
                this.xtrace(String.valueOf(i) + ":" + this.we.preg.group(i));
                ++i;
            }
        }

        public void testDecode() {
            Assert.assertEquals((String)"null decode", (String)"", (String)this.we.decode(null));
            Assert.assertEquals((String)"short decode", (String)"", (String)this.we.decode("1"));
            Assert.assertEquals((String)"\u53c2\u8003\u30ea\u30f3\u30af", (String)this.we.decode("BBB2B9CDA5EAA5F3A5AF"));
        }

        public void testExistPages() {
            String[] t = this.we.getExistPages();
            Assert.assertNotNull((Object)t);
            this.xtrace(Arrays.asList(t));
        }

        public void testPageExists() {
            this.we.fileWrite(this.we.getDataDir(), "HOGEHOGE", "HOGEHOGE", false);
            Assert.assertTrue((boolean)this.we.pageExist("HOGEHOGE"));
        }

        void trace(Object t) {
            System.out.println(t);
        }

        void xtrace(Object t) {
        }
    }

    class MakeNote
    extends SubstitutionSupport {
        MakeNote() throws MalformedPatternException {
            this.pattern = WikiEngine.this.p5c.compile("\\(\\(((?:(?!\\)\\)).)*)\\)\\)", 0);
        }

        protected void substitutionHook(StringBuffer buf, MatchResult result) {
            String str = result.group(1);
            str = WikiEngine.this.strReplace("\\\\'", "'", str);
            str = WikiEngine.this.makeUserRules(str);
            WikiEngine.this.foot_explain.add("<a name='notefoot_" + WikiEngine.this.note_id + "' href='#notetext_" + WikiEngine.this.note_id + "' class='note_super'>*" + WikiEngine.this.note_id + "</a> <span class='small'>" + str + "</span><br/>\n");
            String note = "<a name='notetext_" + WikiEngine.this.note_id + "' href='#notefoot_" + WikiEngine.this.note_id + "' class='note_super'>*" + WikiEngine.this.note_id + "</a>";
            ++WikiEngine.this.note_id;
            buf.append(note);
        }
    }

    private class PluginHandler
    extends SubstitutionSupport {
        PluginHandler() throws MalformedPatternException {
            this.pattern = WikiEngine.this.p5c.compile("^\\#([^\\(]+)\\((.*)\\)\\s*$", 0);
        }

        protected void substitutionHook(StringBuffer buf, MatchResult result) {
            String t;
            String pluginName = result.group(1);
            String[] args = EMPTY_VALUES;
            String argsHint = result.group(2);
            if (result.length() > 1 && !WikiEngine.empty(argsHint)) {
                args = WikiEngine.this.explode(',', argsHint);
            }
            if ((t = WikiEngine.this.do_plugin_convert(pluginName, args)) != null) {
                buf.append(t);
            }
        }
    }

    private class PluginHandlerNoArg
    extends PluginHandler {
        PluginHandlerNoArg() throws MalformedPatternException {
            this.pattern = WikiEngine.this.p5c.compile("^\\#([^\\(]+)$", 0);
        }
    }

    static class InterWiki {
        String url;
        String opt;

        InterWiki(String u, String o) {
            this.url = u;
            this.opt = o;
        }

        public String toString() {
            return "url:" + this.url + ", opt:" + this.opt;
        }
    }

    static class WikiText {
        long timestamp;
        ArrayList lines = new ArrayList();

        WikiText() {
        }

        String getTimeStamp() {
            Object[] opt = new Object[]{new Date(this.timestamp * 1000L)};
            return MessageFormat.format("{0,date,yyyy-MM-dd(E) HH:mm}", opt);
        }

        public String toString() {
            return String.valueOf(this.timestamp) + ":" + this.lines.size();
        }
    }

    private static class BkWiki {
        String name;
        String link;

        BkWiki(String n, String l) {
            this.name = n;
            this.link = l;
        }
    }
}

