/*
 * Decompiled with CFR 0.152.
 */
package com.wam_soft.wiki;

import com.wam_soft.wiki.Attach;
import com.wam_soft.wiki.Folder;
import com.wam_soft.wiki.WikiEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class WikiServlet
extends HttpServlet {
    String rbName = "com.wam_soft.wiki.message";
    static Logger log;
    static final String[] EMPTY_VALUES;
    String skin;
    String[] resourcePath = new String[]{"/wikidoc"};
    String inputEncoding = WikiEngine.EUCEncoding;
    boolean noLastModifyCheck;
    Perl5Util preg = new Perl5Util();
    boolean load_template_func = true;
    boolean function_freeze = true;
    boolean withHelp = true;
    boolean needEncodingChange = false;
    File userHome = new File(System.getProperty("user.home"));
    static final Map encodingMap;
    static final String ISO8859_1 = "8859_1";
    String preview_color = "#F5F8FF";
    static final String WIKI_ENGINE = "wiki.engine";
    String adminpass = WikiEngine.md5("pass".getBytes());
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wam_soft.wiki.WikiServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((String)clazz.getName());
        EMPTY_VALUES = new String[0];
        encodingMap = WikiServlet.asMap(new String[]{"sjis", "Shift_JIS", "euc", "EUC-JP", "utf8", "utf-8"});
    }

    boolean empty(String t) {
        return t == null || t.trim().length() == 0;
    }

    String _(String key) {
        try {
            return ResourceBundle.getBundle(this.rbName).getString(key);
        }
        catch (MissingResourceException e) {
            log.warn((Object)(String.valueOf(key) + ": not found."));
            return key;
        }
    }

    public void init() throws ServletException {
        String t;
        this.skin = this.getInitParameter("forward:wiki");
        if (this.empty(this.skin) && this.empty(this.skin = this.getInitParameter("skin"))) {
            this.skin = "/wikidoc/wiki.jsp";
        }
        if (!this.empty(t = this.getInitParameter("inputEncoding"))) {
            this.inputEncoding = t;
        }
        if (!this.empty(t = this.getInitParameter("resourcePath"))) {
            ArrayList a = new ArrayList();
            this.preg.split(a, "/\\s+/", t);
            log.info((Object)("resourcePath:" + a));
            this.resourcePath = a.toArray(EMPTY_VALUES);
        }
        if (!this.empty(t = this.getInitParameter("adminPassword"))) {
            this.adminpass = WikiEngine.md5(t.trim().getBytes());
        }
        this.needEncodingChange = !this.empty(t = this.getInitParameter("opt.needEncodingChange"));
        this.noLastModifyCheck = !this.empty(this.getInitParameter("opt.noLastModifyCheck")) || !this.empty(this.getServletContext().getInitParameter("footer.debugMessage.presents"));
        this.log("init:" + Arrays.asList("adminpass", this.adminpass, "inputEncoding", this.inputEncoding, "needEncodingChange", this.needEncodingChange, "noLastModifyCheck", this.noLastModifyCheck, "resourcePath", Arrays.asList(this.resourcePath), "skin", this.skin));
    }

    void doForward(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestDispatcher disp = this.getServletContext().getRequestDispatcher(this.skin);
        if (disp == null) {
            res.sendError(404);
            this.getServletContext().log(String.valueOf(this.skin) + "(wiki skin) not found.");
            return;
        }
        if (res.isCommitted()) {
            log.warn((Object)"request was comitted. check send buffer size.");
        } else {
            disp.forward((ServletRequest)req, (ServletResponse)res);
        }
        log.debug((Object)"---------------------------------------");
    }

    boolean argCheck(String t, HttpServletRequest req) {
        String cmd = req.getParameter("cmd");
        return !this.empty(cmd) && this.preg.match("/^" + t + "/i", cmd);
    }

    static String htmlspecialchars(String t) {
        return WikiEngine.htmlspecialchars(t);
    }

    String strReplace(String a, String b, String t) {
        return new String(WikiEngine.replace(new StringBuffer(t), a, b));
    }

    String replace(String target, String temp) {
        return this.strReplace("$1", WikiServlet.htmlspecialchars(target), temp);
    }

    static String getDigest(String page, WikiEngine we) {
        String digest = (String)we.request.getAttribute("wiki.didget." + page);
        try {
            if (digest == null) {
                digest = we.getDigest(page);
                we.request.setAttribute("wiki.didget." + page, (Object)digest);
            }
        }
        catch (IOException e) {
            log.warn((Object)e);
            throw new RuntimeException(e.getMessage());
        }
        return digest;
    }

    String editForm(String postdata, String page, boolean addFlag, WikiEngine we) throws IOException {
        String digest = WikiServlet.getDigest(page, we);
        String help = this.withHelp ? String.valueOf(we.hr) + we.catrule() : "<br />\n<ul><li><a href='" + we.script + "?cmd=edit&amp;help=true&amp;page=" + we.urlEncode(page) + "'>" + this._("msg_help") + "</a></ul></li>\n";
        String str_freeze = "";
        if (this.function_freeze) {
            str_freeze = "<input type=submit name=freeze value='" + this._("btn_freeze") + "' accesskey='f' />";
        }
        String template = "";
        return "<form action='" + we.script + "?' method='post'>\n" + "<table cellspacing='3' cellpadding='0' border='0'>" + "<tr><td align=right>" + template + "</td></tr>" + "<tr><td align=right>\n" + "<input type=hidden name=page value='" + WikiServlet.htmlspecialchars(page) + "' />\n" + "<input type=hidden name=digest value='" + WikiServlet.htmlspecialchars(digest) + "' />\n" + "<textarea name=msg rows=" + we.rows + " cols=" + we.cols + " wrap=virtual>" + WikiServlet.htmlspecialchars(postdata) + "</textarea></td></tr>\n" + "<tr><td><input type=submit name=preview value='" + this._("btn_preview") + "' accesskey=p />\n" + "<input type=submit name=write value='" + this._("btn_update") + "' accesskey=s />\n" + "<input type=checkbox name=notimestamp value=true /><span style=small>" + this._("btn_notchangetimestamp") + "</span>\n" + "</td></tr></table></form>\n" + "<form action=\"" + we.script + "?cmd=freeze\" method=post>\n" + "<div><input type=hidden name=page value='" + WikiServlet.htmlspecialchars(page) + "' />" + str_freeze + "</div></form>\n" + help;
    }

    URL getResource(String resource) throws IOException {
        if (resource == null) {
            throw new FileNotFoundException("Requested resource was null (passed in null)");
        }
        if (resource.endsWith("/") || resource.endsWith("\\") || resource.endsWith(".")) {
            throw new MalformedURLException("Path may not end with a slash or dot");
        }
        if (resource.indexOf("..") != -1) {
            throw new MalformedURLException("Path may not contain double dots");
        }
        String t = resource.toUpperCase();
        if (t.startsWith("/WEB-INF") || t.startsWith("/META-INF")) {
            throw new MalformedURLException("Path may not begin with /WEB-INF or /META-INF");
        }
        if (t.endsWith(".JSP") || t.endsWith(".JSF")) {
            throw new MalformedURLException("Path may not end with .jsp or .jsf");
        }
        URL url = this.getServletContext().getResource(resource);
        int ct = 0;
        while (url == null && ct < this.resourcePath.length) {
            url = this.getServletContext().getResource(String.valueOf(this.resourcePath[ct++]) + resource);
        }
        return url;
    }

    String guessType(String path) {
        String name = path.toLowerCase();
        if (name.endsWith(".jpeg") || name.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        if (name.endsWith(".txt")) {
            return "text/plain";
        }
        return "application/octet-stream";
    }

    Map do_plugin_action(String plugin, WikiEngine we, HttpServletResponse res) throws IOException {
        try {
            return we.do_plugin_action(plugin);
        }
        catch (Redirect e) {
            if (!this.empty(e.location)) {
                res.sendRedirect(e.location);
                log.info((Object)("#sendRedirect " + e.location));
            }
            return WikiEngine.asMap(new String[]{"redirect", "done."});
        }
    }

    WikiEngine createWikiEngine(String hint) {
        WikiEngine we = new WikiEngine();
        String dataFolder = this.getInitParameter("dataFolder");
        if (!this.empty(dataFolder)) {
            File df;
            File file = df = dataFolder.startsWith("/") ? new File(dataFolder) : new File(this.userHome, dataFolder);
            if (!this.empty(hint)) {
                int p;
                if (hint.charAt(0) == '/') {
                    hint = hint.substring(1);
                }
                if ((p = hint.indexOf("attach/")) >= 0 && p + 6 == hint.lastIndexOf(47)) {
                    hint = hint.substring(0, p);
                }
                File sub = new File(df, hint);
                log.debug((Object)("sub test:" + sub));
                if (sub.isDirectory()) {
                    df = sub;
                }
            }
            log.debug((Object)("changeDataFolder:" + df));
            if (new File(df, ".wiki").isFile()) {
                we.changeDataDir(df);
            }
        }
        return we;
    }

    protected long getLastModified(HttpServletRequest req) {
        String path = req.getPathInfo();
        try {
            URLConnection con;
            URL resource;
            if (!this.empty(path) && (resource = this.getResource(path)) != null && (con = resource.openConnection()) != null) {
                return con.getLastModified();
            }
        }
        catch (IOException ignored) {
            log.warn((Object)ignored);
        }
        if (this.empty(req.getParameter("plugin")) && this.empty(req.getParameter("cmd"))) {
            WikiEngine we = this.createWikiEngine(path);
            String page = we.urlDecode(req.getQueryString());
            if (!this.empty(page) && !this.preg.match("/^((" + we.wikiName + ")|(" + we.bracketName + ")|(" + we.interWikiName + "))$/", page)) {
                page = "[[" + page + "]]";
                log.debug((Object)"guess BracketName");
            }
            if (!this.empty(page) && we.isPage(page)) {
                long lm = we.getFileName(we.encode(page)).lastModified();
                req.setAttribute("lastModified", (Object)new Date(lm));
                lm = we.getFileName(we.encode(we.whatsnew)).lastModified();
                log.debug((Object)("lastModified check:" + page));
                if (!this.noLastModifyCheck && lm != 0L) {
                    return lm;
                }
            }
        }
        return super.getLastModified(req);
    }

    boolean is_editable(String page) {
        return true;
    }

    Object[] rev(Object[] a) {
        if (a != null) {
            int i = 0;
            int n = a.length / 2;
            while (i < n) {
                Object t = a[i];
                a[i] = a[a.length - 1 - i];
                a[a.length - 1 - i] = t;
                ++i;
            }
        }
        return a;
    }

    static Map asMap(Object[] a) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        if (a != null) {
            int i = 0;
            while (i + 1 < a.length) {
                p.put(a[i], a[i + 1]);
                i += 2;
            }
        }
        return p;
    }

    String makeSearch(String page, WikiEngine we) {
        if (this.empty(page)) {
            return page;
        }
        log.debug((Object)("makeSearch for " + page));
        String name = we.stripBracket(page);
        String enc = this.empty(this.inputEncoding) ? WikiEngine.EUCEncoding : this.inputEncoding;
        String word = WikiEngine.rawurlencode(page, enc);
        return "<a href='" + we.script + "?cmd=search&amp;word=" + word + "'>" + WikiServlet.htmlspecialchars(name) + "</a> ";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block69: {
            block78: {
                block79: {
                    block77: {
                        block76: {
                            block75: {
                                block74: {
                                    block73: {
                                        block72: {
                                            block71: {
                                                block70: {
                                                    block68: {
                                                        path = req /* !! */ .getPathInfo();
                                                        req /* !! */ .setAttribute("wiki.pathInfo", (Object)path);
                                                        if (!this.empty(path) && (p = path.indexOf("attach/")) >= 0 && p + 6 == path.lastIndexOf(47)) {
                                                            we = this.createWikiEngine(path);
                                                            target = new File(we.getDataDir(), path.substring(p));
                                                            WikiServlet.log.debug((Object)target);
                                                            if (!target.exists()) {
                                                                res.sendError(404);
                                                                return;
                                                            }
                                                            res.setContentType(this.guessType(path.substring(p + 7)));
                                                            Folder.passThru((OutputStream)res.getOutputStream(), new FileInputStream(target));
                                                            return;
                                                        }
                                                        try {
                                                            if (!this.empty(path) && (resource = this.getResource(path)) != null) {
                                                                WikiServlet.log.debug((Object)(String.valueOf(path) + ":" + resource));
                                                                connection = resource.openConnection();
                                                                connection.connect();
                                                                type = connection.getContentType();
                                                                WikiServlet.log.debug((Object)("LastModified:" + connection.getLastModified()));
                                                                if (type == null) {
                                                                    type = this.guessType(path);
                                                                }
                                                                res.setContentType(type);
                                                                Folder.passThru((OutputStream)res.getOutputStream(), resource.openStream());
                                                                return;
                                                            }
                                                        }
                                                        catch (MalformedURLException ignored) {
                                                            WikiServlet.log.debug((Object)ignored);
                                                        }
                                                        pstart = System.currentTimeMillis();
                                                        if (this.needEncodingChange && !this.empty(this.inputEncoding)) {
                                                            req /* !! */  = new WReq(req /* !! */ , this.inputEncoding);
                                                        }
                                                        we = this.createWikiEngine(path);
                                                        we.request = req /* !! */ ;
                                                        req /* !! */ .setAttribute("wiki.ServletContext", (Object)this.getServletContext());
                                                        req /* !! */ .setAttribute("wiki.engine", (Object)we);
                                                        encoding = req /* !! */ .getCharacterEncoding();
                                                        if (this.empty(encoding)) {
                                                            req /* !! */ .setCharacterEncoding(this.inputEncoding);
                                                        }
                                                        WikiServlet.log.debug((Object)("inputEncoding:" + req /* !! */ .getCharacterEncoding()));
                                                        plugin = req /* !! */ .getParameter("plugin");
                                                        page = we.page = we.urlDecode(req /* !! */ .getParameter("page"));
                                                        if (!this.empty(page) && WikiServlet.log.isDebugEnabled()) {
                                                            WikiServlet.log.debug((Object)("page Hex:" + WikiEngine.hexCode(page.getBytes("8859_1"))));
                                                        }
                                                        arg = we.urlDecodeForce(req /* !! */ .getQueryString());
                                                        WikiServlet.log.debug((Object)("arg was:" + arg));
                                                        pageSearch = "";
                                                        title = "";
                                                        body = "";
                                                        sourceText = "";
                                                        if (!we.exist_plugin_action(plugin) || (pResult = this.do_plugin_action(plugin, we, res)).isEmpty()) break block68;
                                                        if (pResult.containsKey("redirect")) {
                                                            return;
                                                        }
                                                        refer = we.urlDecode(req /* !! */ .getParameter("refer"));
                                                        if (!this.empty(refer)) {
                                                            page = refer;
                                                        } else if (this.empty(refer) && !this.empty(page)) {
                                                            refer = page;
                                                        }
                                                        title = we.stripBracket(refer);
                                                        pageSearch = this.makeSearch(page, we);
                                                        if (pResult.containsKey("page")) {
                                                            page = we.page = (String)pResult.get("page");
                                                        }
                                                        if (!this.empty(msg = (String)pResult.get("msg"))) {
                                                            title = this.strReplace("$1", title, msg);
                                                            pageSearch = this.strReplace("$1", pageSearch, msg);
                                                        }
                                                        body = pResult.containsKey("body") ? (String)pResult.get("body") : we.convertHtml(we.getSourceText(refer));
                                                        break block69;
                                                    }
                                                    if (!this.argCheck("list", req /* !! */ )) break block70;
                                                    pageSearch = title = this._("title_list");
                                                    body = we.getList(false);
                                                    break block69;
                                                }
                                                if (!this.argCheck("filelist", req /* !! */ )) break block71;
                                                pageSearch = title = this._("title_filelist");
                                                body = we.getList(true);
                                                break block69;
                                            }
                                            if (!this.argCheck("add", req /* !! */ ) && !this.argCheck("edit", req /* !! */ ) && !this.argCheck("preview", req /* !! */ ) || !this.empty(page) && !we.isFreeze(page) && this.is_editable(page)) break block72;
                                            body = title = this.replace(we.stripBracket(page), this._("title_cannotedit"));
                                            pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_cannotedit"));
                                            if (we.isFreeze(page)) {
                                                body = String.valueOf(body) + "<form action=\"" + we.script + "?cmd=unfreeze&amp;page=" + we.urlEncode(page) + "\" method=post>" + "<input type=submit value=\"" + this._("msg_unfreeze") + "\">" + "</form>";
                                            }
                                            break block69;
                                        }
                                        if (!this.argCheck("search", req /* !! */ )) break block73;
                                        word = req /* !! */ .getParameter("word");
                                        WikiServlet.log.debug((Object)("search:" + word));
                                        and_check = "";
                                        or_check = "";
                                        if (this.empty(word)) {
                                            pageSearch = title = this._("title_search");
                                            body = "<br />\n" + this._("msg_searching");
                                        } else {
                                            pageSearch = title = this.replace(word, this._("title_result"));
                                            type = req /* !! */ .getParameter("type");
                                            itype = 0;
                                            if (!this.empty(type) && type.trim().equalsIgnoreCase("or")) {
                                                itype = 1;
                                            }
                                            buf = new StringBuffer(200);
                                            retval = we.doSearch(word, itype, true, page);
                                            if (retval.isEmpty()) {
                                                buf.append(this.strReplace("$1", WikiServlet.htmlspecialchars(word), we._("msg_notfoundresult")));
                                            } else {
                                                WikiEngine.join(buf.append("<ul><li>"), "\n<li>", this.rev(new TreeMap<K, V>(retval).values().toArray())).append("\n</ul>\n");
                                                key = itype == 0 ? "msg_andresult" : "msg_orresult";
                                                buf.append(this.strReplace("$1", WikiServlet.htmlspecialchars(word), this.strReplace("$2", String.valueOf(retval.size()), this.strReplace("$3", String.valueOf(we.searchCount), we._(key)))));
                                            }
                                            body = new String(buf);
                                            switch (itype) {
                                                case 0: {
                                                    and_check = "checked=\"checked\"";
                                                    break;
                                                }
                                                case 1: {
                                                    or_check = "checked=\"checked\"";
                                                }
                                            }
                                        }
                                        body = String.valueOf(body) + "<form action=\"" + we.script + "?\" method=\"get\">\n" + "<div>\n" + "<input type=\"hidden\" name=\"cmd\" value=\"search\" />\n" + "<input type=\"text\" name=\"word\" size=\"20\" value=\"" + WikiServlet.htmlspecialchars(word) + "\" />\n" + "<input type=\"radio\" name=\"type\" value=\"AND\" " + and_check + " />" + this._("btn_and") + "\n<input type=\"radio\" name=\"type\" value=\"OR\" " + or_check + " />" + this._("btn_or") + "\n&nbsp;<input type=\"submit\" value=\"" + this._("btn_search") + "\" />\n" + "</div>\n" + "</form>\n";
                                        break block69;
                                    }
                                    if (!this.argCheck("diff", req /* !! */ )) break block74;
                                    pagename = WikiServlet.htmlspecialchars(we.stripBracket(page));
                                    if (!we.isPage(page)) {
                                        title = WikiServlet.htmlspecialchars(pagename);
                                        pageSearch = this.makeSearch(page, we);
                                        body = this._("msg_notfound");
                                    } else {
                                        link = this.strReplace("$1", "<a href=\"" + we.script + "?" + we.urlEncode(page) + "\">" + pagename + "</a>", this._("msg_goto"));
                                        body = "<ul>\n<li>" + this._("msg_addline") + "</li>\n" + "<li>" + this._("msg_delline") + "</li>\n" + "<li>" + link + "</li>\n</ul>\n" + we.hr + "\n";
                                    }
                                    if (!we.getDiffFile(page).exists() && we.isPage(page)) {
                                        title = this.replace(we.stripBracket(page), this._("title_diff"));
                                        pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_diff"));
                                        body = String.valueOf(body) + "<pre style=\"color:blue;\">\n" + WikiServlet.htmlspecialchars(we.getSourceText(page)) + "\n</pre>\n";
                                    } else if (we.getDiffFile(page).exists()) {
                                        title = this.replace(we.stripBracket(page), this._("title_diff"));
                                        pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_diff"));
                                        diffdata = we.file(we.getDiffFile(page));
                                        we.diffAttr((String[])diffdata);
                                        body = String.valueOf(body) + "<pre>" + WikiEngine.join("\n", diffdata) + "</pre>\n";
                                    }
                                    break block69;
                                }
                                if (!this.argCheck("backup", req /* !! */ )) break block75;
                                age = 0;
                                try {
                                    age = Integer.parseInt(req /* !! */ .getParameter("age"));
                                }
                                catch (NumberFormatException ignored) {
                                    WikiServlet.log.debug((Object)ignored);
                                }
                                if (age > 0 && we.backupExist(page)) {
                                    pagename = WikiServlet.htmlspecialchars(we.stripBracket(page));
                                    xbody = new StringBuffer(200).append("<ul>\n").append("<li><a href=\"").append(we.script).append("?cmd=backup\">").append(this._("msg_backuplist")).append("</a></li>\n");
                                    if (!this.argCheck("backup_diff", req /* !! */ ) && we.isPage(page)) {
                                        link = this.strReplace("$1", "<a href=\"" + we.script + "?cmd=backup_diff&amp;page=" + we.urlEncode(page) + "&amp;age=" + age + "\">" + this._("msg_diff") + "</a>", this._("msg_view"));
                                        xbody.append("<li>").append(link).append("</li>\n");
                                    }
                                    if (!this.argCheck("backup_nowdiff", req /* !! */ ) && we.isPage(page)) {
                                        link = this.strReplace("$1", "<a href=\"" + we.script + "?cmd=backup_nowdiff&amp;page=" + we.urlEncode(page) + "&amp;age=" + age + "\">" + this._("msg_nowdiff") + "</a>", this._("msg_view"));
                                        xbody.append("<li>").append(link).append("</li>\n");
                                    }
                                    if (!this.argCheck("backup_source", req /* !! */ )) {
                                        link = this.strReplace("$1", "<a href=\"" + we.script + "?cmd=backup_source&amp;page=" + we.urlEncode(page) + "&amp;age=" + age + "\">" + this._("msg_source") + "</a>", this._("msg_view"));
                                        xbody.append("<li>").append(link).append("</li>\n");
                                    }
                                    if (this.argCheck("backup_diff", req /* !! */ ) || this.argCheck("backup_source", req /* !! */ ) || this.argCheck("backup_nowdiff", req /* !! */ )) {
                                        link = this.strReplace("$1", "<a href=\"" + we.script + "?cmd=backup&amp;page=" + we.urlEncode(page) + "&amp;age=" + age + "\">" + this._("msg_backup") + "</a>", this._("msg_view"));
                                        xbody.append("<li>").append(link).append("</li>\n");
                                    }
                                    link = we.isPage(page) != false ? this.strReplace("$1", "<a href=\"" + we.script + "?" + we.urlEncode(page) + "\">" + WikiServlet.htmlspecialchars(pagename) + "</a>", this._("msg_goto")) : this.strReplace("$1", WikiServlet.htmlspecialchars(pagename), this._("msg_deleleted"));
                                    xbody.append("<li>").append(link).append("</li>\n");
                                    backups = we.get_backup_info(String.valueOf(we.encode(page)) + ".txt", false);
                                    if (!backups.isEmpty()) {
                                        xbody.append("<ul>\n");
                                    }
                                    cmd = req /* !! */ .getParameter("cmd");
                                    i = 0;
                                    n = backups.size();
                                    while (i < n) {
                                        a = (WikiEngine.WikiText)backups.get(i);
                                        if (i + 1 == age) {
                                            xbody.append("<li><em>").append(i + 1).append(" ").append(a.getTimeStamp()).append("</em></li>\n");
                                        } else {
                                            xbody.append("<li><a href=\"").append(we.script).append("?cmd=").append(cmd).append("&amp;page=").append(we.urlEncode(page)).append("&amp;age=").append(i + 1).append("\">").append(i + 1).append(" ").append(a.getTimeStamp()).append("</a></li>\n");
                                        }
                                        ++i;
                                    }
                                    if (!backups.isEmpty()) {
                                        xbody.append("</ul>\n");
                                    }
                                    xbody.append("</li>\n");
                                    backupdata = "";
                                    if (this.argCheck("backup_diff", req /* !! */ )) {
                                        title = String.valueOf(this.replace(WikiServlet.htmlspecialchars(pagename), this._("title_backupdiff"))) + "(No." + age + ")";
                                        pageSearch = String.valueOf(this.strReplace("$1", this.makeSearch(page, we), this._("title_backupdiff"))) + "(No." + age + ")";
                                        backupdataL = we.get_backup(String.valueOf(we.encode(page)) + ".txt", age - 1);
                                        diffdataL = we.get_backup(String.valueOf(we.encode(page)) + ".txt", age);
                                        backupdata = we.do_diff(backupdataL, diffdataL, true);
                                    } else if (this.argCheck("backup_nowdiff", req /* !! */ )) {
                                        title = String.valueOf(this.replace(WikiServlet.htmlspecialchars(pagename), this._("title_backupnowdiff"))) + "(No." + age + ")";
                                        pageSearch = String.valueOf(this.strReplace("$1", this.makeSearch(page, we), this._("title_backupnowdiff"))) + "(No." + age + ")";
                                        backupdataL = we.get_backup(String.valueOf(we.encode(page)) + ".txt", age);
                                        diffdataL = we.getSource(page);
                                        backupdata = we.do_diff(backupdataL, diffdataL, true);
                                    } else if (this.argCheck("backup_source", req /* !! */ )) {
                                        title = String.valueOf(this.replace(WikiServlet.htmlspecialchars(pagename), this._("title_backupsource"))) + "(No." + age + ")";
                                        pageSearch = String.valueOf(this.strReplace("$1", this.makeSearch(page, we), this._("title_backupsource"))) + "(No." + age + ")";
                                        backupdata = WikiServlet.htmlspecialchars(WikiEngine.join("\n", we.get_backup(String.valueOf(we.encode(page)) + ".txt", age)));
                                        xbody.append("</ul>\n<pre>\n").append(backupdata).append("</pre>\n");
                                    } else {
                                        title = String.valueOf(this.replace(WikiServlet.htmlspecialchars(pagename), this._("title_backup"))) + "(No." + age + ")";
                                        pageSearch = String.valueOf(this.strReplace("$1", this.makeSearch(page, we), this._("title_backup"))) + "(No." + age + ")";
                                        backupdata = we.convertHtml(WikiEngine.join("\n", we.get_backup(String.valueOf(we.encode(page)) + ".txt", age)));
                                        xbody.append("</ul>\n").append(we.hr).append('\n').append(backupdata);
                                    }
                                    if (this.argCheck("backup_diff", req /* !! */ ) || this.argCheck("backup_nowdiff", req /* !! */ )) {
                                        xbody.append("</ul><br /><ul>\n<li>").append(this._("msg_addline")).append("</li>\n<li>").append(this._("msg_delline")).append("</li>\n</ul>\n").append(we.hr).append("\n<pre>\n").append(backupdata).append("</pre>\n");
                                    }
                                    body = new String(xbody);
                                } else if (we.backupExist(page)) {
                                    title = this.replace(we.stripBracket(page), this._("title_pagebackuplist"));
                                    pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_pagebackuplist"));
                                    body = we.get_backup_list(page);
                                } else {
                                    pageSearch = title = this._("title_backuplist");
                                    body = we.get_backup_list("");
                                }
                                break block69;
                            }
                            if (!this.argCheck("add", req /* !! */ )) break block76;
                            title = this.replace(we.stripBracket(page), this._("title_add"));
                            pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_add"));
                            buf = new StringBuffer("<ul>\n").append("<li>").append(this._("msg_add")).append("</li>\n").append("</ul>\n").append(this.editForm("", page, true, we));
                            body = new String(buf);
                            break block69;
                        }
                        if (!this.argCheck("edit", req /* !! */ )) break block77;
                        sourceText = we.getSourceText(page);
                        postdata = sourceText;
                        if (this.empty(postdata)) {
                            postdata = we.autoTemplate(page);
                        }
                        title = this.replace(we.stripBracket(page), this._("title_edit"));
                        pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_add"));
                        body = this.editForm(postdata, page, false, we);
                        break block69;
                    }
                    if ((!this.argCheck("read", req /* !! */ ) || this.empty(page)) && (this.argCheck("read", req /* !! */ ) || this.empty(arg) || !this.empty(page))) break block78;
                    if (!this.empty(arg) && this.empty(page) && this.empty(req /* !! */ .getParameter("cmd"))) {
                        page = arg;
                    }
                    WikiServlet.log.info((Object)("page:" + page));
                    if (!this.preg.match("/^((" + we.wikiName + ")|(" + we.bracketName + ")|(" + we.interWikiName + "))$/", page)) {
                        page = "[[" + page + "]]";
                        WikiServlet.log.debug((Object)"guess BracketName");
                    }
                    if (!we.isPage(page)) break block79;
                    we.page = page;
                    title = WikiServlet.htmlspecialchars(we.stripBracket(page));
                    pageSearch = this.makeSearch(page, we);
                    sourceText = we.getSourceText(page);
                    body = we.convertHtml(sourceText);
                    break block69;
                }
                if (!this.preg.match("/(" + we.interWikiName + ")/", page)) ** GOTO lbl300
                interwikis = we.openInterwikinameList();
                key = this.preg.group(2);
                name = this.preg.group(3);
                iw = (WikiEngine.InterWiki)interwikis.get(key);
                if (iw == null) {
                    title = pageSearch = this._("title_invalidiwn");
                    body = this.strReplace("$1", WikiServlet.htmlspecialchars(we.stripBracket(page)), this.strReplace("$2", "<a href=\"" + we.script + "?InterWikiName\">InterWikiName</a>", this._("msg_invalidiwn")));
                    WikiServlet.log.debug((Object)("interwiki-hint:" + key + ":" + we.encode(name) + ":" + name));
                } else {
                    WikiServlet.log.debug((Object)("interwiki-hint:" + iw.opt + ":" + key + ":" + we.encode(name) + ":" + name));
                    if (this.empty(iw.opt) || "std".equals(iw.opt)) {
                        name = we.urlEncode(name);
                    } else if ("yw".equals(iw.opt)) {
                        WikiServlet.log.debug((Object)"old yukiwiki encoding");
                        if (!this.preg.match("/" + we.wikiName + "/", name)) {
                            name = "[[" + WikiEngine.rawurlencode(name, "SJIS") + "]]";
                        }
                    } else if ("moni".equals(iw.opt)) {
                        WikiServlet.log.debug((Object)"moni encoding");
                        name = this.strReplace("%", "_", WikiEngine.rawurlencode(name, WikiEngine.EUCEncoding));
                    } else if (!("asis".equals(iw.opt) || "raw".equals(iw.opt) || this.empty(iw.opt))) {
                        ec = (String)WikiServlet.encodingMap.get(iw.opt);
                        if (ec == null) {
                            ec = iw.opt;
                        }
                        name = WikiEngine.rawurlencode(name, ec);
                    }
                    url = iw.url.indexOf("$1") < 0 ? String.valueOf(iw.url) + name : this.strReplace("$1", name, iw.url);
                    WikiServlet.log.debug((Object)("interwiki:" + url));
                    res.sendRedirect(url);
                    return;
lbl300:
                    // 1 sources

                    if (this.preg.match("/^((" + we.bracketName + ")|(" + we.wikiName + "))$/", page)) {
                        title = this.replace(we.stripBracket(page), this._("title_edit"));
                        pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_edit"));
                        template = we.autoTemplate(page);
                        body = this.editForm(template, page, false, we);
                    } else {
                        title = this.replace(we.stripBracket(page), this._("title_invalidwn"));
                        body = pageSearch = this.strReplace("$1", this.makeSearch(page, we), this.strReplace("$2", "WikiName", this._("msg_invalidiwn")));
                    }
                }
                break block69;
            }
            page = we.defaultpage;
            title = WikiServlet.htmlspecialchars(we.stripBracket(page));
            pageSearch = this.makeSearch(page, we);
            sourceText = we.getSourceText(page);
            body = we.convertHtml(sourceText);
        }
        req /* !! */ .setAttribute("pageEncoding", (Object)we.encode(page));
        req /* !! */ .setAttribute("pageSource", (Object)sourceText);
        req /* !! */ .setAttribute("pageSearch", (Object)pageSearch);
        req /* !! */ .setAttribute("pageName", (Object)we.urlEncode(page));
        req /* !! */ .setAttribute("title", (Object)title);
        req /* !! */ .setAttribute("body", (Object)body);
        req /* !! */ .setAttribute("footnote", (Object)we.getFootNoteText());
        req /* !! */ .setAttribute("procTime", (Object)new Long(pstart));
        req /* !! */ .setAttribute("attachList", (Object)this.getAttachList(page, we));
        this.doForward(req /* !! */ , res);
    }

    String getAttachList(String page, WikiEngine we) {
        Map p;
        Object t = null;
        if (!this.empty(page) && (t = we.request.getAttribute("wiki.attachFiles")) == null) {
            try {
                t = ((Attach)we.getPluginInstance("attach")).findFile(page, we);
                we.request.setAttribute("wiki.attachFiles", t);
            }
            catch (InstantiationException e) {
                log.warn((Object)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)e);
            }
        }
        return (p = (Map)t) != null ? WikiEngine.join("", p.values().toArray()) : "";
    }

    boolean available(String t, HttpServletRequest req) {
        return !this.empty(req.getParameter(t));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Map pResult;
        long pstart = System.currentTimeMillis();
        if (req.getContentType().toLowerCase().startsWith("multipart/form-data")) {
            String t = this.getInitParameter("opt.uploadAdapter");
            if (this.empty(t)) {
                t = "com.wam_soft.wiki.Folder$ApacheUpload";
            }
            Folder.UploadSupport uh = Folder.createUploadSupport(t);
            uh.init(this.getServletConfig());
            int n = uh.parse(req, this.inputEncoding);
            log.debug((Object)(String.valueOf(n) + " file item received."));
            req = uh.getWrapper();
        } else {
            String encoding = req.getCharacterEncoding();
            if (this.empty(encoding)) {
                req.setCharacterEncoding(this.inputEncoding);
            }
        }
        WikiEngine we = this.createWikiEngine(req.getPathInfo());
        we.request = req;
        req.setAttribute("wiki.ServletContext", (Object)this.getServletContext());
        req.setAttribute(WIKI_ENGINE, (Object)we);
        log.debug((Object)("post from " + req.getRemoteAddr()));
        String plugin = req.getParameter("plugin");
        String page = we.page = we.urlDecode(req.getParameter("page"));
        String pageSearch = "";
        String title = "";
        String body = "";
        String sourceText = "";
        if (!this.empty(plugin) && we.exist_plugin_action(plugin) && !(pResult = this.do_plugin_action(plugin, we, res)).isEmpty()) {
            String msg;
            if (pResult.containsKey("redirect")) {
                return;
            }
            String refer = we.urlDecode(req.getParameter("refer"));
            if (!this.empty(refer)) {
                page = refer;
            } else if (this.empty(refer) && !this.empty(page)) {
                refer = page;
            }
            title = we.stripBracket(refer);
            pageSearch = this.makeSearch(page, we);
            if (pResult.containsKey("page")) {
                page = we.page = (String)pResult.get("page");
            }
            if (!this.empty(msg = (String)pResult.get("msg"))) {
                title = this.strReplace("$1", title, msg);
                pageSearch = this.strReplace("$1", pageSearch, msg);
            }
            body = pResult.containsKey("body") ? (String)pResult.get("body") : we.convertHtml(we.getSourceText(refer));
        } else if (this.argCheck("preview", req) || this.available("preview", req) || this.available("template", req)) {
            String digest;
            String add;
            String template_page;
            String msg = req.getParameter("msg");
            if (this.available("template", req) && !this.empty(template_page = req.getParameter("template_page")) && we.pageExist(template_page)) {
                msg = we.getSourceText(template_page);
            }
            String postdata_input = msg = this.preg.substitute("s/^#freeze\n//g", msg);
            String postdata = !this.available("add", req) ? msg : (this.available("add_top", req) ? String.valueOf(msg) + "\n\n" + we.getSourceText(page) : String.valueOf(we.getSourceText(page)) + "\n\n" + msg);
            title = this.replace(we.stripBracket(page), this._("title_preview"));
            pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_preview"));
            StringBuffer xbody = new StringBuffer();
            xbody.append(this._("msg_preview")).append("<br />\n");
            if (this.empty(postdata)) {
                xbody.append("<strong>").append(this._("msg_preview_delete")).append("</strong><br />\n");
            } else {
                xbody.append("<br />\n");
            }
            if (!this.empty(postdata)) {
                xbody.append("<table width=\"100%\" style=\"background-color:").append(this.preview_color).append("\">\n").append("<tr><td>\n").append(we.convertHtml(postdata)).append("\n</td></tr>\n</table>\n");
            }
            String addtag = "";
            String add_top = "";
            if (this.available("add", req)) {
                String checked_top = "";
                if (this.available("add", req)) {
                    checked_top = " checked=\"checked\"";
                }
                addtag = "<input type=\"hidden\" name=\"add\" value=\"true\" />";
                add_top = "<input type=\"checkbox\" name=\"add_top\" value=\"true\"" + checked_top + "/><span class=\"small\">" + this._("btn_addtop") + "</span>";
            }
            String checked_time = "";
            if (this.available("notimestamp", req)) {
                checked_time = "checked=\"checked\"";
            }
            if (this.empty(add = req.getParameter("add"))) {
                add = "";
            }
            if (this.empty(digest = req.getParameter("digest"))) {
                digest = "";
            }
            xbody.append("<form action=\"").append(we.script).append("?\" method=\"post\">\n").append("<div>\n<input type=\"hidden\" name=\"help\" value=\"").append(WikiServlet.htmlspecialchars(add)).append("\" />\n").append("<input type=\"hidden\" name=\"page\" value=\"").append(WikiServlet.htmlspecialchars(page)).append("\" />\n").append("<input type=\"hidden\" name=\"digest\" value=\"").append(WikiServlet.htmlspecialchars(digest)).append("\" />\n").append(addtag).append('\n').append("<textarea name=\"msg\" rows=\"").append(we.rows).append("\" cols=\"").append(we.cols).append("\" wrap=\"virtual\">\n").append(WikiServlet.htmlspecialchars(postdata_input)).append("</textarea><br />\n").append("<input type=\"submit\" name=\"preview\" value=\"").append(this._("btn_repreview")).append("\" accesskey=\"p\" />\n").append("<input type=\"submit\" name=\"write\" value=\"").append(this._("btn_update")).append("\" accesskey=\"s\" />\n").append(add_top).append('\n').append("<input type=\"checkbox\" name=\"notimestamp\" value=\"true\" ").append(checked_time).append(" /><span class=\"small\">").append(this._("btn_notchangetimestamp")).append("</span>\n").append("</div>\n</form>\n");
            body = new String(xbody);
        } else if (this.available("write", req)) {
            String digest;
            String msg = req.getParameter("msg");
            if (this.empty(msg)) {
                msg = "";
            }
            msg = we.normalize(msg);
            String postdata_input = msg = this.preg.substitute("s/^#freeze\n//g", msg);
            String postdata = !this.available("add", req) ? msg : (this.available("add_top", req) ? String.valueOf(msg) + "\n\n" + we.getSourceText(page) : String.valueOf(we.getSourceText(page)) + "\n\n" + msg);
            if (we.writeText(page, postdata, digest = req.getParameter("digest"), !this.empty(req.getParameter("notimestamp")))) {
                String diffdata = we.update_diff(we.getSource(page), we.explode('\n', postdata_input));
                title = this.replace(we.stripBracket(page), this._("title_collided"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_collided"));
                body = "<form action='" + we.script + "?' method='post'>\n" + "<div>" + "<input type=hidden name=page value='" + WikiServlet.htmlspecialchars(page) + "' />\n" + "<input type=hidden name=digest value='" + WikiServlet.htmlspecialchars(we.savedDigest) + "' />\n" + "<textarea name=msg rows=" + we.rows + " cols=" + we.cols + " wrap=virtual>" + WikiServlet.htmlspecialchars(diffdata) + "</textarea></br>\n" + "<input type=submit name=preview value='" + this._("btn_preview") + "' accesskey=p />\n" + "<input type=submit name=write value='" + this._("btn_update") + "' accesskey=s />\n" + "<input type=checkbox name=notimestamp value=true /><span style=small>" + this._("btn_notchangetimestamp") + "</span>\n" + "</div></form>\n";
            } else if (this.empty(postdata)) {
                title = body = this.replace(we.stripBracket(page), this._("title_deleted"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_deleted"));
            } else {
                title = this.replace(we.stripBracket(page), this._("title_updated"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_updated"));
                body = we.convertHtml(postdata);
                if (res.isCommitted()) {
                    log.warn((Object)(String.valueOf(page) + " rewrite but it's already committed."));
                } else {
                    String wikiname = we.urlEncode(page);
                    res.sendRedirect(this.redirectName(we.script, wikiname, req.getPathInfo()));
                }
            }
        } else if (this.function_freeze && this.argCheck("freeze", req) && !this.empty(page)) {
            String pass = req.getParameter("pass");
            if (this.empty(pass)) {
                pass = "";
            }
            log.debug((Object)"+=============== process freeze. ");
            if (we.isFreeze(page)) {
                body = title = this.replace(we.stripBracket(page), this._("title_isfreezed"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_isfreezed"));
            } else if (WikiEngine.md5(pass.getBytes()).equals(this.adminpass) || req.isUserInRole("admin")) {
                String srcText;
                File lock = we.getLockFile(page);
                try {
                    srcText = "#freeze\n" + we.getSourceText(page);
                    we.fileWrite(we.getDataDir(), page, srcText, false);
                }
                catch (Throwable throwable) {
                    Object var17_30 = null;
                    lock.delete();
                    throw throwable;
                }
                Object var17_31 = null;
                lock.delete();
                log.debug((Object)("freezed. " + srcText.length()));
                title = this.replace(we.stripBracket(page), this._("title_isfreezed"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_isfreezed"));
                body = we.convertHtml(srcText);
            } else {
                log.debug((Object)"freeze password required.");
                title = this.replace(we.stripBracket(page), this._("title_isfreeze"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_isfreeze"));
                body = "<br />\n";
                body = !this.empty(pass) ? String.valueOf(body) + "<strong>" + this._("msg_invalidpass") + "</strong><br/>\n" : String.valueOf(body) + this._("msg_freezing") + "<br/>\n";
                body = String.valueOf(body) + "<form action=\"" + we.script + "?cmd=freeze\" method=post>\n" + "<div>\n" + "<input type=\"hidden\" name=\"page\" value=\"" + WikiServlet.htmlspecialchars(page) + "\" />\n" + "<input type=\"password\" name=\"pass\" size=\"12\" />\n" + "<input type=\"submit\" name=\"ok\" value=\"" + WikiServlet.htmlspecialchars(this._("btn_freeze")) + "\" />\n" + "</div>\n</form>\n";
            }
        } else if (this.function_freeze && this.argCheck("unfreeze", req) && !this.empty(page)) {
            String pass = req.getParameter("pass");
            if (this.empty(pass)) {
                pass = "";
            }
            log.debug((Object)"process unfreeze. ");
            if (!we.isFreeze(page)) {
                body = title = this.replace(we.stripBracket(page), this._("title_isunfreezed"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_isunfreezed"));
            } else if (WikiEngine.md5(pass.getBytes()).equals(this.adminpass) || req.isUserInRole("admin")) {
                String srcText;
                File lock = we.getLockFile(page);
                try {
                    srcText = we.getSourceText(page);
                    srcText = srcText.substring(srcText.indexOf(10) + 1);
                    we.fileWrite(we.getDataDir(), page, srcText, false);
                }
                catch (Throwable throwable) {
                    Object var17_32 = null;
                    lock.delete();
                    throw throwable;
                }
                Object var17_33 = null;
                lock.delete();
                log.debug((Object)("unfreezed. " + srcText.length()));
                title = this.replace(we.stripBracket(page), this._("title_unfreezed"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_unfreezed"));
                body = we.convertHtml(srcText);
            } else {
                log.debug((Object)"unfreeze password required.");
                title = this.replace(we.stripBracket(page), this._("title_unfreeze"));
                pageSearch = this.strReplace("$1", this.makeSearch(page, we), this._("title_unfreeze"));
                body = "<br />\n";
                body = !this.empty(pass) ? String.valueOf(body) + "<strong>" + this._("msg_invalidpass") + "</strong><br/>\n" : String.valueOf(body) + this._("msg_unfreezing") + "<br/>\n";
                body = String.valueOf(body) + "<form action=\"" + we.script + "?cmd=unfreeze\" method=\"post\">\n" + "<div>\n" + "<input type=\"hidden\" name=\"page\" value=\"" + WikiServlet.htmlspecialchars(page) + "\" />\n" + "<input type=\"password\" name=\"pass\" size=\"12\" />\n" + "<input type=\"submit\" name=\"ok\" value=\"" + this._("btn_unfreeze") + "\" />\n" + "</div>\n</form>\n";
            }
        }
        req.setAttribute("pageEncoding", (Object)we.encode(page));
        req.setAttribute("pageSource", (Object)sourceText);
        req.setAttribute("pageSearch", (Object)pageSearch);
        req.setAttribute("pageName", (Object)we.urlEncode(page));
        req.setAttribute("title", (Object)title);
        req.setAttribute("body", (Object)body);
        req.setAttribute("footnote", (Object)we.getFootNoteText());
        req.setAttribute("procTime", (Object)new Long(pstart));
        req.setAttribute("attachList", (Object)this.getAttachList(page, we));
        this.doForward(req, res);
    }

    String redirectName(String script, String wikiname, String pathInfo) {
        if (this.empty(script)) {
            script = pathInfo;
        }
        if (script.startsWith("/")) {
            script = script.substring(1);
        }
        return String.valueOf(script) + "?" + wikiname;
    }

    static class Redirect
    extends RuntimeException {
        String location;

        Redirect(String t) {
            this.location = t;
        }
    }

    private static class WReq
    extends HttpServletRequestWrapper {
        String inputEncoding;

        WReq(HttpServletRequest req, String enc) {
            super(req);
            this.inputEncoding = enc;
        }

        public String getParameter(String t) {
            t = super.getParameter(t);
            try {
                return t != null ? new String(t.getBytes(WikiServlet.ISO8859_1), this.inputEncoding) : t;
            }
            catch (UnsupportedEncodingException ignore) {
                log.warn((Object)ignore);
                return t;
            }
        }
    }
}

