<%@ page contentType="text/html; charset=Shift_JIS" pageEncoding="EUC-JP" %>

<h2>Threads List</h2>

<p>VMǡɤΤ褦ʥåɤäƤ뤫ǧǤޤ

<p><pre><%= new threadsList().getList() %></pre>

<%! static class threadsList {

    static String info(Thread t) {
	return t == null ? "" : t.getName() + " Thread:" +
	    " Priority:" + t.getPriority() +
	    (t.isDaemon() ? " (Daemon)" : "") +
	    (t.isAlive() ? "\r\n" : " Not Alive\r\n");
    }
    
    StringBuffer buf;

    void tree_walk(ThreadGroup g, String indent) {
	if (g == null) return;
	
	Thread[] threads = new Thread[g.activeCount()];
	ThreadGroup[] group = new ThreadGroup[g.activeGroupCount()];
	
	g.enumerate(threads, false);
	g.enumerate(group, false);
	
	buf.append(indent + g.getName() + " Thread Group:" +
		   " Max priority:" + g.getMaxPriority() + 
		   ( g.isDaemon() ? " (Daemon)\r\n" : "\r\n"));
	
	for(int i = 0; i < threads.length; i++)
	    buf.append(indent + info(threads[i]));
	
	for(int i = 0; i < group.length; i++)
	    tree_walk(group[i], indent + "\t");
    }
    
    public StringBuffer getList() {

	ThreadGroup current_group = Thread.currentThread().getThreadGroup();
	
	ThreadGroup root = current_group, parent = root.getParent();
	
	while (parent != null) {
	    root = parent;
	    parent = parent.getParent();
	}
	
	// ʳǥ롼ȥåɥ롼פĤäƤ

	buf = new StringBuffer();
	
	tree_walk(root,"");
	
	return buf;
    }
}

%>

