/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jp.sourceforge.swf2bmp2avi.io.BinaryFileWriter;
import jp.sourceforge.swf2bmp2avi.io.BmpBinaryAccess;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class AviMaker {
    private static final int C_junkSize = 1816;
    private File aviFileName_;
    private int frameRate_;
    private int totalFrames_;
    private BmpBinaryAccess baseBmpInfo_;
    private BinaryFileWriter writer_;
    int imageBufferSize_;
    int colorMapSize_;
    int structSize_;

    public static void main(String[] pArg) {
        Shell shell = new Shell();
        FileDialog fd = new FileDialog(shell, 4098);
        String[] ext = new String[]{"*.bmp", "*.*"};
        fd.setFilterExtensions(ext);
        if (fd.open() == null) {
            return;
        }
        String[] bmpFiles = fd.getFileNames();
        String path = fd.getFilterPath();
        FileDialog fd2 = new FileDialog(shell, 8192);
        String[] ext2 = new String[]{"*.avi", "*.*"};
        fd2.setFilterExtensions(ext2);
        if (fd2.open() == null) {
            return;
        }
        File aviFile = new File(String.valueOf(path) + File.separator + fd2.getFileName());
        AviMaker self = null;
        try {
            try {
                self = new AviMaker(aviFile, 12, bmpFiles.length, String.valueOf(path) + File.separator + bmpFiles[0]);
                self.open();
                self.wraiteHeader();
                int i = 0;
                while (i < bmpFiles.length) {
                    self.writeBmp(String.valueOf(path) + File.separator + bmpFiles[i]);
                    ++i;
                }
                self.wraiteIdx1();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (self != null) {
                    self.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (self != null) {
                    self.close();
                }
            }
        }
        finally {
            if (self != null) {
                self.close();
            }
        }
    }

    public AviMaker(File pAviFileName, int pFps, int pTotalFrames, String pBaseBmpPath) throws FileNotFoundException, Throwable {
        this.aviFileName_ = pAviFileName;
        this.frameRate_ = pFps;
        this.totalFrames_ = pTotalFrames;
        this.baseBmpInfo_ = new BmpBinaryAccess(pBaseBmpPath, false);
        this.imageBufferSize_ = this.baseBmpInfo_.getImageBufferSize();
        this.colorMapSize_ = this.baseBmpInfo_.getColorMapSize();
        this.structSize_ = 2048 + this.totalFrames_ * 16 + this.totalFrames_ * (8 + this.imageBufferSize_);
    }

    public void open() throws IOException {
        this.writer_ = new BinaryFileWriter();
        this.writer_.open(this.aviFileName_);
    }

    public void close() {
        if (this.writer_ != null) {
            this.writer_.close();
        }
    }

    public void wraiteHeader() throws IOException {
        this.writer_.put(new String("RIFF").getBytes());
        this.writer_.putInt(this.structSize_);
        this.writer_.put(new String("AVI ").getBytes());
        this.writer_.writeBuffer();
        this.writeHeader_LIST_hdrl();
        this.writeHeader_JUNK();
        this.writeHeader_LIST_movi();
    }

    private void writeHeader_LIST_hdrl() throws IOException {
        this.writer_.put(new String("LIST").getBytes());
        this.writer_.putInt(192 + this.colorMapSize_);
        this.writer_.put(new String("hdrl").getBytes());
        this.writer_.writeBuffer();
        this.writeHeader_LIST_hdrl_avih();
        this.writeHeader_LIST_hdrl_LIST_strl();
    }

    private void writeHeader_LIST_hdrl_avih() throws IOException {
        int avihMicroSecPerFrame = 500000;
        int avihMaxBytesPerSec = 32;
        int avihPaddingGranularity = 0;
        int avihFlags = 2064;
        int avihTotalFrames = this.totalFrames_;
        int avihInitialFrames = 0;
        int avihStreams = 1;
        int avihSuggestedBufferSize = this.baseBmpInfo_.getImageBufferSize();
        int avihWidth = this.baseBmpInfo_.getWidth();
        int avihHeight = this.baseBmpInfo_.getHeight();
        int avihReserved0 = 0;
        int avihReserved1 = 0;
        int avihReserved2 = 0;
        int avihReserved3 = 0;
        this.writer_.put(new String("avih").getBytes());
        this.writer_.putInt(56);
        this.writer_.putInt(avihMicroSecPerFrame);
        this.writer_.putInt(avihMaxBytesPerSec);
        this.writer_.putInt(avihPaddingGranularity);
        this.writer_.putInt(avihFlags);
        this.writer_.putInt(avihTotalFrames);
        this.writer_.putInt(avihInitialFrames);
        this.writer_.putInt(avihStreams);
        this.writer_.putInt(avihSuggestedBufferSize);
        this.writer_.putInt(avihWidth);
        this.writer_.putInt(avihHeight);
        this.writer_.putInt(avihReserved0);
        this.writer_.putInt(avihReserved1);
        this.writer_.putInt(avihReserved2);
        this.writer_.putInt(avihReserved3);
        this.writer_.writeBuffer();
    }

    private void writeHeader_LIST_hdrl_LIST_strl() throws IOException {
        this.writer_.put(new String("LIST").getBytes());
        this.writer_.putInt(116 + this.colorMapSize_);
        this.writer_.put(new String("strl").getBytes());
        this.writer_.writeBuffer();
        this.writeHeader_LIST_hdrl_LIST_strl_strh();
        this.writeHeader_LIST_hdrl_LIST_strl_strf();
    }

    private void writeHeader_LIST_hdrl_LIST_strl_strh() throws IOException {
        int strhfccHandler = 0;
        int strhFlags = 0;
        short strhwPriority = 0;
        short strhwLanguage = 0;
        int strhInitialFrames = 0;
        int strhScale = 1;
        int strhRate = this.frameRate_;
        int strhStart = 0;
        int strhLength = this.totalFrames_;
        int strhSuggestedBufferSize = this.baseBmpInfo_.getImageBufferSize();
        int strhQuality = -1;
        int strhSampleSize = 0;
        int strhDummy = 0;
        this.writer_.put(new String("strh").getBytes());
        this.writer_.putInt(56);
        this.writer_.put(new String("vids").getBytes());
        this.writer_.putInt(strhfccHandler);
        this.writer_.putInt(strhFlags);
        this.writer_.putShort(strhwPriority);
        this.writer_.putShort(strhwLanguage);
        this.writer_.putInt(strhInitialFrames);
        this.writer_.putInt(strhScale);
        this.writer_.putInt(strhRate);
        this.writer_.putInt(strhStart);
        this.writer_.putInt(strhLength);
        this.writer_.putInt(strhSuggestedBufferSize);
        this.writer_.putInt(strhQuality);
        this.writer_.putInt(strhSampleSize);
        this.writer_.putInt(strhDummy);
        this.writer_.putInt(strhDummy);
        this.writer_.writeBuffer();
    }

    private void writeHeader_LIST_hdrl_LIST_strl_strf() throws IOException {
        int imageWidth = this.baseBmpInfo_.getWidth();
        int imageHeight = this.baseBmpInfo_.getHeight();
        int bitCount = this.baseBmpInfo_.getBitCount();
        int imageBufferSize = this.baseBmpInfo_.getImageBufferSize();
        int colormapSize = this.baseBmpInfo_.getColorMapSize();
        int nColors = 0;
        if (bitCount == 8) {
            nColors = 256;
        }
        byte[] colormap = new byte[colormapSize];
        this.writer_.put(new String("strf").getBytes());
        this.writer_.putInt(40 + this.colorMapSize_);
        this.writer_.putInt(40);
        this.writer_.putInt(imageWidth);
        this.writer_.putInt(imageHeight);
        this.writer_.putShort((short)1);
        int writeBitCount = bitCount;
        if (writeBitCount == 1) {
            writeBitCount = 24;
        }
        this.writer_.putShort((short)writeBitCount);
        this.writer_.putInt(0);
        this.writer_.putInt(imageBufferSize);
        this.writer_.putInt(0);
        this.writer_.putInt(0);
        this.writer_.putInt(nColors);
        this.writer_.putInt(nColors);
        this.writer_.put(colormap);
        this.writer_.writeBuffer();
    }

    private void writeHeader_JUNK() throws IOException {
        this.writer_.put(new String("JUNK").getBytes());
        this.writer_.putInt(1816 - this.colorMapSize_);
        int cnt = (1816 - this.colorMapSize_) / 4;
        int junkIdx = 0;
        while (junkIdx < cnt) {
            this.writer_.putInt(0);
            ++junkIdx;
        }
        this.writer_.writeBuffer();
    }

    private void writeHeader_LIST_movi() throws IOException {
        this.writer_.put(new String("LIST").getBytes());
        this.writer_.putInt(4 + this.totalFrames_ * (8 + this.imageBufferSize_));
        this.writer_.put(new String("movi").getBytes());
        this.writer_.writeBuffer();
    }

    public void writeBmp(String pBmpFilePath) throws FileNotFoundException, IOException {
        this.writer_.put(new String("00db").getBytes());
        System.out.println("AVI\u30c7\u30fc\u30bf\u51fa\u529b\u4e2dBMP:" + pBmpFilePath);
        BmpBinaryAccess bmp = new BmpBinaryAccess(pBmpFilePath);
        this.writer_.putInt(bmp.getImageBufferSize());
        this.writer_.put(bmp.getSourceImage());
        this.writer_.writeBuffer();
    }

    public void wraiteIdx1() throws IOException {
        this.writer_.put(new String("idx1").getBytes());
        this.writer_.putInt(this.totalFrames_ * 16);
        int offset = 4;
        int idx = 0;
        while (idx < this.totalFrames_) {
            this.writer_.put(new String("00db").getBytes());
            this.writer_.putInt(16);
            this.writer_.putInt(offset);
            this.writer_.putInt(this.imageBufferSize_);
            offset = offset + this.imageBufferSize_ + 8;
            ++idx;
        }
        this.writer_.writeBuffer();
    }
}

