/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import jp.sourceforge.swf2bmp2avi.util.DDD;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class BinaryFileAccess {
    protected ByteBuffer buffer_;
    private boolean isLittleEndian;
    private String readFileName_;

    public BinaryFileAccess() {
        this(true);
    }

    public BinaryFileAccess(boolean pIsLittelEndian) {
        this.isLittleEndian = pIsLittelEndian;
    }

    public static void main(String[] pArg) {
        try {
            BinaryFileAccess self = new BinaryFileAccess();
            Shell shell = new Shell();
            FileDialog fd = new FileDialog(shell);
            String[] ext = new String[]{"*.swf", "*.*"};
            fd.setFilterExtensions(ext);
            String f = fd.open();
            if (f != null) {
                self.read(f);
                self.dbgDipsBuff();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void dbgDipsBuff() {
        this.buffer_.clear();
        System.gc();
        System.out.println("--: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
        byte[] bytes = new byte[this.buffer_.capacity()];
        System.out.println("--: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
        this.buffer_.get(bytes);
        System.out.println("--: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
        DDD.dumpHex(bytes);
    }

    public void read(String pFileName) throws IOException {
        FileInputStream stream = new FileInputStream(pFileName);
        FileChannel channel = stream.getChannel();
        this.buffer_ = ByteBuffer.allocate((int)channel.size());
        if (this.isLittleEndian) {
            this.buffer_.order(ByteOrder.LITTLE_ENDIAN);
        }
        channel.read(this.buffer_);
        channel.close();
        this.readFileName_ = pFileName;
    }

    public void write(String pFileName) throws IOException {
        FileOutputStream stream = new FileOutputStream(pFileName);
        FileChannel channel = stream.getChannel();
        this.buffer_.clear();
        channel.write(this.buffer_);
        channel.close();
    }

    public String getBufString() {
        String str = "";
        while (this.buffer_.hasRemaining()) {
            byte b = this.get();
            if (b == 0) break;
            str = String.valueOf(str) + (char)b;
        }
        return str;
    }

    public byte get() {
        return this.buffer_.get();
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        return this.buffer_.get(dst, offset, length);
    }

    public ByteBuffer get(byte[] dst) {
        return this.buffer_.get(dst);
    }

    public byte get(int index) {
        return this.buffer_.get(index);
    }

    public char getChar() {
        return this.buffer_.getChar();
    }

    public char getChar(int index) {
        return this.buffer_.getChar(index);
    }

    public double getDouble() {
        return this.buffer_.getDouble();
    }

    public double getDouble(int index) {
        return this.buffer_.getDouble(index);
    }

    public float getFloat() {
        return this.buffer_.getFloat();
    }

    public float getFloat(int index) {
        return this.buffer_.getFloat(index);
    }

    public int getInt() {
        return this.buffer_.getInt();
    }

    public int getInt(int index) {
        return this.buffer_.getInt(index);
    }

    public long getLong() {
        return this.buffer_.getLong();
    }

    public long getLong(int index) {
        return this.buffer_.getLong(index);
    }

    public short getShort() {
        return this.buffer_.getShort();
    }

    public short getShort(int index) {
        return this.buffer_.getShort(index);
    }

    public final ByteBuffer order(ByteOrder bo) {
        return this.buffer_.order(bo);
    }

    public ByteBuffer put(byte b) {
        return this.buffer_.put(b);
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        return this.buffer_.put(src, offset, length);
    }

    public final ByteBuffer put(byte[] src) {
        return this.buffer_.put(src);
    }

    public ByteBuffer put(ByteBuffer src) {
        return this.buffer_.put(src);
    }

    public ByteBuffer put(int index, byte b) {
        return this.buffer_.put(index, b);
    }

    public ByteBuffer putChar(char value) {
        return this.buffer_.putChar(value);
    }

    public ByteBuffer putChar(int index, char value) {
        return this.buffer_.putChar(index, value);
    }

    public ByteBuffer putDouble(double value) {
        return this.buffer_.putDouble(value);
    }

    public ByteBuffer putDouble(int index, double value) {
        return this.buffer_.putDouble(index, value);
    }

    public ByteBuffer putFloat(float value) {
        return this.buffer_.putFloat(value);
    }

    public ByteBuffer putFloat(int index, float value) {
        return this.buffer_.putFloat(index, value);
    }

    public ByteBuffer putInt(int index, int value) {
        return this.buffer_.putInt(index, value);
    }

    public ByteBuffer putInt(int value) {
        return this.buffer_.putInt(value);
    }

    public ByteBuffer putLong(int index, long value) {
        return this.buffer_.putLong(index, value);
    }

    public ByteBuffer putLong(long value) {
        return this.buffer_.putLong(value);
    }

    public ByteBuffer putShort(int index, short value) {
        return this.buffer_.putShort(index, value);
    }

    public ByteBuffer putShort(short value) {
        return this.buffer_.putShort(value);
    }

    public final int position() {
        return this.buffer_.position();
    }

    public final Buffer position(int newPosition) {
        return this.buffer_.position(newPosition);
    }

    public final Buffer mark() {
        return this.buffer_.mark();
    }

    public final Buffer reset() {
        return this.buffer_.reset();
    }

    public final Buffer clear() {
        return this.buffer_.clear();
    }

    public final Buffer flip() {
        return this.buffer_.flip();
    }

    public final Buffer rewind() {
        return this.buffer_.rewind();
    }

    public final int capacity() {
        return this.buffer_.capacity();
    }

    public final int limit() {
        return this.buffer_.limit();
    }

    public final Buffer limit(int pNewLimit) {
        return this.buffer_.limit(pNewLimit);
    }

    protected ByteBuffer getBuffer() {
        return this.buffer_;
    }

    protected ByteBuffer slice() {
        return this.buffer_.slice();
    }

    protected ByteBuffer slice(int pPosition, int pSize) {
        int beforePos = this.buffer_.position();
        int beforeLimit = this.buffer_.limit();
        this.buffer_.position(pPosition);
        this.buffer_.limit(pPosition + pSize);
        ByteBuffer childBuff = this.buffer_.slice();
        childBuff.order(this.buffer_.order());
        this.buffer_.limit(beforeLimit);
        this.buffer_.position(beforePos);
        return childBuff;
    }

    protected ByteBuffer sliceCopy(int pPosition, int pSize) {
        ByteBuffer slice = this.slice(pPosition, pSize);
        ByteBuffer copyBuff = ByteBuffer.allocate(slice.capacity());
        copyBuff.put(slice);
        copyBuff.order(slice.order());
        copyBuff.clear();
        return copyBuff;
    }

    public String getReadFileName() {
        return this.readFileName_;
    }

    protected void setReadFileName(String pFileName) {
        this.readFileName_ = pFileName;
    }
}

