/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import jp.sourceforge.swf2bmp2avi.io.AviMaker;
import jp.sourceforge.swf2bmp2avi.io.BmpBinaryAccess;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.plugin.BmpInfo;
import jp.sourceforge.swf2bmp2avi.process.FFmpegProcessRunner;
import jp.sourceforge.swf2bmp2avi.process.ProcessRunListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovieCreator
implements IRunnableWithProgress {
    public static final String[] SELECT_MOVIE_COMPRESS = new String[]{"\u7121\u5727\u7e2e(\u5185\u90e8\u30b3\u30fc\u30c9\u751f\u6210\u3002\u97f3\u58f0\u306a\u3057)", "\u7121\u5727\u7e2e [rawvideo]", "\u53ef\u9006\u5727\u7e2e [huffyuv]", "Motion JPEG(MJPG) [libxvid]", "Mpeg4 [mpeg4]", "DivX3/MS MPEG4-V3(DIV3) [msmpeg4]", "Microsoft MPEG4-V2 [msmpeg4v2]", "Windows Media Video 7 [wmv1]", "Windows Media Video 8 [wmv2]"};
    public static final String[] SELECT_MOVIE_COMPRESS_NAME = new String[]{"", "rawvideo", "huffyuv", "mjpeg", "mpeg4", "msmpeg4", "msmpeg4v2", "wmv1", "wmv2"};
    private static String FFMPREG_EXE_PATH = "lib/ffmpeg_bin-22772/ffmpeg.exe";
    private Shell shell_;
    private int movieCompressIndex_;
    private boolean isAttachSound_;
    private File attachSoundFile_;
    private String bmpDir_;
    ArrayList<BmpInfo> bmpList_;
    private File aviFile_;
    private int fps_;
    private String bitRate_;

    public MovieCreator(Shell pShell) {
        this.shell_ = pShell;
    }

    private void log(String pMsg) {
        Activator.msg("[" + this.getClass().getSimpleName() + "]" + pMsg);
    }

    public void run(IProgressMonitor pMonitor) throws InvocationTargetException, InterruptedException {
        if (this.movieCompressIndex_ < 0) {
            throw new InterruptedException("\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\u306e\u305f\u3081");
        }
        if (this.movieCompressIndex_ == 0) {
            this.createNoCompressAvi(pMonitor);
        } else {
            this.createAviByFFmpeg(pMonitor);
        }
    }

    public void createNoCompressAvi(IProgressMonitor pMonitor) throws InterruptedException {
        ArrayList<BmpInfo> bmpList = this.getBmpList();
        AviMaker aviMaker = null;
        pMonitor.beginTask("AVI\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3057\u3066\u3044\u307e\u3059\u3002", bmpList.size());
        try {
            try {
                pMonitor.subTask("BMP\u30ea\u30b9\u30c8\u914d\u5217\u6e96\u5099\u3002");
                String[] targetBmpAry = new String[bmpList.size()];
                Iterator<BmpInfo> ite = bmpList.iterator();
                int i = 0;
                while (ite.hasNext()) {
                    BmpInfo info = ite.next();
                    targetBmpAry[i] = info.getFileFullPath();
                    ++i;
                }
                if (pMonitor.isCanceled()) {
                    throw new InterruptedException("\u51e6\u7406\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f");
                }
                pMonitor.subTask("AVI\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u6e96\u5099\u3002");
                aviMaker = new AviMaker(this.getAviFile(), this.getFps(), targetBmpAry.length, targetBmpAry[0]);
                aviMaker.open();
                if (pMonitor.isCanceled()) {
                    throw new InterruptedException("\u51e6\u7406\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f");
                }
                pMonitor.subTask("AVI\u30d5\u30a1\u30a4\u30eb\u30d8\u30c3\u30c0\u51fa\u529b");
                aviMaker.wraiteHeader();
                if (pMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                i = 0;
                while (i < targetBmpAry.length) {
                    pMonitor.subTask("BMP\u30c7\u30fc\u30bf\uff1a" + targetBmpAry[i]);
                    if (pMonitor.isCanceled()) {
                        throw new InterruptedException("\u51e6\u7406\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f");
                    }
                    aviMaker.writeBmp(targetBmpAry[i]);
                    pMonitor.worked(1);
                    Thread.sleep(50L);
                    ++i;
                }
                pMonitor.subTask("AVI\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u60c5\u5831\u51fa\u529b");
                aviMaker.wraiteIdx1();
                pMonitor.worked(1);
                Thread.sleep(50L);
                pMonitor.subTask("\u3067\u3051\u305f\uff3c(^o^)\uff0f");
                Thread.sleep(500L);
                pMonitor.done();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                this.showMessage("\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\n" + ex);
                throw new InterruptedException();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.showMessage("\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\n" + ex);
                throw new InterruptedException();
            }
            catch (Throwable err) {
                err.printStackTrace();
                this.showMessage("\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\n" + err.toString());
                throw new InterruptedException();
            }
        }
        finally {
            if (aviMaker != null) {
                aviMaker.close();
            }
        }
    }

    public void createAviByFFmpeg(final IProgressMonitor pMonitor) throws InterruptedException {
        System.out.println("AVI\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3057\u3066\u3044\u307e\u3059\u3002(\u5408\u8a08:" + this.bmpList_.size() + " frame)");
        pMonitor.beginTask("AVI\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3057\u3066\u3044\u307e\u3059\u3002(\u5408\u8a08:" + this.bmpList_.size() + " frame)", this.bmpList_.size());
        BmpInfo topBmpInfo = this.bmpList_.get(0);
        try {
            BmpBinaryAccess readBmp = new BmpBinaryAccess(this.bmpList_.get(0).getFileFullPath(), false);
            topBmpInfo.setWidth(readBmp.getWidth());
            topBmpInfo.setHeight(readBmp.getHeight());
            topBmpInfo.setDeep(readBmp.getBitCount());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InterruptedException(e.getMessage());
        }
        pMonitor.subTask("ffmpeg\u30d7\u30ed\u30bb\u30b9\u6e96\u5099");
        String ffmpegPath = Activator.getDefault().getStateLocationFileAsCopyFromJar(FFMPREG_EXE_PATH);
        System.out.println("FFMPEG\u30d7\u30ed\u30b0\u30e9\u30e0\u30d1\u30b9\uff1a" + ffmpegPath);
        FFmpegProcessRunner ffmpegProc = new FFmpegProcessRunner(new File(ffmpegPath));
        ffmpegProc.setInputFile(String.valueOf(this.bmpDir_) + File.separator + this.getBmpFileNameMatrix());
        ffmpegProc.setOutputFile(this.getAviFile().getAbsolutePath());
        String codec = SELECT_MOVIE_COMPRESS_NAME[this.getMovieCompressIndex()];
        if (codec != null && codec.length() > 0) {
            ffmpegProc.setVideoCodec(codec);
        }
        ffmpegProc.setVideoFrames(this.bmpList_.size());
        ffmpegProc.setVideoFPS(this.getFps());
        ffmpegProc.setVideoSize(topBmpInfo.getWidth() + "x" + topBmpInfo.getHeight());
        if (topBmpInfo.getWidth() * 3 == topBmpInfo.getHeight() * 4) {
            ffmpegProc.setVideoAspect("4:3");
        } else if (topBmpInfo.getWidth() * 9 == topBmpInfo.getHeight() * 16) {
            ffmpegProc.setVideoAspect("16:9");
        } else {
            ffmpegProc.setVideoAspect(topBmpInfo.getWidth() + ":" + topBmpInfo.getHeight());
        }
        ffmpegProc.setVideoBitrate(this.bitRate_);
        if (this.attachSoundFile_ != null && this.attachSoundFile_.exists()) {
            ffmpegProc.setAudioInputFile(this.attachSoundFile_.getAbsolutePath());
            ffmpegProc.setAudioBitrate("128k");
        }
        ffmpegProc.addProcessRunEventListener(new ProcessRunListener(){
            private int beforeFrame = 0;

            public void onSysoutMessage(String pMessage) {
                MovieCreator.this.log(pMessage);
            }

            public void onErroutMessage(String pMessage) {
                if (pMessage.startsWith("frame=")) {
                    String[] strAry = pMessage.split("\\s+", 0);
                    try {
                        if (strAry.length >= 1) {
                            int frame = Integer.parseInt(strAry[1].trim());
                            MovieCreator.this.log(".... [" + strAry[1].trim() + "]  (" + pMessage + ") ..." + frame + " - " + this.beforeFrame + " = " + (frame - this.beforeFrame) + "/" + MovieCreator.this.bmpList_.size());
                            pMonitor.worked(frame - this.beforeFrame);
                            this.beforeFrame = frame;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MovieCreator.this.log(".... " + pMessage);
                    }
                } else if (pMessage.startsWith("Could not open")) {
                    MovieCreator.this.log(".... \u30a8\u30e9\u30fc\u3063\u307d\u3044");
                } else {
                    MovieCreator.this.log(pMessage);
                }
            }
        });
        pMonitor.subTask("ffmpeg\u51fa\u529b\u958b\u59cb");
        ffmpegProc.execComvert();
        pMonitor.subTask("\u3067\u3051\u305f\uff3c(^o^)\uff0f");
        pMonitor.worked(1);
        pMonitor.done();
    }

    public String getBmpFileNameMatrix() {
        int numLength = "000000".length();
        return "s2b2a_%0" + numLength + "d" + ".bmp";
    }

    private void showMessage(String pMsg) {
    }

    public ArrayList<BmpInfo> getBmpList() {
        return this.bmpList_;
    }

    public void setBmpList(ArrayList<BmpInfo> pBmpList) {
        this.bmpList_ = pBmpList;
    }

    public int getMovieCompressIndex() {
        return this.movieCompressIndex_;
    }

    public void setMovieCompressIndex(int pMovieCompressIndex) {
        this.movieCompressIndex_ = pMovieCompressIndex;
    }

    public String getBmpDir() {
        return this.bmpDir_;
    }

    public void setBmpDir(String pBmpDir) {
        this.bmpDir_ = pBmpDir;
    }

    public File getAviFile() {
        return this.aviFile_;
    }

    public void setAviFile(File pAviFile) {
        this.aviFile_ = pAviFile;
    }

    public int getFps() {
        return this.fps_;
    }

    public void setFps(int pFps) {
        this.fps_ = pFps;
    }

    public boolean isAttachSound() {
        return this.isAttachSound_;
    }

    public void setIsAttachSound(boolean pIsAttachSound) {
        this.isAttachSound_ = pIsAttachSound;
    }

    public File getAttachSoundFile() {
        return this.attachSoundFile_;
    }

    public void setAttachSoundFile(File pAttachSoundFile) {
        this.attachSoundFile_ = pAttachSoundFile;
    }

    public String getBitRate() {
        return this.bitRate_;
    }

    public void setBitRate(String pBitRate) {
        this.bitRate_ = pBitRate;
    }
}

