/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import jp.sourceforge.swf2bmp2avi.io.swf.ISwfAnalyzeEventListener;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfAnalyzeEvent;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfFile;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SwfManager
implements ISwfAnalyzeEventListener {
    private static SwfManager singlton_;
    private File cacheDirectory_;
    private HashMap<String, String> swfCacheMap_ = new HashMap();
    private IProgressMonitor progressMonitor_;
    private SwfFile wkSwf;

    private SwfManager(File pCacheDir) {
        this.cacheDirectory_ = pCacheDir;
    }

    public static SwfManager getInstance() {
        if (singlton_ == null) {
            try {
                singlton_ = new SwfManager(Activator.getDefault().getTmpDir());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return singlton_;
    }

    public SwfFile getUncompressSwfFile(String pPath) throws IOException {
        File baseFile = new File(pPath);
        if (!baseFile.exists() || !baseFile.isFile()) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30a2\u30af\u30bb\u30b9\u4e0d\u80fd\uff1a" + pPath);
        }
        SwfFile swf = null;
        String cachePath = this.swfCacheMap_.get(pPath);
        if (cachePath == null) {
            System.out.println("\u672a\u767b\u9332\u306e\u30d1\u30b9\u306e\u5834\u5408:\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u65b0\u898f\u4f5c\u6210\uff1a\u958b\u59cb");
            swf = new SwfFile();
            swf.addSwfAnalyzeEventListener(this);
            swf.read(pPath, this.cacheDirectory_);
            this.swfCacheMap_.put(pPath, swf.getReadFileName());
            System.out.println("\u672a\u767b\u9332\u306e\u30d1\u30b9\u306e\u5834\u5408:\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u65b0\u898f\u4f5c\u6210\uff1a\u7d42\u4e86");
        } else {
            File cacheFile = new File(cachePath);
            if (!baseFile.exists() || baseFile.lastModified() > cacheFile.lastModified()) {
                System.out.println("\u30d1\u30b9\u767b\u9332\u6e08\u3067\u3082\u53e4\u3044\u5834\u5408:\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u30fb\u518d\u4f5c\u6210\u4f5c\u6210\uff1a\u958b\u59cb");
                this.swfCacheMap_.remove(pPath);
                cacheFile.delete();
                swf = new SwfFile();
                swf.addSwfAnalyzeEventListener(this);
                swf.read(pPath, this.cacheDirectory_);
                this.swfCacheMap_.put(pPath, swf.getReadFileName());
                System.out.println("\u30d1\u30b9\u767b\u9332\u6e08\u3067\u3082\u53e4\u3044\u5834\u5408:\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u30fb\u518d\u4f5c\u6210\u4f5c\u6210\uff1a\u7d42\u4e86");
            } else {
                System.out.println("\u30d1\u30b9\u767b\u9332\u6e08\u306e\u5834\u5408:\u901a\u5e38\u8aad\u8fbc\u307f\uff1a\u7d42\u4e86");
                swf = new SwfFile();
                swf.addSwfAnalyzeEventListener(this);
                swf.read(cachePath, this.cacheDirectory_);
                System.out.println("\u30d1\u30b9\u767b\u9332\u6e08\u306e\u5834\u5408:\u901a\u5e38\u8aad\u8fbc\u307f\uff1a\u7d42\u4e86");
            }
        }
        return swf;
    }

    public SwfFile getUncompressSwfFileWithProgres(final String pPath) throws IOException {
        this.wkSwf = null;
        try {
            new ProgressMonitorDialog(null).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor pMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SwfManager.this.setProgressMonitor(pMonitor);
                        SwfManager.this.wkSwf = SwfManager.this.getUncompressSwfFile(pPath);
                        SwfManager.this.setProgressMonitor(null);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new InterruptedException(e.getMessage());
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.wkSwf;
    }

    public void onAnalyzing(SwfAnalyzeEvent pEvent) {
        if (pEvent.getEventID() == 1) {
            this.progresBeginTask(pEvent.getMessag(), pEvent.getWorkingCount());
        } else if (pEvent.getEventID() == 3) {
            this.progressDone();
        } else if (pEvent.getEventID() == 2) {
            this.progressSubTask(pEvent.getMessag());
        } else if (pEvent.getEventID() == 11) {
            this.progresBeginTask(pEvent.getMessag(), pEvent.getWorkingCount());
        } else if (pEvent.getEventID() == 12) {
            this.progressDone();
        } else if (pEvent.getEventID() == 21) {
            this.progresBeginTask(pEvent.getMessag(), pEvent.getWorkingCount());
        } else if (pEvent.getEventID() == 22) {
            this.progressDone();
        } else if (pEvent.getEventID() == 31) {
            this.progresBeginTask(pEvent.getMessag(), pEvent.getWorkingCount());
        } else if (pEvent.getEventID() == 32) {
            this.progressDone();
        } else if (pEvent.getEventID() == 5) {
            this.progressSubTask(pEvent.getMessag());
        } else if (pEvent.getEventID() == 4) {
            this.progressWorked(pEvent.getWorkingCount());
        }
    }

    public String createTempNoSound(String pReadSwFileName, int pForceFps, File pTmpDir) throws IOException {
        SwfFile swf = new SwfFile();
        swf.read(pReadSwFileName);
        return this.createTempNoSound(swf, pForceFps, pTmpDir);
    }

    public String createTempNoSound(final SwfFile pReadSwFile, final int pForceFps, File pTmpDir) throws IOException {
        final File tmpFile = File.createTempFile("s2b2a_tmp_", ".swf", pTmpDir);
        tmpFile.deleteOnExit();
        try {
            pReadSwFile.addSwfAnalyzeEventListener(this);
            new ProgressMonitorDialog(null).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor pMonitor) throws InvocationTargetException, InterruptedException {
                    pMonitor.beginTask("\u6e96\u5099\u4e2d", pReadSwFile.getSwfFileLenght());
                    SwfManager.this.setProgressMonitor(pMonitor);
                    pReadSwFile.write(tmpFile.getAbsolutePath(), pForceFps, true);
                    SwfManager.this.setProgressMonitor(null);
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return tmpFile.getAbsolutePath();
    }

    public void setProgressMonitor(IProgressMonitor pMonitor) {
        this.progressMonitor_ = pMonitor;
    }

    private void progresBeginTask(String pTaskMsg, int pTotalWorks) {
        if (this.progressMonitor_ != null) {
            this.progressMonitor_.beginTask(pTaskMsg, pTotalWorks);
        }
    }

    private void progressWorked(int pWork) {
        if (this.progressMonitor_ != null) {
            this.progressMonitor_.worked(pWork);
        }
    }

    private void progressSubTask(String pTaskMsg) {
        if (this.progressMonitor_ != null) {
            this.progressMonitor_.subTask(pTaskMsg);
        }
    }

    private void progressDone() {
        if (this.progressMonitor_ != null) {
            this.progressMonitor_.done();
        }
    }
}

